/*
 * Decompiled with CFR 0.152.
 */
package boofcv.kotlin;

import boofcv.alg.color.ColorRgb;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0004\u001a1\u0010\u0005\u001a\u0002H\u0006\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a7\u0010\u0005\u001a\u0002H\u0006\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000e\u001a\u0014\u0010\u000f\u001a\u00020\u0002*\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\u0010\u001a\u00020\u0003*\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a7\u0010\u0011\u001a\u0002H\u0006\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0012*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00132\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0014\u001a.\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0016\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0016*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\r\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0001\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0001\u001a.\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0004\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\r\u001a\u0010\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u0001\u001a\u0010\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u0004*\u00020\u0001\u001a7\u0010\u001e\u001a\u0002H\u0006\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0012*\u00020\u001f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00132\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"asBufferedImage", "Ljava/awt/image/BufferedImage;", "Lboofcv/struct/image/GrayF32;", "Lboofcv/struct/image/GrayU8;", "Lboofcv/struct/image/Planar;", "asGray", "T", "Lboofcv/struct/image/ImageGray;", "type", "Lboofcv/struct/image/ImageDataType;", "weighted", "", "(Ljava/awt/image/BufferedImage;Lboofcv/struct/image/ImageDataType;Z)Lboofcv/struct/image/ImageGray;", "Ljava/lang/Class;", "(Ljava/awt/image/BufferedImage;Ljava/lang/Class;Z)Lboofcv/struct/image/ImageGray;", "asGrayF32", "asGrayU8", "asImage", "Lboofcv/struct/image/ImageBase;", "Lboofcv/struct/image/ImageType;", "(Ljava/awt/image/BufferedImage;Lboofcv/struct/image/ImageType;Z)Lboofcv/struct/image/ImageBase;", "asInterleaved", "Lboofcv/struct/image/ImageInterleaved;", "asInterleavedF32", "Lboofcv/struct/image/InterleavedF32;", "asInterleavedU8", "Lboofcv/struct/image/InterleavedU8;", "asPlanar", "asPlanarF32", "asPlanarU8", "loadImage", "Ljava/io/File;", "(Ljava/io/File;Lboofcv/struct/image/ImageType;Z)Lboofcv/struct/image/ImageBase;", "boofcv-kotlin"})
public final class KImageIOKt {
    @NotNull
    public static final BufferedImage asBufferedImage(@NotNull GrayF32 $this$asBufferedImage) {
        Intrinsics.checkNotNullParameter((Object)$this$asBufferedImage, (String)"<this>");
        BufferedImage bufferedImage = ConvertBufferedImage.convertTo((ImageBase)((ImageBase)$this$asBufferedImage), null, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"convertTo(this, null, true)");
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage asBufferedImage(@NotNull GrayU8 $this$asBufferedImage) {
        Intrinsics.checkNotNullParameter((Object)$this$asBufferedImage, (String)"<this>");
        BufferedImage bufferedImage = ConvertBufferedImage.convertTo((ImageBase)((ImageBase)$this$asBufferedImage), null, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"convertTo(this, null, true)");
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage asBufferedImage(@NotNull Planar<?> $this$asBufferedImage) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter($this$asBufferedImage, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$asBufferedImage.getBandType(), GrayU8.class)) {
            BufferedImage bufferedImage2 = ConvertBufferedImage.convertTo_U8($this$asBufferedImage, null, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"convertTo_U8(this as Planar<GrayU8>, null, true)");
            bufferedImage = bufferedImage2;
        } else if (Intrinsics.areEqual((Object)$this$asBufferedImage.getBandType(), GrayF32.class)) {
            BufferedImage bufferedImage3 = ConvertBufferedImage.convertTo_F32($this$asBufferedImage, null, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage3, (String)"convertTo_F32(this as Planar<GrayF32>, null, true)");
            bufferedImage = bufferedImage3;
        } else {
            throw new IllegalArgumentException("Unknown plane type");
        }
        return bufferedImage;
    }

    @NotNull
    public static final <T extends ImageGray<T>> T asGray(@NotNull BufferedImage $this$asGray, @NotNull Class<T> type, boolean weighted) {
        Intrinsics.checkNotNullParameter((Object)$this$asGray, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        ImageDataType imageDataType = ImageDataType.classToType(type);
        if (imageDataType == null) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Invalid image type ", (Object)type.getClass().getSimpleName()));
        }
        ImageDataType dataType = imageDataType;
        return KImageIOKt.asGray($this$asGray, dataType, weighted);
    }

    public static /* synthetic */ ImageGray asGray$default(BufferedImage bufferedImage, Class clazz, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KImageIOKt.asGray(bufferedImage, clazz, bl);
    }

    @NotNull
    public static final <T extends ImageGray<T>> T asGray(@NotNull BufferedImage $this$asGray, @NotNull ImageDataType type, boolean weighted) {
        Intrinsics.checkNotNullParameter((Object)$this$asGray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ImageGray gray = (ImageGray)new ImageType(ImageType.Family.GRAY, type, 0).createImage($this$asGray.getWidth(), $this$asGray.getHeight());
        if (weighted) {
            Intrinsics.checkNotNullExpressionValue((Object)gray, (String)"gray");
            Planar<?> color = KImageIOKt.asPlanar($this$asGray, gray.getClass());
            ConvertBufferedImage.convertFrom((BufferedImage)$this$asGray, (ImageBase)((ImageBase)color), (boolean)true);
            ColorRgb.rgbToGray_Weighted((ImageMultiBand)((ImageMultiBand)color), (ImageGray)gray);
        } else {
            ConvertBufferedImage.convertFromSingle((BufferedImage)$this$asGray, (ImageGray)gray, gray.getClass());
        }
        Intrinsics.checkNotNullExpressionValue((Object)gray, (String)"gray");
        return (T)gray;
    }

    public static /* synthetic */ ImageGray asGray$default(BufferedImage bufferedImage, ImageDataType imageDataType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KImageIOKt.asGray(bufferedImage, imageDataType, bl);
    }

    @NotNull
    public static final <T extends ImageGray<T>> Planar<T> asPlanar(@NotNull BufferedImage $this$asPlanar, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)$this$asPlanar, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Planar dst = new Planar(type, $this$asPlanar.getWidth(), $this$asPlanar.getHeight(), 1);
        ConvertBufferedImage.convertFrom((BufferedImage)$this$asPlanar, (ImageBase)((ImageBase)dst), (boolean)true);
        return dst;
    }

    @NotNull
    public static final <T extends ImageInterleaved<T>> ImageInterleaved<T> asInterleaved(@NotNull BufferedImage $this$asInterleaved, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)$this$asInterleaved, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        ImageInterleaved imageInterleaved = GeneralizedImageOps.createInterleaved(type, (int)$this$asInterleaved.getWidth(), (int)$this$asInterleaved.getHeight(), (int)1);
        if (imageInterleaved == null) {
            throw new NullPointerException("null cannot be cast to non-null type T of boofcv.kotlin.KImageIOKt.asInterleaved");
        }
        ImageInterleaved dst = imageInterleaved;
        ConvertBufferedImage.convertFromInterleaved((BufferedImage)$this$asInterleaved, (ImageInterleaved)dst, (boolean)true);
        return dst;
    }

    @NotNull
    public static final GrayU8 asGrayU8(@NotNull BufferedImage $this$asGrayU8, boolean weighted) {
        Intrinsics.checkNotNullParameter((Object)$this$asGrayU8, (String)"<this>");
        return KImageIOKt.asGray($this$asGrayU8, GrayU8.class, weighted);
    }

    public static /* synthetic */ GrayU8 asGrayU8$default(BufferedImage bufferedImage, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return KImageIOKt.asGrayU8(bufferedImage, bl);
    }

    @NotNull
    public static final GrayF32 asGrayF32(@NotNull BufferedImage $this$asGrayF32, boolean weighted) {
        Intrinsics.checkNotNullParameter((Object)$this$asGrayF32, (String)"<this>");
        return KImageIOKt.asGray($this$asGrayF32, GrayF32.class, weighted);
    }

    public static /* synthetic */ GrayF32 asGrayF32$default(BufferedImage bufferedImage, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return KImageIOKt.asGrayF32(bufferedImage, bl);
    }

    @NotNull
    public static final Planar<GrayU8> asPlanarU8(@NotNull BufferedImage $this$asPlanarU8) {
        Intrinsics.checkNotNullParameter((Object)$this$asPlanarU8, (String)"<this>");
        ImageBase imageBase = ConvertBufferedImage.convertFrom((BufferedImage)$this$asPlanarU8, (boolean)true, (ImageType)ImageType.PL_U8);
        Intrinsics.checkNotNullExpressionValue((Object)imageBase, (String)"convertFrom(this, true, ImageType.PL_U8)");
        return (Planar)imageBase;
    }

    @NotNull
    public static final Planar<GrayF32> asPlanarF32(@NotNull BufferedImage $this$asPlanarF32) {
        Intrinsics.checkNotNullParameter((Object)$this$asPlanarF32, (String)"<this>");
        ImageBase imageBase = ConvertBufferedImage.convertFrom((BufferedImage)$this$asPlanarF32, (boolean)true, (ImageType)ImageType.PL_F32);
        Intrinsics.checkNotNullExpressionValue((Object)imageBase, (String)"convertFrom(this, true, ImageType.PL_F32)");
        return (Planar)imageBase;
    }

    @NotNull
    public static final InterleavedU8 asInterleavedU8(@NotNull BufferedImage $this$asInterleavedU8) {
        Intrinsics.checkNotNullParameter((Object)$this$asInterleavedU8, (String)"<this>");
        ImageBase imageBase = ConvertBufferedImage.convertFrom((BufferedImage)$this$asInterleavedU8, (boolean)true, (ImageType)ImageType.IL_U8);
        Intrinsics.checkNotNullExpressionValue((Object)imageBase, (String)"convertFrom(this, true, ImageType.IL_U8)");
        return (InterleavedU8)imageBase;
    }

    @NotNull
    public static final InterleavedF32 asInterleavedF32(@NotNull BufferedImage $this$asInterleavedF32) {
        Intrinsics.checkNotNullParameter((Object)$this$asInterleavedF32, (String)"<this>");
        ImageBase imageBase = ConvertBufferedImage.convertFrom((BufferedImage)$this$asInterleavedF32, (boolean)true, (ImageType)ImageType.IL_F32);
        Intrinsics.checkNotNullExpressionValue((Object)imageBase, (String)"convertFrom(this, true, ImageType.IL_F32)");
        return (InterleavedF32)imageBase;
    }

    @NotNull
    public static final <T extends ImageBase<T>> T asImage(@NotNull BufferedImage $this$asImage, @NotNull ImageType<T> type, boolean weighted) {
        ImageBase imageBase;
        Intrinsics.checkNotNullParameter((Object)$this$asImage, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        ImageType.Family family = type.getFamily();
        if ((family == null ? -1 : WhenMappings.$EnumSwitchMapping$0[family.ordinal()]) == 1) {
            ImageDataType imageDataType = type.getDataType();
            Intrinsics.checkNotNullExpressionValue((Object)imageDataType, (String)"type.dataType");
            imageBase = (ImageBase)KImageIOKt.asGray($this$asImage, imageDataType, weighted);
        } else {
            ImageBase color = type.createImage($this$asImage.getWidth(), $this$asImage.getHeight());
            ConvertBufferedImage.convertFrom((BufferedImage)$this$asImage, (boolean)true, (ImageBase)color);
            ImageBase imageBase2 = color;
            Intrinsics.checkNotNullExpressionValue((Object)imageBase2, (String)"{\n            val color \u2026          color\n        }");
            imageBase = imageBase2;
        }
        return (T)imageBase;
    }

    public static /* synthetic */ ImageBase asImage$default(BufferedImage bufferedImage, ImageType imageType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KImageIOKt.asImage(bufferedImage, imageType, bl);
    }

    @NotNull
    public static final <T extends ImageBase<T>> T loadImage(@NotNull File $this$loadImage, @NotNull ImageType<T> type, boolean weighted) {
        Intrinsics.checkNotNullParameter((Object)$this$loadImage, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        BufferedImage bufferedImage = UtilImageIO.loadImage((String)$this$loadImage.getAbsolutePath());
        if (bufferedImage == null) {
            throw new IOException("Couldn't load image");
        }
        BufferedImage buffered = bufferedImage;
        return KImageIOKt.asImage(buffered, type, weighted);
    }

    public static /* synthetic */ ImageBase loadImage$default(File file, ImageType imageType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KImageIOKt.loadImage(file, imageType, bl);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageType.Family.values().length];
            nArray[ImageType.Family.GRAY.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

