/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.jcodec;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.jcodec.UtilJCodec;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.jcodec.api.FrameGrab;
import org.jcodec.api.JCodecException;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.Picture;

public class JCodecSimplified<T extends ImageBase>
implements SimpleImageSequence<T> {
    FrameGrab grabber;
    T image;
    ImageType<T> typeOutput;
    Picture frameCurrent;
    Picture frameNext;
    int frame = 0;
    String filename;

    public JCodecSimplified(String filename, ImageType<T> typeOutput) {
        this.image = typeOutput.createImage(1, 1);
        this.typeOutput = typeOutput;
        this.filename = filename;
        this.reset();
    }

    public int getNextWidth() {
        return this.frameNext.getWidth();
    }

    public int getNextHeight() {
        return this.frameNext.getHeight();
    }

    public boolean hasNext() {
        return this.frameNext != null;
    }

    public T next() {
        this.frameCurrent = this.frameNext;
        try {
            this.frameNext = this.grabber.getNativeFrame();
        }
        catch (IOException e) {
            this.frameNext = null;
        }
        this.image.reshape(this.frameCurrent.getWidth(), this.frameCurrent.getHeight());
        UtilJCodec.convertToBoof(this.frameCurrent, this.image);
        ++this.frame;
        return this.image;
    }

    public <InternalImage> InternalImage getGuiImage() {
        Planar boofColor = new Planar(GrayU8.class, this.frameCurrent.getWidth(), this.frameCurrent.getHeight(), 3);
        BufferedImage output = new BufferedImage(boofColor.width, boofColor.height, 1);
        UtilJCodec.convertToBoof(this.frameCurrent, (ImageBase)boofColor);
        ConvertBufferedImage.convertTo((ImageBase)boofColor, (BufferedImage)output, (boolean)true);
        return (InternalImage)output;
    }

    public void close() {
    }

    public int getFrameNumber() {
        return this.frame;
    }

    public void setLoop(boolean loop) {
        if (loop) {
            throw new IllegalArgumentException("Not supported");
        }
    }

    public ImageType<T> getImageType() {
        return this.typeOutput;
    }

    public void reset() {
        try {
            this.grabber = new FrameGrab((SeekableByteChannel)NIOUtils.readableFileChannel((File)new File(this.filename)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JCodecException e) {
            throw new RuntimeException(e);
        }
        try {
            this.frameCurrent = null;
            this.frameNext = this.grabber.getNativeFrame();
        }
        catch (IOException e) {
            this.frameNext = null;
        }
    }
}

