/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.exception.feign;

import feign.FeignException;
import feign.Request;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.bremersee.exception.ErrorCodeAware;
import org.bremersee.exception.HttpResponseHeadersAware;
import org.bremersee.exception.HttpStatusAware;
import org.bremersee.exception.RestApiExceptionAware;
import org.bremersee.exception.model.RestApiException;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class FeignClientException
extends FeignException
implements HttpStatusAware,
HttpResponseHeadersAware,
RestApiExceptionAware,
ErrorCodeAware {
    @Nullable
    private final Request request;
    @NotNull
    private final Map<String, ? extends Collection<String>> headers;
    @Nullable
    private final RestApiException restApiException;

    public FeignClientException(@Nullable Request request, @Nullable Map<String, ? extends Collection<String>> headers, int status, @Nullable String message, @Nullable RestApiException restApiException) {
        super(FeignClientException.resolveHttpStatusCode(status), StringUtils.hasText((String)message) ? message : "No message present.", request != null ? request.requestBody().asBytes() : null);
        this.request = request;
        this.headers = headers != null ? headers : Collections.emptyMap();
        this.restApiException = restApiException;
    }

    public Map<String, String> getHeaders() {
        return HttpResponseHeadersAware.createHeaders(this.getMultiValueHeaders());
    }

    public Map<String, ? extends Collection<String>> getMultiValueHeaders() {
        return this.headers;
    }

    public String getErrorCode() {
        return this.restApiException != null ? this.restApiException.getErrorCode() : null;
    }

    private static int resolveHttpStatusCode(int httpStatusCode) {
        HttpStatus httpStatus = HttpStatus.resolve((int)httpStatusCode);
        return httpStatus != null ? httpStatus.value() : HttpStatus.INTERNAL_SERVER_ERROR.value();
    }

    @Nullable
    public Request getRequest() {
        return this.request;
    }

    @Nullable
    public RestApiException getRestApiException() {
        return this.restApiException;
    }
}

