/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.exception.feign;

import feign.Request;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.Reader;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bremersee.exception.RestApiExceptionParser;
import org.bremersee.exception.RestApiExceptionParserImpl;
import org.bremersee.exception.feign.FeignClientException;
import org.bremersee.exception.model.RestApiException;
import org.bremersee.http.HttpHeadersHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class FeignClientExceptionErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(FeignClientExceptionErrorDecoder.class);
    private final RestApiExceptionParser parser;

    public FeignClientExceptionErrorDecoder() {
        this.parser = new RestApiExceptionParserImpl();
    }

    public FeignClientExceptionErrorDecoder(RestApiExceptionParser parser) {
        this.parser = parser != null ? parser : new RestApiExceptionParserImpl();
    }

    public Exception decode(String methodKey, Response response) {
        if (log.isDebugEnabled()) {
            log.debug("msg=[Decoding error at {}]", (Object)methodKey);
        }
        String body = FeignClientExceptionErrorDecoder.readBody(response);
        String message = String.format("status %s reading %s", response.status(), methodKey);
        RestApiException restApiException = (RestApiException)this.parser.parseException(body, response.headers());
        if (log.isDebugEnabled() && body != null) {
            log.debug("msg=[Is error formatted as rest api exception? {}]", (Object)(restApiException != null && !body.equals(restApiException.getMessage()) ? 1 : 0));
        }
        FeignClientException feignClientException = new FeignClientException(response.request(), response.headers() != null ? Collections.unmodifiableMap(response.headers()) : null, response.status(), message, restApiException);
        HttpHeaders httpHeaders = HttpHeadersHelper.buildHttpHeaders((Map)response.headers());
        Date retryAfter = FeignClientExceptionErrorDecoder.determineRetryAfter(httpHeaders.getFirst("Retry-After"));
        if (retryAfter != null) {
            return new RetryableException(response.status(), feignClientException.getMessage(), FeignClientExceptionErrorDecoder.findHttpMethod(response), (Throwable)((Object)feignClientException), retryAfter, response.request());
        }
        return feignClientException;
    }

    static String readBody(Response response) {
        if (response == null || response.body() == null) {
            return null;
        }
        try {
            return Util.toString((Reader)response.body().asReader());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    static Date determineRetryAfter(String retryAfter) {
        if (retryAfter == null) {
            return null;
        }
        if (retryAfter.matches("^[0-9]+$")) {
            long deltaMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter));
            return new Date(System.currentTimeMillis() + deltaMillis);
        }
        try {
            return Date.from(OffsetDateTime.parse(retryAfter, DateTimeFormatter.RFC_1123_DATE_TIME).toInstant());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    static Request.HttpMethod findHttpMethod(Response response) {
        if (response == null || response.request() == null) {
            return null;
        }
        return response.request().httpMethod();
    }
}

