/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb.construct;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.OperationNotSupportedException;
import org.bridgedb.IDMapperException;
import org.bridgedb.rdb.construct.DBConnector;

public class DBConnectorDerbyServer
extends DBConnector {
    private static String host;
    private static int port;
    private static boolean inited;

    public static void init(String aHost, int aPort) {
        host = aHost;
        port = aPort;
        inited = true;
    }

    public DBConnectorDerbyServer() {
        if (!inited) {
            throw new IllegalArgumentException("Not yet initialized!");
        }
    }

    public Connection createConnection(String dbName) throws IDMapperException {
        Connection con;
        Properties sysprop = System.getProperties();
        sysprop.setProperty("derby.storage.tempDirectory", System.getProperty("java.io.tmpdir"));
        try {
            sysprop.setProperty("derby.stream.error.file", File.createTempFile("derby", ".log").toString());
            Class.forName("org.apache.derby.jdbc.ClientDriver");
        }
        catch (ClassNotFoundException e) {
            throw new IDMapperException((Throwable)e);
        }
        catch (IOException f) {
            throw new IDMapperException((Throwable)f);
        }
        String url = "jdbc:derby://" + host + ":" + port + "/" + dbName;
        try {
            con = DriverManager.getConnection(url);
        }
        catch (SQLException f) {
            throw new IDMapperException((Throwable)f);
        }
        return con;
    }

    @Override
    public Connection createConnection(String dbName, int props) throws IDMapperException {
        return this.createConnection(dbName);
    }

    @Override
    public String finalizeNewDatabase(String dbName) throws IDMapperException {
        throw new IDMapperException((Throwable)new OperationNotSupportedException("Can't create new database on server"));
    }

    static {
        inited = false;
    }
}

