/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb.construct;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bridgedb.IDMapperException;
import org.bridgedb.rdb.construct.DBConnector;
import org.bridgedb.rdb.construct.FileUtilsGdb;

public class DataDerby
extends DBConnector {
    public static final String DB_FILE_EXT_GDB = "bridge";
    public static final String DB_FILE_EXT_GEX = "pgex";
    private static final String DB_NAME_IN_ZIP = "database";
    private String finalDbName;
    private File tempDbSubdir = null;
    private File tempDbParentdir = null;
    private boolean finalized;
    private byte[] buf = new byte[1024];

    String getDbExt() {
        switch (this.getDbType()) {
            case 0: {
                return DB_FILE_EXT_GDB;
            }
            case 1: {
                return DB_FILE_EXT_GEX;
            }
        }
        return "";
    }

    private String getDbUrl() {
        String url = "jdbc:derby:";
        url = this.finalized ? url + "jar:(" + this.finalDbName + ")" + DB_NAME_IN_ZIP : url + this.tempDbSubdir;
        return url;
    }

    @Override
    public Connection createConnection(String dbName, int props) throws IDMapperException {
        Connection con;
        boolean recreate = (props & 4) != 0;
        this.finalDbName = dbName;
        boolean bl = this.finalized = !recreate;
        if (recreate) {
            this.finalDbName = dbName.endsWith(this.getDbExt()) ? dbName : dbName + "." + this.getDbExt();
            try {
                this.tempDbParentdir = FileUtilsGdb.createTempDir("derby", ".tmp");
                this.tempDbSubdir = new File(this.tempDbParentdir, DB_NAME_IN_ZIP);
            }
            catch (IOException e) {
                throw new IDMapperException((Throwable)e);
            }
        }
        Properties sysprop = System.getProperties();
        try {
            sysprop.setProperty("derby.storage.tempDirectory", System.getProperty("java.io.tmpdir"));
            sysprop.setProperty("derby.stream.error.file", File.createTempFile("derby", ".log").toString());
            Class.forName("org.apache.derby.jdbc.ClientDriver");
        }
        catch (ClassNotFoundException e) {
            throw new IDMapperException((Throwable)e);
        }
        catch (IOException f) {
            throw new IDMapperException((Throwable)f);
        }
        Properties prop = new Properties();
        prop.setProperty("create", Boolean.toString(recreate));
        String url = this.getDbUrl();
        try {
            con = DriverManager.getConnection(url, prop);
        }
        catch (SQLException e) {
            throw new IDMapperException((Throwable)e);
        }
        return con;
    }

    public Connection createNewDatabaseConnection(String dbName) throws IDMapperException {
        return this.createConnection(FileUtilsGdb.removeExtension(dbName), 4);
    }

    @Override
    public String finalizeNewDatabase(String dbName) throws IDMapperException {
        if (this.finalized) {
            return this.finalDbName;
        }
        this.toZip(new File(this.finalDbName), this.tempDbSubdir);
        FileUtilsGdb.deleteRecursive(this.tempDbParentdir);
        return this.finalDbName;
    }

    @Override
    public void closeConnection(Connection con) throws IDMapperException {
        this.closeConnection(con, 0);
    }

    @Override
    public void closeConnection(Connection con, int props) throws IDMapperException {
        if (con != null) {
            block6: {
                if (props == 8) {
                    try {
                        DriverManager.getConnection(this.getDbUrl() + ";shutdown=true");
                    }
                    catch (SQLException se) {
                        if (se.getSQLState().equals("08006")) break block6;
                        throw new IDMapperException((Throwable)se);
                    }
                }
            }
            try {
                con.close();
                con = null;
            }
            catch (SQLException se) {
                throw new IDMapperException((Throwable)se);
            }
        }
    }

    @Override
    public void compact(Connection con) throws IDMapperException {
        try {
            con.commit();
            con.setAutoCommit(true);
            if (this.getDbType() == 0) {
                CallableStatement cs = con.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
                cs.setString(1, "APP");
                cs.setString(2, "DATANODE");
                cs.setShort(3, (short)1);
                cs.execute();
                cs.setString(1, "APP");
                cs.setString(2, "LINK");
                cs.setShort(3, (short)1);
                cs.execute();
                cs.setString(1, "APP");
                cs.setString(2, "ATTRIBUTE");
                cs.setShort(3, (short)1);
                cs.execute();
            } else if (this.getDbType() == 1) {
                CallableStatement cs = con.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
                cs.setString(1, "APP");
                cs.setString(2, "EXPRESSION");
                cs.setShort(3, (short)1);
                cs.execute();
            }
            con.commit();
        }
        catch (SQLException e) {
            throw new IDMapperException((Throwable)e);
        }
    }

    private void toZip(File zipFile, File dbDir) {
        try {
            if (zipFile.exists()) {
                zipFile.delete();
            }
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            out.setMethod(0);
            for (File f : dbDir.listFiles()) {
                this.addFiles(f, "database/", out);
            }
            out.closeEntry();
            out.close();
            String zipPath = zipFile.getAbsolutePath().replace(File.separatorChar, '/');
            String url = "jdbc:derby:jar:(" + zipPath + ")" + DB_NAME_IN_ZIP;
            DriverManager.getConnection(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void addFiles(File file, String dir, ZipOutputStream out) throws IOException {
        if (file.isDirectory()) {
            if (file.getName().equals("tmp")) {
                return;
            }
            String newDir = dir + file.getName() + '/';
            ZipEntry add = new ZipEntry(newDir);
            this.setZipEntryAttributes(file, add);
            out.putNextEntry(add);
            for (File f : file.listFiles()) {
                this.addFiles(f, newDir, out);
            }
        } else {
            int len;
            if (file.getName().endsWith(".lck")) {
                return;
            }
            ZipEntry add = new ZipEntry(dir + file.getName());
            this.setZipEntryAttributes(file, add);
            out.putNextEntry(add);
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(this.buf)) > 0) {
                out.write(this.buf, 0, len);
            }
            in.close();
        }
    }

    private void setZipEntryAttributes(File f, ZipEntry z) throws IOException {
        z.setTime(f.lastModified());
        z.setMethod(0);
        if (f.isDirectory()) {
            z.setCrc(0L);
            z.setSize(0L);
            z.setCompressedSize(0L);
        } else {
            z.setSize(f.length());
            z.setCompressedSize(f.length());
            z.setCrc(this.computeCheckSum(f));
        }
    }

    private long computeCheckSum(File f) throws IOException {
        CheckedInputStream cis = new CheckedInputStream(new FileInputStream(f), new CRC32());
        byte[] tempBuf = new byte[128];
        while (cis.read(tempBuf) >= 0) {
        }
        long result = cis.getChecksum().getValue();
        cis.close();
        return result;
    }
}

