/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb.construct;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.bridgedb.IDMapperException;
import org.bridgedb.rdb.construct.DBConnector;

public class DataHsqldb
extends DBConnector {
    static final String DB_FILE_EXT = "properties";
    static final String[] DB_EXT = new String[]{"*.properties"};
    static final String[] DB_EXT_NAMES = new String[]{"Hsqldb Database"};
    Connection newDbCon;

    @Override
    public Connection createConnection(String dbName, int props) throws IDMapperException {
        Connection con;
        try {
            File dbFile;
            boolean recreate;
            boolean bl = recreate = (props & 4) != 0;
            if (recreate && (dbFile = this.dbName2File(dbName)).exists()) {
                dbFile.delete();
            }
            dbName = this.file2DbName(dbName);
            Class.forName("org.hsqldb.jdbcDriver");
            Properties prop = new Properties();
            prop.setProperty("user", "sa");
            prop.setProperty("password", "");
            prop.setProperty("hsqldb.default_table_type", "cached");
            prop.setProperty("ifexists", Boolean.toString(!recreate));
            con = DriverManager.getConnection("jdbc:hsqldb:file:" + dbName, prop);
        }
        catch (SQLException e) {
            throw new IDMapperException((Throwable)e);
        }
        catch (ClassNotFoundException f) {
            throw new IDMapperException((Throwable)f);
        }
        return con;
    }

    @Override
    public void closeConnection(Connection con) throws IDMapperException {
        this.closeConnection(con, 0);
    }

    @Override
    public void closeConnection(Connection con, int props) throws IDMapperException {
        try {
            boolean compact;
            boolean bl = compact = (props & 8) != 0;
            if (con != null) {
                Statement sh = con.createStatement();
                sh.executeQuery("SHUTDOWN" + (compact ? " COMPACT" : ""));
                sh.close();
                con.close();
            }
        }
        catch (SQLException e) {
            throw new IDMapperException((Throwable)e);
        }
    }

    File dbName2File(String dbName) {
        return new File(dbName + '.' + DB_FILE_EXT);
    }

    String file2DbName(String fileName) {
        String end = ".properties";
        return fileName.endsWith(end) ? fileName.substring(0, fileName.length() - end.length()) : fileName;
    }

    public void setDatabaseReadonly(String dbName, boolean readonly) {
        this.setPropertyReadOnly(dbName, readonly);
    }

    void setPropertyReadOnly(String dbName, boolean readonly) {
        Properties prop = new Properties();
        try {
            File propertyFile = this.dbName2File(dbName);
            prop.load(new FileInputStream(propertyFile));
            prop.setProperty("hsqldb.files_readonly", Boolean.toString(readonly));
            prop.store(new FileOutputStream(propertyFile), "HSQL Database Engine");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Connection createNewDatabaseConnection(String dbName) throws IDMapperException {
        this.newDbCon = this.createConnection(dbName, 4);
        return this.newDbCon;
    }

    @Override
    public String finalizeNewDatabase(String dbName) throws IDMapperException {
        if (this.newDbCon != null) {
            this.closeConnection(this.newDbCon, 8);
        }
        this.setPropertyReadOnly(dbName, true);
        return dbName;
    }
}

