/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb.construct;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.rdb.construct.DBConnector;
import org.bridgedb.rdb.construct.GdbConstruct;

public class GdbConstructImpl3
implements GdbConstruct {
    private static int GDB_COMPAT_VERSION = 3;
    private final Connection con;
    private final DBConnector dbConnector;
    private String dbName;
    private Exception recentException = null;
    private PreparedStatement pstGene = null;
    private PreparedStatement pstLink = null;
    private PreparedStatement pstAttr = null;

    public GdbConstructImpl3(String dbName, DBConnector dbConnector, int props) throws IDMapperException {
        this.con = dbConnector.createConnection(dbName, props);
        this.dbConnector = dbConnector;
        this.dbName = dbName;
    }

    public final void compact() throws IDMapperException {
        this.dbConnector.compact(this.con);
    }

    @Override
    public final void finalize() throws IDMapperException {
        String newDb;
        this.dbConnector.compact(this.con);
        this.createGdbIndices();
        this.dbConnector.closeConnection(this.con, 8);
        this.dbName = newDb = this.dbConnector.finalizeNewDatabase(this.dbName);
        this.recentException = null;
    }

    @Override
    public int addGene(Xref ref) {
        this.recentException = null;
        if (this.pstGene == null) {
            throw new NullPointerException();
        }
        try {
            this.pstGene.setString(1, ref.getId());
            this.pstGene.setString(2, ref.getDataSource().getSystemCode());
            this.pstGene.executeUpdate();
        }
        catch (SQLException e) {
            this.recentException = e;
            return 1;
        }
        return 0;
    }

    @Override
    public int addAttribute(Xref ref, String attr, String val) {
        this.recentException = null;
        try {
            this.pstAttr.setString(1, attr);
            this.pstAttr.setString(2, val);
            this.pstAttr.setString(3, ref.getId());
            this.pstAttr.setString(4, ref.getDataSource().getSystemCode());
            this.pstAttr.executeUpdate();
        }
        catch (SQLException e) {
            this.recentException = e;
            return 1;
        }
        return 0;
    }

    @Override
    public int addLink(Xref left, Xref right) {
        if (this.pstLink == null) {
            throw new NullPointerException();
        }
        this.recentException = null;
        try {
            this.pstLink.setString(1, left.getId());
            this.pstLink.setString(2, left.getDataSource().getSystemCode());
            this.pstLink.setString(3, right.getId());
            this.pstLink.setString(4, right.getDataSource().getSystemCode());
            this.pstLink.executeUpdate();
        }
        catch (SQLException e) {
            this.recentException = e;
            return 1;
        }
        return 0;
    }

    @Override
    public void preInsert() throws IDMapperException {
        try {
            this.con.setAutoCommit(false);
            this.pstGene = this.con.prepareStatement("INSERT INTO datanode \t(id, code)VALUES (?, ?)");
            this.pstLink = this.con.prepareStatement("INSERT INTO link \t(idLeft, codeLeft,\t idRight, codeRight)VALUES (?, ?, ?, ?)");
            this.pstAttr = this.con.prepareStatement("INSERT INTO attribute \t(attrname, attrvalue, id, code)VALUES (?, ?, ?, ?)");
        }
        catch (SQLException e) {
            throw new IDMapperException((Throwable)e);
        }
    }

    @Override
    public void setInfo(String key, String value) throws IDMapperException {
        try {
            if (!key.matches("^\\w+$")) {
                throw new IllegalArgumentException("key: '" + key + "' contains invalid characters");
            }
            PreparedStatement pstInfo1 = this.con.prepareStatement("ALTER TABLE info ADD COLUMN " + key + " VARCHAR (50)");
            pstInfo1.execute();
            PreparedStatement pstInfo2 = this.con.prepareStatement("UPDATE info SET " + key + " = ? WHERE schemaversion = " + GDB_COMPAT_VERSION);
            pstInfo2.setString(1, value);
            pstInfo2.execute();
        }
        catch (SQLException ex) {
            throw new IDMapperException((Throwable)ex);
        }
    }

    @Override
    public void createGdbIndices() throws IDMapperException {
        try {
            Statement sh = this.con.createStatement();
            sh.execute("CREATE INDEX i_codeLeft ON link(codeLeft)");
            sh.execute("CREATE INDEX i_idRight ON link(idRight)");
            sh.execute("CREATE INDEX i_codeRight ON link(codeRight)");
            sh.execute("CREATE INDEX i_code ON datanode(code)");
        }
        catch (SQLException e) {
            throw new IDMapperException((Throwable)e);
        }
    }

    @Override
    public void createGdbTables() throws IDMapperException {
        try {
            Statement sh = this.con.createStatement();
            sh.execute("CREATE TABLE\t\t\t\t\t\t\tinfo\t\t\t\t\t\t\t(\t  schemaversion INTEGER PRIMARY KEY\t\t)");
            sh.execute("INSERT INTO info VALUES ( " + GDB_COMPAT_VERSION + ")");
            sh.execute("CREATE TABLE\t\t\t\t\t\t\tlink\t\t\t\t\t\t\t (   idLeft VARCHAR(50) NOT NULL,\t\t     codeLeft VARCHAR(50) NOT NULL,\t     idRight VARCHAR(50) NOT NULL,\t\t     codeRight VARCHAR(50) NOT NULL,\t     bridge VARCHAR(50),\t\t\t\t     PRIMARY KEY (idLeft, codeLeft,    \t\tidRight, codeRight) \t\t\t )\t\t\t\t\t\t\t\t\t\t");
            sh.execute("CREATE TABLE\t\t\t\t\t\t\tdatanode\t\t\t\t\t\t (   id VARCHAR(50),\t\t\t\t\t     code VARCHAR(50),\t\t\t\t\t     PRIMARY KEY (id, code)    \t\t )\t\t\t\t\t\t\t\t\t\t");
            sh.execute("CREATE TABLE\t\t\t\t\t\t\t\t\tattribute \t\t\t\t\t\t (   id VARCHAR(50),\t\t\t\t\t     code VARCHAR(50),\t\t\t\t\t     attrname VARCHAR(50),\t\t\t\t\t  attrvalue VARCHAR(255)\t\t\t )\t\t\t\t\t\t\t\t\t\t");
        }
        catch (SQLException e) {
            throw new IDMapperException((Throwable)e);
        }
    }

    @Override
    public final void commit() throws IDMapperException {
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            throw new IDMapperException((Throwable)e);
        }
    }

    public static GdbConstruct createInstance(String dbName, DBConnector newDbConnector, int props) throws IDMapperException {
        try {
            DBConnector dbConnector = (DBConnector)newDbConnector.getClass().newInstance();
            return new GdbConstructImpl3(dbName, dbConnector, props);
        }
        catch (InstantiationException e) {
            throw new IDMapperException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new IDMapperException((Throwable)e);
        }
    }

    @Override
    public Exception recentException() {
        return this.recentException;
    }
}

