/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.ws.uri;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.bridgedb.Xref;
import org.bridgedb.rdf.BridgeDbRdfTools;
import org.bridgedb.uri.api.Mapping;
import org.bridgedb.uri.api.UriMapper;
import org.bridgedb.uri.tools.GraphResolver;
import org.bridgedb.uri.tools.RegexUriPattern;
import org.bridgedb.uri.tools.UriListener;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.ws.templates.WebTemplates;
import org.bridgedb.ws.uri.WSUriInterfaceService;

public class WSAPI
extends WSUriInterfaceService {
    private static final String EXAMPLE_GRAPH = "ApiExampleGraph";
    protected UriListener uriListener;
    private HashMap<String, String> apiStrings = new HashMap();
    static final Logger logger = Logger.getLogger(WSAPI.class);

    public WSAPI(UriMapper uriMapper) throws BridgeDBException {
        super(uriMapper);
        this.uriListener = uriMapper instanceof UriListener ? (UriListener)uriMapper : null;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/BridgeDbApi")
    public Response imsApiPage(@Context HttpServletRequest httpServletRequest) throws BridgeDBException, UnsupportedEncodingException {
        String contextPath = httpServletRequest.getContextPath();
        String apiString = this.apiStrings.get(contextPath);
        if (apiString == null) {
            apiString = this.createApiPage(contextPath);
            this.apiStrings.put(contextPath, apiString);
        }
        String htmlPage = this.createHtmlPage("bridgeDB API", apiString, httpServletRequest);
        return Response.ok((Object)htmlPage, (String)"text/html").build();
    }

    private String createApiPage(String contextPath) throws BridgeDBException, UnsupportedEncodingException {
        String targetUriSpace2;
        String sourceUriSpace2;
        List mappings = this.uriMapper.getSampleMapping();
        Mapping mapping1 = (Mapping)mappings.get(1);
        Xref sourceXref1 = mapping1.getSource();
        String id1 = sourceXref1.getId();
        String sourceSysCode1 = sourceXref1.getDataSource().getSystemCode();
        String sourceUri1 = (String)mapping1.getSourceUri().iterator().next();
        String tragetSysCode1 = mapping1.getTarget().getDataSource().getSystemCode();
        Mapping mapping2 = (Mapping)mappings.get(2);
        Xref sourceXref2 = mapping2.getSource();
        String id2 = sourceXref2.getId();
        String sourceSysCode2 = sourceXref2.getDataSource().getSystemCode();
        Xref targetXref2 = mapping2.getTarget();
        String sourceUri2 = (String)mapping2.getSourceUri().iterator().next();
        String targetUri2 = (String)mapping2.getTargetUri().iterator().next();
        if (this.uriListener != null) {
            RegexUriPattern pattern = this.uriListener.toUriPattern(sourceUri2);
            sourceUriSpace2 = pattern.getUriPattern();
            pattern = this.uriListener.toUriPattern(targetUri2);
            GraphResolver.addMapping((String)EXAMPLE_GRAPH, (RegexUriPattern)pattern);
            targetUriSpace2 = pattern.getUriPattern();
        } else {
            sourceUriSpace2 = sourceUri2.substring(0, sourceUri2.length() - sourceXref1.getId().length());
            targetUriSpace2 = targetUri2.substring(0, targetUri2.length() - targetXref2.getId().length());
            GraphResolver.addMapping((String)EXAMPLE_GRAPH, (String)targetUriSpace2);
        }
        boolean freeSearchSupported = this.idMapper.getCapabilities().isFreeSearchSupported();
        Set keys = this.idMapper.getCapabilities().getKeys();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("contextPath", (Object)contextPath);
        velocityContext.put("rdfDefaultFormat", (Object)BridgeDbRdfTools.DEFAULT_FORMAT);
        velocityContext.put("rdfFormats", (Object)BridgeDbRdfTools.getAvaiableFormats());
        velocityContext.put("uri1", (Object)sourceUri1);
        velocityContext.put("id1", (Object)id1);
        velocityContext.put("code1", (Object)sourceSysCode1);
        velocityContext.put("sourceCode1", (Object)sourceSysCode1);
        velocityContext.put("targetCode1", (Object)tragetSysCode1);
        velocityContext.put("uri2", (Object)sourceUri2);
        velocityContext.put("id2", (Object)id2);
        velocityContext.put("code2", (Object)sourceSysCode2);
        velocityContext.put("sourceUriSpace2", (Object)sourceUriSpace2);
        velocityContext.put("targetUriSpace2", (Object)targetUriSpace2);
        velocityContext.put("graph", (Object)EXAMPLE_GRAPH);
        return WebTemplates.getForm(velocityContext, "api.vm");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/api")
    public Response apiPage(@Context HttpServletRequest httpServletRequest) throws BridgeDBException, UnsupportedEncodingException {
        return this.imsApiPage(httpServletRequest);
    }
}

