/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.ws.uri;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.Xref;
import org.bridgedb.statistics.MappingSetInfo;
import org.bridgedb.statistics.OverallStatistics;
import org.bridgedb.statistics.SourceInfo;
import org.bridgedb.statistics.SourceTargetInfo;
import org.bridgedb.uri.api.Mapping;
import org.bridgedb.uri.api.MappingsBySet;
import org.bridgedb.uri.api.MappingsBySysCodeId;
import org.bridgedb.uri.api.UriMapper;
import org.bridgedb.uri.lens.Lens;
import org.bridgedb.uri.lens.LensTools;
import org.bridgedb.uri.ws.WSUriInterface;
import org.bridgedb.uri.ws.bean.DataSourceUriPatternBean;
import org.bridgedb.uri.ws.bean.LensBean;
import org.bridgedb.uri.ws.bean.LensesBean;
import org.bridgedb.uri.ws.bean.MappingSetInfoBean;
import org.bridgedb.uri.ws.bean.MappingSetInfosBean;
import org.bridgedb.uri.ws.bean.MappingsBean;
import org.bridgedb.uri.ws.bean.MappingsBySetBean;
import org.bridgedb.uri.ws.bean.OverallStatisticsBean;
import org.bridgedb.uri.ws.bean.SourceInfosBean;
import org.bridgedb.uri.ws.bean.SourceTargetInfosBean;
import org.bridgedb.uri.ws.bean.UriExistsBean;
import org.bridgedb.uri.ws.bean.UriMappings;
import org.bridgedb.uri.ws.bean.UriSearchBean;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.ws.WSCoreService;
import org.bridgedb.ws.bean.XrefBean;
import org.bridgedb.ws.templates.WebTemplates;

@Path(value="/")
public class WSUriInterfaceService
extends WSCoreService
implements WSUriInterface {
    protected UriMapper uriMapper;
    public final String MIME_TYPE = "mimeType";
    public final String STORE_TYPE = "storeType";
    public final String VALIDATION_TYPE = "validationType";
    public final String INFO = "info";
    public final String FILE = "file";
    public final String NO_RESULT;
    protected final NumberFormat formatter;
    static final Logger logger = Logger.getLogger(WSUriInterfaceService.class);

    public WSUriInterfaceService(UriMapper uriMapper) throws BridgeDBException {
        super((IDMapper)uriMapper);
        this.NO_RESULT = null;
        this.uriMapper = uriMapper;
        this.formatter = this.configFormatter();
        logger.info((Object)"WS Service running using supplied uriMapper");
    }

    private NumberFormat configFormatter() throws BridgeDBException {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setGroupingSeparator(',');
            ((DecimalFormat)numberFormat).setDecimalFormatSymbols(dfs);
        }
        return numberFormat;
    }

    private MappingsBean mapFull(String id, String scrCode, String uri, String lensUri, Boolean includeXrefResults, Boolean includeUriResults, List<String> targetCodes, String graph, List<String> targetUriPatterns) throws BridgeDBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"map called! ");
            if (id != null) {
                logger.debug((Object)("id = " + id));
            }
            if (scrCode != null) {
                logger.debug((Object)("   scrCode = " + scrCode));
            }
            if (uri != null) {
                logger.debug((Object)("   uri = " + uri));
            }
            logger.debug((Object)("   lensUri = " + lensUri));
            if (targetCodes != null && !targetCodes.isEmpty()) {
                logger.debug((Object)("   targetCodes = " + targetCodes));
            }
            if (targetUriPatterns != null && !targetUriPatterns.isEmpty()) {
                logger.debug((Object)("   targetUriPatterns = " + targetUriPatterns));
            }
        }
        Set<DataSource> targetDataSources = this.getDataSources(targetCodes);
        if (id == null) {
            if (scrCode != null) {
                throw new BridgeDBException("code parameter " + scrCode + " should only be used together with " + "id" + " parameter ");
            }
            if (uri == null) {
                throw new BridgeDBException("Please provide either a id or a Uri parameter.");
            }
            return this.mapFull(uri, lensUri, includeXrefResults, targetDataSources, graph, targetUriPatterns);
        }
        if (uri != null) {
            throw new BridgeDBException("Please provide either a id or a code parameter, but not both.");
        }
        if (scrCode == null) {
            throw new BridgeDBException("id parameter must come with a code parameter.");
        }
        return this.mapFull(id, scrCode, lensUri, includeUriResults, targetDataSources, graph, targetUriPatterns);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/map")
    public Response map(@QueryParam(value="id") String id, @QueryParam(value="code") String scrCode, @QueryParam(value="Uri") String uri, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="includeXrefResults") Boolean includeXrefResults, @QueryParam(value="includeUriResults") Boolean includeUriResults, @QueryParam(value="targetCode") List<String> targetCodes, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns) throws BridgeDBException {
        MappingsBean result = this.mapFull(id, scrCode, uri, lensUri, includeXrefResults, includeUriResults, targetCodes, graph, targetUriPatterns);
        if (this.noContentOnEmpty & result.asMappings().isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/map")
    public Response mapJson(@QueryParam(value="id") String id, @QueryParam(value="code") String scrCode, @QueryParam(value="Uri") String uri, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="includeXrefResults") Boolean includeXrefResults, @QueryParam(value="includeUriResults") Boolean includeUriResults, @QueryParam(value="targetCode") List<String> targetCodes, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns) throws BridgeDBException {
        MappingsBean result = this.mapFull(id, scrCode, uri, lensUri, includeXrefResults, includeUriResults, targetCodes, graph, targetUriPatterns);
        if (this.noContentOnEmpty & result.asMappings().isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/map")
    public Response mapHtml(@QueryParam(value="id") String id, @QueryParam(value="code") String scrCode, @QueryParam(value="Uri") String uri, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="includeXrefResults") Boolean includeXrefResults, @QueryParam(value="includeUriResults") Boolean includeUriResults, @QueryParam(value="targetCode") List<String> targetCodes, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        MappingsBean result = this.mapFull(id, scrCode, uri, lensUri, includeXrefResults, includeUriResults, targetCodes, graph, targetUriPatterns);
        if (this.noContentOnEmpty & result.asMappings().isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    private UriMappings mapUriInner(List<String> uris, String lensUri, String graph, List<String> targetUriPatterns) throws BridgeDBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"map called! ");
            logger.debug((Object)("   uri = " + uris));
            logger.debug((Object)("   lensUri = " + lensUri));
            if (targetUriPatterns != null && !targetUriPatterns.isEmpty()) {
                logger.debug((Object)("   targetUriPatterns = " + targetUriPatterns));
            }
        }
        HashSet results = new HashSet();
        for (String single : uris) {
            results.addAll(this.uriMapper.mapUri(single, lensUri, graph, targetUriPatterns));
        }
        return UriMappings.asBean(results);
    }

    private MappingsBySysCodeId mapUriBySysCodeId(List<String> uris, String lensUri, String graph, List<String> targetUriPatterns) throws BridgeDBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"mapUriBySysCodeId called! ");
            logger.debug((Object)("   uri = " + uris));
            logger.debug((Object)("   lensUri = " + lensUri));
            logger.debug((Object)("   graph = " + graph));
            if (targetUriPatterns != null && !targetUriPatterns.isEmpty()) {
                logger.debug((Object)("   targetUriPatterns = " + targetUriPatterns));
            }
        }
        return this.uriMapper.mapUriBySysCodeId(lensUri, lensUri, graph, targetUriPatterns);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/mapUri")
    public Response mapUri(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns) throws BridgeDBException {
        UriMappings result = this.mapUriInner(uris, lensUri, graph, targetUriPatterns);
        if (this.noContentOnEmpty & result.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/mapUri")
    public Response mapUriJson(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns) throws BridgeDBException {
        UriMappings result = this.mapUriInner(uris, lensUri, graph, targetUriPatterns);
        if (this.noContentOnEmpty & result.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/mapUri")
    public Response mapUriHtml(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns, @QueryParam(value="format") String format, @Context HttpServletRequest httpServletRequest) {
        HashSet<Mapping> mappings = new HashSet<Mapping>();
        try {
            if (uris == null || uris.isEmpty()) {
                throw new BridgeDBException("Uri parameter missing!");
            }
            for (String uri : uris) {
                mappings.addAll(this.uriMapper.mapFull(uri, lensUri, Boolean.valueOf(true), graph, targetUriPatterns));
            }
        }
        catch (BridgeDBException exception) {
            return this.mapUriHtmlResult(uris, lensUri, graph, targetUriPatterns, format, httpServletRequest, null, exception);
        }
        uris.remove("");
        targetUriPatterns.remove("");
        if (format == null || format.isEmpty()) {
            format = "text/html";
        }
        if (format.equals("application/xml")) {
            if (this.noContentOnEmpty & mappings.isEmpty()) {
                return this.noContentWrapper(httpServletRequest);
            }
            return Response.ok((Object)UriMappings.toBean(mappings), (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        if (format.equals("application/json")) {
            if (this.noContentOnEmpty & mappings.isEmpty()) {
                return this.noContentWrapper(httpServletRequest);
            }
            return Response.ok((Object)UriMappings.toBean(mappings), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        return this.mapUriHtmlResult(uris, lensUri, graph, targetUriPatterns, format, httpServletRequest, mappings, null);
    }

    private Response mapUriHtmlResult(List<String> uris, String lensUri, String graph, List<String> targetUriPatterns, String format, HttpServletRequest httpServletRequest, Collection<Mapping> mappingSet, BridgeDBException exception) {
        uris.remove("");
        targetUriPatterns.remove("");
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
        velocityContext.put("sourceUris", uris);
        velocityContext.put("URI", (Object)"Uri");
        velocityContext.put("lensURI", (Object)lensUri);
        velocityContext.put("lensURIName", (Object)"lensUri");
        velocityContext.put("defaultLensName", (Object)"Default");
        velocityContext.put("targetUriPatterns", targetUriPatterns);
        velocityContext.put("targetUriPatternName", (Object)"targetUriPattern");
        velocityContext.put("graph", (Object)graph);
        velocityContext.put("graphName", (Object)"graph");
        if (mappingSet != null) {
            ArrayList<Mapping> mappingList = new ArrayList<Mapping>(mappingSet);
            Collections.sort(mappingList);
            velocityContext.put("mappings", mappingList);
        } else {
            velocityContext.put("mappings", new ArrayList());
            velocityContext.put("exception", (Object)exception.getMessage());
        }
        String mainBody = WebTemplates.getForm(velocityContext, "mapUriResults.vm");
        String fullPage = this.createHtmlPage("Identity Mapping Service", mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="/mapUri")
    public Response mapUriHtmlPost(@FormParam(value="Uri") List<String> uris, @FormParam(value="lensUri") String lensUri, @FormParam(value="graph") String graph, @FormParam(value="format") String format, @FormParam(value="targetUriPattern") List<String> targetUriPatterns, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        return this.mapUriHtml(uris, lensUri, graph, targetUriPatterns, format, httpServletRequest);
    }

    protected final MappingsBySet mapBySetInner(List<String> uris, String lensUri, String graph, List<String> targetUriPatterns) throws BridgeDBException {
        HashSet<String> uriSet = new HashSet<String>(uris);
        return this.uriMapper.mapBySet(uriSet, lensUri, graph, targetUriPatterns);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/mapBySet")
    public Response mapBySet(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns) throws BridgeDBException {
        MappingsBySet mappingsBySet = this.mapBySetInner(uris, lensUri, graph, targetUriPatterns);
        if (this.noContentOnEmpty & mappingsBySet.isEmpty()) {
            return Response.noContent().build();
        }
        MappingsBySetBean result = new MappingsBySetBean(mappingsBySet);
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/mapBySet")
    public Response mapBySetJson(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns) throws BridgeDBException {
        MappingsBySet mappingsBySet = this.mapBySetInner(uris, lensUri, graph, targetUriPatterns);
        if (this.noContentOnEmpty & mappingsBySet.isEmpty()) {
            return Response.noContent().build();
        }
        MappingsBySetBean result = new MappingsBySetBean(mappingsBySet);
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/mapBySet")
    public Response mapBySetHtml(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        MappingsBySet mappingsBySet = this.mapBySetInner(uris, lensUri, graph, targetUriPatterns);
        if (this.noContentOnEmpty & mappingsBySet.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        MappingsBySetBean result = new MappingsBySetBean(mappingsBySet);
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/UriExists")
    public Response UriExists(@QueryParam(value="Uri") String URI) throws BridgeDBException {
        if (URI == null) {
            throw new BridgeDBException("Uri parameter missing.");
        }
        if (URI.isEmpty()) {
            throw new BridgeDBException("Uri parameter may not be null.");
        }
        boolean exists = this.uriMapper.uriExists(URI);
        UriExistsBean bean = new UriExistsBean(URI, exists);
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/UriExists")
    public Response UriExistsJson(@QueryParam(value="Uri") String URI) throws BridgeDBException {
        if (URI == null) {
            throw new BridgeDBException("Uri parameter missing.");
        }
        if (URI.isEmpty()) {
            throw new BridgeDBException("Uri parameter may not be null.");
        }
        boolean exists = this.uriMapper.uriExists(URI);
        UriExistsBean bean = new UriExistsBean(URI, exists);
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private UriSearchBean UriSearchInner(String text, String limitString) throws BridgeDBException {
        if (text == null) {
            throw new BridgeDBException("text parameter missing.");
        }
        if (text.isEmpty()) {
            throw new BridgeDBException("text parameter may not be null.");
        }
        if (limitString == null || limitString.isEmpty()) {
            Set uris = this.uriMapper.uriSearch(text, Integer.MAX_VALUE);
            return new UriSearchBean(text, uris);
        }
        int limit = Integer.parseInt(limitString);
        Set uris = this.uriMapper.uriSearch(text, limit);
        return new UriSearchBean(text, uris);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/UriSearch")
    public Response UriSearch(@QueryParam(value="text") String text, @QueryParam(value="limit") String limitString) throws BridgeDBException {
        UriSearchBean bean = this.UriSearchInner(text, limitString);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/UriSearch")
    public Response UriSearchJson(@QueryParam(value="text") String text, @QueryParam(value="limit") String limitString) throws BridgeDBException {
        UriSearchBean bean = this.UriSearchInner(text, limitString);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/UriSearch")
    public Response UriSearchHtml(@QueryParam(value="text") String text, @QueryParam(value="limit") String limitString, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        UriSearchBean bean = this.UriSearchInner(text, limitString);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    public XrefBean toXrefInner(String URI) throws BridgeDBException {
        if (URI == null) {
            throw new BridgeDBException("Uri parameter missing.");
        }
        if (URI.isEmpty()) {
            throw new BridgeDBException("Uri parameter may not be null.");
        }
        Xref xref = this.uriMapper.toXref(URI);
        return XrefBean.asBean((Xref)xref);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/toXref")
    public Response toXref(@QueryParam(value="Uri") String URI) throws BridgeDBException {
        XrefBean bean = this.toXrefInner(URI);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/toUris")
    public Response toUris(@QueryParam(value="id") String id, @QueryParam(value="code") String scrCode) throws BridgeDBException {
        UriMappings result = this.toUrisInner(id, scrCode);
        if (this.noContentOnEmpty & result.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/toUris")
    public Response toUrisJSon(@QueryParam(value="id") String id, @QueryParam(value="code") String scrCode) throws BridgeDBException {
        UriMappings result = this.toUrisInner(id, scrCode);
        if (this.noContentOnEmpty & result.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/toUris")
    public Response toUrisHtml(@QueryParam(value="id") String id, @QueryParam(value="code") String scrCode, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        UriMappings result = this.toUrisInner(id, scrCode);
        Set uris = result.getTargetUri();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
        velocityContext.put("id", (Object)id);
        velocityContext.put("sysCode", (Object)scrCode);
        velocityContext.put("uris", (Object)uris);
        String mainBody = WebTemplates.getForm(velocityContext, "toUris.vm");
        String fullPage = this.createHtmlPage("Identity Mapping Service", mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    public UriMappings toUrisInner(String id, String scrCode) throws BridgeDBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"toUris called! ");
            logger.debug((Object)("id = " + id));
            logger.debug((Object)("srCode = " + scrCode));
        }
        if (id == null) {
            throw new BridgeDBException("Please provide  a id parameter.");
        }
        if (scrCode == null) {
            throw new BridgeDBException("Please provide  a code parameter.");
        }
        DataSource dataSource = DataSource.getExistingBySystemCode((String)scrCode);
        Xref sourceXref = new Xref(id, dataSource);
        Set results = this.uriMapper.toUris(sourceXref);
        return UriMappings.asBean((Set)results);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/toXref")
    public Response toXrefJson(@QueryParam(value="Uri") String URI) throws BridgeDBException {
        XrefBean bean = this.toXrefInner(URI);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/toXref")
    public Response toXrefHtml(@QueryParam(value="Uri") String URI, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        XrefBean bean = this.toXrefInner(URI);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/getOverallStatistics")
    public Response getOverallStatistics(@QueryParam(value="lensUri") String lensUri) throws BridgeDBException {
        OverallStatistics overallStatistics = this.uriMapper.getOverallStatistics(lensUri);
        OverallStatisticsBean bean = OverallStatisticsBean.asBean((OverallStatistics)overallStatistics);
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getOverallStatistics")
    public Response getOverallStatisticsJson(@QueryParam(value="lensUri") String lensUri) throws BridgeDBException {
        OverallStatistics overallStatistics = this.uriMapper.getOverallStatistics(lensUri);
        OverallStatisticsBean bean = OverallStatisticsBean.asBean((OverallStatistics)overallStatistics);
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/SourceInfos")
    public Response getSourceInfos(@QueryParam(value="lensUri") String lensUri) throws BridgeDBException {
        SourceInfosBean bean = this.getSourceInfosInner(lensUri);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/SourceInfos")
    public Response getSourceInfosJson(@QueryParam(value="lensUri") String lensUri) throws BridgeDBException {
        SourceInfosBean bean = this.getSourceInfosInner(lensUri);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private SourceInfosBean getSourceInfosInner(String lensUri) throws BridgeDBException {
        List infos = this.uriMapper.getSourceInfos(lensUri);
        SourceInfosBean bean = new SourceInfosBean();
        for (SourceInfo info : infos) {
            bean.addSourceInfo(info);
        }
        return bean;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/SourceTargetInfos")
    public Response getSourceTargetInfos(@QueryParam(value="sourceCode") String scrCode, @QueryParam(value="lensUri") String lensUri) throws BridgeDBException {
        SourceTargetInfosBean bean = this.getSourceTargetInfosInner(scrCode, lensUri);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/SourceTargetInfos")
    public Response getSourceTargetInfosJson(@QueryParam(value="sourceCode") String scrCode, @QueryParam(value="lensUri") String lensUri) throws BridgeDBException {
        SourceTargetInfosBean bean = this.getSourceTargetInfosInner(scrCode, lensUri);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private SourceTargetInfosBean getSourceTargetInfosInner(String scrCode, String lensUri) throws BridgeDBException {
        List infos = this.uriMapper.getSourceTargetInfos(scrCode, lensUri);
        SourceTargetInfosBean bean = new SourceTargetInfosBean();
        for (SourceTargetInfo info : infos) {
            bean.addSourceTargetInfo(info);
        }
        return bean;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/mappingSetXML")
    public Response getMappingSetInfosXML(@QueryParam(value="sourceCode") String scrCode, @QueryParam(value="targetCode") String targetCode, @QueryParam(value="lensUri") String lensUri) throws BridgeDBException {
        return this.getMappingSetInfos(scrCode, targetCode, lensUri);
    }

    private MappingSetInfosBean getMappingSetInfosInner(String scrCode, String targetCode, String lensUri) throws BridgeDBException {
        List infos = this.uriMapper.getMappingSetInfos(scrCode, targetCode, lensUri);
        MappingSetInfosBean bean = new MappingSetInfosBean();
        for (MappingSetInfo info : infos) {
            bean.addMappingSetInfo(info);
        }
        return bean;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/mappingSet")
    public Response getMappingSetInfos(@QueryParam(value="sourceCode") String scrCode, @QueryParam(value="targetCode") String targetCode, @QueryParam(value="lensUri") String lensUri) throws BridgeDBException {
        MappingSetInfosBean bean = this.getMappingSetInfosInner(scrCode, targetCode, lensUri);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/mappingSet")
    public Response getMappingSetInfosJson(@QueryParam(value="sourceCode") String scrCode, @QueryParam(value="targetCode") String targetCode, @QueryParam(value="lensUri") String lensUri) throws BridgeDBException {
        MappingSetInfosBean bean = this.getMappingSetInfosInner(scrCode, targetCode, lensUri);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private LensBean getLensInner(String id) throws BridgeDBException {
        Lens lens = LensTools.byId((String)id);
        return new LensBean(lens, null);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/Lens/{id}")
    public Response getLens(@PathParam(value="id") String id) throws BridgeDBException {
        LensBean bean = this.getLensInner(id);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/Lens/{id}")
    public Response getLensJson(@PathParam(value="id") String id) throws BridgeDBException {
        LensBean bean = this.getLensInner(id);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/Lens/{id}")
    public Response getLensHtml(@PathParam(value="id") String id, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        LensBean bean = this.getLensInner(id);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/LensXML")
    public Response getLensesXML(@QueryParam(value="lensUri") String lensUri, @QueryParam(value="lensGroup") String lensGroup) throws BridgeDBException {
        return this.getLenses(lensUri, lensGroup);
    }

    protected List<Lens> getTheLens(String lensUri, String lensGroup) throws BridgeDBException {
        if (lensUri == null || lensUri.isEmpty()) {
            return LensTools.getLens((String)lensGroup);
        }
        Lens lens = LensTools.byId((String)lensUri);
        ArrayList<Lens> lenses = new ArrayList<Lens>();
        lenses.add(lens);
        return lenses;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/Lens")
    public Response getLenses(@QueryParam(value="lensUri") String lensUri, @QueryParam(value="lensGroup") String lensGroup) throws BridgeDBException {
        List<Lens> lenses = this.getTheLens(lensUri, lensGroup);
        LensesBean bean = new LensesBean(lenses, null);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/Lens")
    public Response getLensesJson(@QueryParam(value="lensUri") String lensUri, @QueryParam(value="lensGroup") String lensGroup) throws BridgeDBException {
        List<Lens> lenses = this.getTheLens(lensUri, lensGroup);
        LensesBean bean = new LensesBean(lenses, null);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/Lens")
    public Response getLensesHtml(@QueryParam(value="lensUri") String lensUri, @QueryParam(value="lensGroup") String lensGroup, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        List<Lens> lenses = this.getTheLens(lensUri, lensGroup);
        LensesBean bean = new LensesBean(lenses, null);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    private MappingSetInfoBean getMappingSetInfoInner(String idString) throws BridgeDBException {
        if (idString == null) {
            throw new BridgeDBException("Path parameter missing.");
        }
        if (idString.isEmpty()) {
            throw new BridgeDBException("Path parameter may not be null.");
        }
        int id = Integer.parseInt(idString);
        MappingSetInfo info = this.uriMapper.getMappingSetInfo(id);
        return new MappingSetInfoBean(info);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/mappingSet/{id}")
    public Response getMappingSetInfo(@PathParam(value="id") String idString) throws BridgeDBException {
        MappingSetInfoBean bean = this.getMappingSetInfoInner(idString);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/mappingSet/{id}")
    public Response getMappingSetInfoJson(@PathParam(value="id") String idString) throws BridgeDBException {
        MappingSetInfoBean bean = this.getMappingSetInfoInner(idString);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json", "text/html"})
    @Path(value="/dataSource")
    public Response getDataSource() throws BridgeDBException {
        throw new BridgeDBException("id path parameter missing.");
    }

    private DataSourceUriPatternBean getDataSourceInner(String id) throws BridgeDBException {
        if (id == null) {
            throw new BridgeDBException("Path parameter missing.");
        }
        if (id.isEmpty()) {
            throw new BridgeDBException("Path parameter may not be null.");
        }
        DataSource ds = DataSource.getExistingBySystemCode((String)id);
        return new DataSourceUriPatternBean(ds, this.uriMapper.getUriPatterns(id));
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/dataSource/{id}")
    public Response getDataSource(@PathParam(value="id") String id) throws BridgeDBException {
        DataSourceUriPatternBean bean = this.getDataSourceInner(id);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/dataSource/{id}")
    public Response getDataSourceJson(@PathParam(value="id") String id) throws BridgeDBException {
        DataSourceUriPatternBean bean = this.getDataSourceInner(id);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/SqlCompatVersion")
    public Response getSqlCompatVersion() throws BridgeDBException {
        return Response.ok((Object)this.uriMapper.getSqlCompatVersion(), (String)"text/plain").build();
    }

    private MappingsBean mapFull(String uri, String lensUri, Boolean includeXrefResults, Collection<DataSource> targetDataSources, String graph, Collection<String> targetPatterns) throws BridgeDBException {
        Set<Mapping> mappings;
        if (includeXrefResults == null) {
            includeXrefResults = false;
        }
        if (targetDataSources.isEmpty()) {
            mappings = this.mapFull(uri, lensUri, includeXrefResults, graph, targetPatterns);
        } else {
            mappings = this.mapFull(uri, lensUri, targetDataSources);
            if (targetPatterns != null && !targetPatterns.isEmpty()) {
                mappings.addAll(this.mapFull(uri, lensUri, true, graph, targetPatterns));
            }
        }
        return new MappingsBean(mappings);
    }

    private MappingsBean mapFull(String id, String scrCode, String lensUri, Boolean includeUriResults, Collection<DataSource> targetDataSources, String graph, Collection<String> targetPatterns) throws BridgeDBException {
        Set<Mapping> mappings;
        DataSource dataSource = DataSource.getExistingBySystemCode((String)scrCode);
        Xref sourceXref = new Xref(id, dataSource);
        if (includeUriResults == null) {
            includeUriResults = false;
        }
        if (targetPatterns == null || targetPatterns.isEmpty()) {
            mappings = this.mapFull(sourceXref, lensUri, includeUriResults, targetDataSources);
        } else {
            mappings = this.mapFull(sourceXref, lensUri, graph, targetPatterns);
            if (!targetDataSources.isEmpty()) {
                mappings.addAll(this.mapFull(sourceXref, lensUri, true, targetDataSources));
            }
        }
        return new MappingsBean(mappings);
    }

    private Set<DataSource> getDataSources(List<String> targetCodes) {
        HashSet<DataSource> targets = new HashSet<DataSource>();
        if (targetCodes != null) {
            for (String targetCode : targetCodes) {
                if (targetCode != null && !targetCode.isEmpty()) {
                    targets.add(DataSource.getExistingBySystemCode((String)targetCode));
                    continue;
                }
                targets.add(null);
            }
        }
        return targets;
    }

    private Set<Mapping> mapFull(String sourceUri, String lensUri, Collection<DataSource> targetDataSources) throws BridgeDBException {
        return this.uriMapper.mapFull(sourceUri, lensUri, targetDataSources);
    }

    private Set<Mapping> mapFull(Xref sourceXref, String lensUri, boolean includeUriResults, Collection<DataSource> targetDataSources) throws BridgeDBException {
        return this.uriMapper.mapFull(sourceXref, lensUri, Boolean.valueOf(includeUriResults), targetDataSources);
    }

    private Set<Mapping> mapFull(String sourceUri, String lensUri, boolean includeXrefResults, String graph, Collection<String> targetUriPattern) throws BridgeDBException {
        return this.uriMapper.mapFull(sourceUri, lensUri, Boolean.valueOf(includeXrefResults), graph, targetUriPattern);
    }

    private Set<Mapping> mapFull(Xref sourceXref, String lensUri, String graph, Collection<String> targetUriPattern) throws BridgeDBException {
        return this.uriMapper.mapFull(sourceXref, lensUri, graph, targetUriPattern);
    }

    private String trim(String original) {
        String result = original.trim();
        while (result.startsWith("\"")) {
            result = result.substring(1);
        }
        while (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result.trim();
    }

    protected final void validateInfo(String info) throws BridgeDBException {
        if (info == null) {
            throw new BridgeDBException("info parameter may not be null");
        }
        if (info.trim().isEmpty()) {
            throw new BridgeDBException("info parameter may not be empty");
        }
    }

    void validateInputStream(InputStream inputStream) throws BridgeDBException {
        if (inputStream == null) {
            throw new BridgeDBException("file parameter may not be null");
        }
    }

    protected String serviceName() {
        return "BridgeDb ";
    }

    protected String sideBar(HttpServletRequest httpServletRequest) {
        StringBuilder sb = new StringBuilder("<div id=\"navBar\">");
        this.addSideBarMiddle(sb, httpServletRequest);
        this.addSideBarStatistics(sb, httpServletRequest);
        sb.append("</div>\n");
        return sb.toString();
    }

    protected void sideBar(StringBuilder sb, HttpServletRequest httpServletRequest) {
        sb.append("<div id=\"navBar\">");
        this.addSideBarMiddle(sb, httpServletRequest);
        this.addSideBarStatistics(sb, httpServletRequest);
        sb.append("</div>\n");
    }

    public void addSideBarMiddle(StringBuilder sb, HttpServletRequest httpServletRequest) {
        this.addSideBarBridgeDb(sb, httpServletRequest);
    }

    protected void addSideBarBridgeDb(StringBuilder sb, HttpServletRequest httpServletRequest) {
        sb.append("<div class=\"menugroup\">BridgeDb Service</div>");
        this.addSideBarItem(sb, "BridgeDb", "Home", httpServletRequest);
        String allMappingInfo = "SourceInfos?lensUri=All";
        this.addSideBarItem(sb, allMappingInfo, "All Mappings Summary", httpServletRequest);
        this.addSideBarItem(sb, "SourceInfos", "Default Mappings Summary", httpServletRequest);
        this.addSideBarItem(sb, "Lens", "Lens", httpServletRequest);
        this.addSideBarItem(sb, "URISpacesPerGraph", "UriSpace(s) per Graph", httpServletRequest);
        this.addSideBarItem(sb, "BridgeDbApi", "Api", httpServletRequest);
    }

    protected void addSideBarStatistics(StringBuilder sb, HttpServletRequest httpServletRequest) {
        try {
            OverallStatistics statistics = this.uriMapper.getOverallStatistics("Default");
            statistics = this.uriMapper.getOverallStatistics("All");
            sb.append("\n<div class=\"menugroup\">Statistics</div>");
            this.addSideBarItem(sb, "mappingSet", this.formatter.format(statistics.getNumberOfMappings()) + " Mappings", httpServletRequest);
            this.addSideBarItem(sb, "mappingSet", this.formatter.format(statistics.getNumberOfMappingSets()) + " Mapping Sets", httpServletRequest);
            this.addSideBarItem(sb, "getSupportedSrcDataSources", this.formatter.format(statistics.getNumberOfSourceDataSources()) + " Source Data Sources", httpServletRequest);
            this.addSideBarItem(sb, "mappingSet", this.formatter.format(statistics.getNumberOfPredicates()) + " Predicates", httpServletRequest);
            this.addSideBarItem(sb, "getSupportedTgtDataSources", this.formatter.format(statistics.getNumberOfTargetDataSources()) + " Target Data Sources ", httpServletRequest);
            this.addSideBarItem(sb, "Lens", this.formatter.format(statistics.getNumberOfLenses()) + " Lenses ", httpServletRequest);
        }
        catch (BridgeDBException ex) {
            sb.append("\nStatistics currenlty unavailable.");
            logger.error((Object)"Error getting statistics.", (Throwable)ex);
        }
    }

    public void addSideBarItem(StringBuilder sb, String page, String name, HttpServletRequest httpServletRequest) {
        sb.append("\n<div id=\"menu");
        sb.append(page);
        sb.append("_text\" class=\"texthotlink\" ");
        sb.append("onmouseout=\"DHTML_TextRestore('menu");
        sb.append(page);
        sb.append("_text'); return true; \" ");
        sb.append("onmouseover=\"DHTML_TextHilight('menu");
        sb.append(page);
        sb.append("_text'); return true; \" ");
        sb.append("onclick=\"document.location = &quot;");
        sb.append(httpServletRequest.getContextPath());
        sb.append("/");
        sb.append(page);
        sb.append("&quot;;\">");
        sb.append(name);
        sb.append("</div>");
    }

    protected void footerAndEnd(StringBuilder sb) {
        sb.append("</div>\n<div id=\"footer\">");
        sb.append("\n<div></body></html>");
    }

    public void generateLensSelector(StringBuilder sb, HttpServletRequest httpServletRequest) throws BridgeDBException {
        List lenses = LensTools.getLens((String)"all");
        sb.append("<p>");
        sb.append("lensUri");
        sb.append("<select name=\"");
        sb.append("lensUri");
        sb.append("\">");
        for (Lens lens : lenses) {
            sb.append("<option value=\"");
            sb.append(lens.toUri(httpServletRequest.getContextPath()));
            sb.append("\">");
            sb.append(lens.getName());
            sb.append("</option>");
        }
        sb.append("</select>\n");
    }

    protected final String createTablePage(String title, String table, HttpServletRequest httpServletRequest) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("title", (Object)title);
        String tableStyle = WebTemplates.getForm(velocityContext, "jquery_dataTables_css.vm");
        String tableScript = WebTemplates.getForm(velocityContext, "tableSorter.vm");
        return this.createHtmlPage(tableStyle, tableScript, title, table, httpServletRequest);
    }

    public final String createHtmlPage(String title, String info, HttpServletRequest httpServletRequest) {
        return this.createHtmlPage("", "", title, info, httpServletRequest);
    }

    protected final String createHtmlPage(String style, String javaScript, String title, String info, HttpServletRequest httpServletRequest) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("title", (Object)title);
        style = style + WebTemplates.getForm(velocityContext, "mainStyle.vm");
        javaScript = javaScript + WebTemplates.getForm(velocityContext, "mainJavaScript.vm");
        String top = WebTemplates.getForm(velocityContext, "mainTop.vm");
        String menubar = this.sideBar(httpServletRequest);
        String bottom = this.mainBottom();
        return this.createHtmlPage(style, javaScript, title, top, menubar, info, bottom);
    }

    protected final String createHtmlPage(String style, String javaScript, String title, String top, String menuBar, String info, String bottom) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("title", (Object)title);
        velocityContext.put("style", (Object)style);
        velocityContext.put("java_script", (Object)javaScript);
        velocityContext.put("top", (Object)top);
        velocityContext.put("menubar", (Object)menuBar);
        velocityContext.put("info", (Object)info);
        velocityContext.put("bottom", (Object)bottom);
        return WebTemplates.getForm(velocityContext, "mainFrame.vm");
    }

    protected final String mainBottom() {
        return "";
    }
}

