/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.ws.uri;

import com.sun.jersey.core.header.MediaTypes;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.bridgedb.DataSource;
import org.bridgedb.rdf.BridgeDbRdfTools;
import org.bridgedb.rdf.UriPattern;
import org.bridgedb.sql.SQLUriMapper;
import org.bridgedb.statistics.MappingSetInfo;
import org.bridgedb.uri.api.Mapping;
import org.bridgedb.uri.api.MappingsBySet;
import org.bridgedb.uri.api.UriMapper;
import org.bridgedb.uri.lens.Lens;
import org.bridgedb.uri.lens.LensTools;
import org.bridgedb.uri.tools.DirectStatementMaker;
import org.bridgedb.uri.tools.GraphResolver;
import org.bridgedb.uri.tools.RegexUriPattern;
import org.bridgedb.uri.tools.StatementMaker;
import org.bridgedb.uri.ws.bean.URISpacesInGraphBean;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.ws.templates.WebTemplates;
import org.bridgedb.ws.uri.SourceTargetCounter;
import org.bridgedb.ws.uri.WSAPI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;

public class WSUriServer
extends WSAPI {
    private static boolean EXCLUDE_GRAPH = false;
    private static boolean INCLUDE_GRAPH = true;
    private final String GET_BASE_URI_FROM_CONTEXT;
    private final String DO_NOT_CONVERT_TO_RDF;
    private final boolean XREF_DATA_NOT_REQUIRED = false;
    private static final HashMap<String, Response> setMappings = new HashMap();
    private final StatementMaker statementMaker;
    static final Logger logger = Logger.getLogger(WSUriServer.class);
    static List<RDFFormat> rdfFormats = new ArrayList<RDFFormat>();

    public WSUriServer() throws BridgeDBException {
        this((UriMapper)SQLUriMapper.getExisting(), (StatementMaker)new DirectStatementMaker());
    }

    public WSUriServer(UriMapper uriMapper, StatementMaker statementMaker) throws BridgeDBException {
        super(uriMapper);
        this.GET_BASE_URI_FROM_CONTEXT = null;
        this.DO_NOT_CONVERT_TO_RDF = null;
        rdfFormats.add(RDFFormat.N3);
        rdfFormats.add(RDFFormat.NQUADS);
        rdfFormats.add(RDFFormat.NTRIPLES);
        rdfFormats.add(RDFFormat.JSONLD);
        rdfFormats.add(RDFFormat.RDFA);
        rdfFormats.add(RDFFormat.RDFJSON);
        rdfFormats.add(RDFFormat.RDFXML);
        rdfFormats.add(RDFFormat.TRIG);
        rdfFormats.add(RDFFormat.TRIX);
        rdfFormats.add(RDFFormat.TURTLE);
        logger.info((Object)"WsUriServer setup");
        this.statementMaker = statementMaker;
    }

    @GET
    @Produces(value={"text/html"})
    public Response welcomeMessage(@Context HttpServletRequest httpServletRequest) throws BridgeDBException, UnsupportedEncodingException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"welcomeMessage called!");
        }
        return this.bridgeDbHome(httpServletRequest);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/BridgeDb")
    public Response bridgeDbHome(@Context HttpServletRequest httpServletRequest) throws BridgeDBException, UnsupportedEncodingException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"bridgeDbHome called");
        }
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("targetUriPatterns", (Object)UriPattern.getUriPatterns());
        velocityContext.put("lenses", (Object)LensTools.getLens((String)"all"));
        String mapUriScripts = WebTemplates.getForm(velocityContext, "selectorsScripts.vm");
        String mapUriForm = this.mapUriForm(EXCLUDE_GRAPH, httpServletRequest);
        velocityContext.put("api", (Object)"BridgeDbApi");
        velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
        velocityContext.put("getMappingInfo", (Object)"mappingSet");
        velocityContext.put("map", (Object)"map");
        velocityContext.put("mapURI", (Object)"mapUri");
        velocityContext.put("mapUriForm", (Object)mapUriForm);
        String mainBody = WebTemplates.getForm(velocityContext, "bridgeDBHome.vm");
        String fullPage = this.createHtmlPage("Home page for BridgeDB WebServer", mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/mapURI")
    public Response mapURI(@Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"mapURI called");
        }
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("targetUriPatterns", (Object)UriPattern.getUriPatterns());
        velocityContext.put("lenses", (Object)LensTools.getLens((String)"all"));
        String mainBody = WebTemplates.getForm(velocityContext, "selectorsScripts.vm");
        String fullPage = this.createHtmlPage("mapURI Service", mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/dataSource/{id}")
    public Response getDataSourceHtml(@PathParam(value="id") String id, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        DataSource ds = DataSource.getExistingBySystemCode((String)id);
        if (this.noContentOnEmpty & ds == null) {
            return this.noContentWrapper(httpServletRequest);
        }
        Set uriPatterns = this.uriMapper.getUriPatterns(id);
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("dataSource", (Object)ds);
        velocityContext.put("id", (Object)"$id");
        velocityContext.put("Patterns", (Object)uriPatterns);
        String mainBody = WebTemplates.getForm(velocityContext, "dataSource.vm");
        String fullPage = this.createHtmlPage("Data Source " + id + " Summary", mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/SourceInfos")
    public Response getSourceInfosHtml(@QueryParam(value="lensUri") String lensUri, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getSourceInfosHtml called");
        }
        return this.getSourceInfosHtml(lensUri, httpServletRequest, null);
    }

    private Response getSourceInfosHtml(String lensUri, HttpServletRequest httpServletRequest, String message) throws BridgeDBException {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("SourceInfos", (Object)this.uriMapper.getSourceInfos(lensUri));
        velocityContext.put("lens", (Object)lensUri);
        velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
        velocityContext.put("message", (Object)message);
        String mainBody = WebTemplates.getForm(velocityContext, "sourceInfos.vm");
        String fullPage = this.createHtmlPage("Data Source Summary", mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/SourceTargetInfos")
    public Response getSourceTargetInfosHtml(@QueryParam(value="sourceCode") String scrCode, @QueryParam(value="lensUri") String lensUri, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getSourceTargetInfosHtml called with " + scrCode));
        }
        if (scrCode == null || scrCode.isEmpty()) {
            return this.getSourceInfosHtml(lensUri, httpServletRequest, "Due to the size of your request only a summary by source is being shown");
        }
        return this.getSourceTargetInfosHtml(scrCode, lensUri, httpServletRequest, null);
    }

    private Response getSourceTargetInfosHtml(String scrCode, String lensUri, HttpServletRequest httpServletRequest, String message) throws BridgeDBException {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("SourceTargetInfos", (Object)this.uriMapper.getSourceTargetInfos(scrCode, lensUri));
        velocityContext.put("scrCode", (Object)scrCode);
        velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
        velocityContext.put("lens", (Object)lensUri);
        velocityContext.put("message", (Object)message);
        String mainBody = WebTemplates.getForm(velocityContext, "sourceTargetInfos.vm");
        String fullPage = this.createHtmlPage("Data Source Summary for " + scrCode, mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/mappingSet")
    public Response getMappingSetInfosHtml(@QueryParam(value="sourceCode") String scrCode, @QueryParam(value="targetCode") String targetCode, @QueryParam(value="lensUri") String lensUri, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getMappingSetInfosHtml called with " + scrCode + " and " + targetCode));
        }
        if (scrCode == null || scrCode.isEmpty()) {
            return this.getSourceInfosHtml(lensUri, httpServletRequest, "Due to the size of your request only a summary by source is being shown");
        }
        if (targetCode == null || targetCode.isEmpty()) {
            return this.getSourceTargetInfosHtml(scrCode, lensUri, httpServletRequest, "Due to the size of your request only a summary by target is being shown");
        }
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("MappingSetInfos", (Object)this.uriMapper.getMappingSetInfos(scrCode, targetCode, lensUri));
        velocityContext.put("scrCode", (Object)scrCode);
        velocityContext.put("targetCode", (Object)targetCode);
        velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
        velocityContext.put("lens", (Object)lensUri);
        String mainBody = WebTemplates.getForm(velocityContext, "mappingSetInfos.vm");
        String title = "Mapping Summary for " + scrCode + " -> " + targetCode;
        String fullPage = this.createHtmlPage(title, mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/mappingSet/{id}")
    public Response getMappingSetInfo(@PathParam(value="id") String idString, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        if (idString == null) {
            throw new BridgeDBException("Path parameter missing.");
        }
        if (idString.isEmpty()) {
            throw new BridgeDBException("Path parameter may not be null.");
        }
        int id = Integer.parseInt(idString);
        MappingSetInfo info = this.uriMapper.getMappingSetInfo(id);
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("mappingSetInfo", (Object)info);
        String mainBody = WebTemplates.getForm(velocityContext, "mappingSet.vm");
        String fullPage = this.createHtmlPage("Mapping Set " + id, mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Path(value="/mappingSetRDF/{id}")
    @Produces(value={"text/html"})
    public Response getMappingSetRdfHtml(@PathParam(value="id") String idString, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        return this.getMappingSetRdfHtml(idString, this.GET_BASE_URI_FROM_CONTEXT, this.DO_NOT_CONVERT_TO_RDF, httpServletRequest);
    }

    @GET
    @Path(value="/mappingSetRDF/{id}")
    @Produces(value={"text/plain"})
    public Response getMappingSetRdfText(@PathParam(value="id") String idString, @Context Request request, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        return this.getMappingSetRdfText(idString, this.GET_BASE_URI_FROM_CONTEXT, this.DO_NOT_CONVERT_TO_RDF, request, httpServletRequest);
    }

    @GET
    @Path(value="/mappingSetRDF")
    @Produces(value={"text/plain", "text/turtle", "application/rdf+xml", "application/n-triples", "application/ld+json", "application/trig"})
    public Response getMappingSetRdfText(@QueryParam(value="id") String idString, @QueryParam(value="baseUri") String baseUri, @QueryParam(value="rdfFormat") String formatName, @Context Request request, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        String context;
        Set<Statement> statements = this.getMappingSetStatements(idString, baseUri = this.checkBaseUri(baseUri, httpServletRequest), context = this.checkContext(baseUri, httpServletRequest));
        if (this.noContentOnEmpty & statements.isEmpty()) {
            return Response.noContent().build();
        }
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (RDFFormat f : rdfFormats) {
            types.add(MediaType.valueOf((String)f.getDefaultMIMEType()));
            types.addAll(MediaTypes.createMediaTypes((String[])f.getMIMETypes().toArray(new String[0])));
        }
        List variants = Variant.VariantListBuilder.newInstance().mediaTypes(types.toArray(new MediaType[0])).build();
        Variant variant = request.selectVariant(variants);
        RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)variant.getMediaType().toString(), rdfFormats).get();
        String rdfInfo = BridgeDbRdfTools.writeRDF(statements, (RDFFormat)format);
        return Response.ok((Object)rdfInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    @GET
    @Path(value="/mappingSetRDF")
    @Produces(value={"text/html"})
    public Response getMappingSetRdfHtml(@QueryParam(value="id") String idString, @QueryParam(value="baseUri") String baseUri, @QueryParam(value="rdfFormat") String formatName, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        StringBuilder sb = new StringBuilder();
        baseUri = this.checkBaseUri(baseUri, httpServletRequest);
        String context = this.checkContext(baseUri, httpServletRequest);
        Set<Statement> statements = this.getMappingSetStatements(idString, baseUri, context);
        sb.append("<h4>Use MediaType.TEXT_PLAIN to return remove HTML stuff</h4>");
        sb.append("<p>Warning MediaType.TEXT_PLAIN version returns status 204 if no mappings found.</p>");
        RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)formatName, rdfFormats).get();
        if (formatName != null || formatName != null) {
            this.generateTextarea(sb, "RDF", BridgeDbRdfTools.writeRDF(statements, (RDFFormat)format));
        } else {
            sb.append("<p>Warning MediaType.TEXT_PLAIN version returns RDF using the default format even if no format specified.</p>");
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("statements", statements);
            velocityContext.put("subject", (Object)"mappingSet");
            sb.append(WebTemplates.getForm(velocityContext, "rdfQuad.vm"));
        }
        String fullPage = this.createHtmlPage("MappingSet " + idString, sb.toString(), httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    private int[] splitId(String idString) throws BridgeDBException {
        String[] stringIds = idString.split("_");
        int[] ids = new int[stringIds.length];
        for (int i = 0; i < ids.length; ++i) {
            try {
                ids[i] = Integer.parseInt(stringIds[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new BridgeDBException("Illegal id String: " + idString + " Expected 1 or more numbers seperated by underscore. ", (Throwable)ex);
            }
        }
        return ids;
    }

    protected Set<Statement> getMappingSetStatements(String idString, String baseUri, String context) throws BridgeDBException {
        if (idString == null || idString.isEmpty()) {
            throw new BridgeDBException("id parameter is missing");
        }
        int[] ids = this.splitId(idString);
        if (ids.length == 1) {
            return this.statementMaker.asRDF(this.uriMapper.getMappingSetInfo(ids[0]), baseUri, context);
        }
        HashSet<Statement> statements = new HashSet<Statement>();
        for (int id : ids) {
            statements.addAll(this.statementMaker.asRDF(this.uriMapper.getMappingSetInfo(id), baseUri, context));
        }
        return statements;
    }

    private Set<Statement> getMappingSetStatements(Set<Mapping> mappings, String baseUri, String context) throws BridgeDBException {
        HashSet<Statement> results = new HashSet<Statement>();
        for (Mapping mapping : mappings) {
            if (mapping.getPredicate() == null) continue;
            results.addAll(this.getMappingSetStatements(mapping.getMappingSetId(), baseUri, context));
        }
        return results;
    }

    private String checkBaseUri(String baseUri, HttpServletRequest httpServletRequest) throws BridgeDBException {
        if (baseUri == null || baseUri.isEmpty()) {
            StringBuffer url = httpServletRequest.getRequestURL();
            return url.substring(0, url.length() - httpServletRequest.getPathInfo().length() + 1);
        }
        return baseUri;
    }

    private String checkContext(String baseUri, HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getQueryString() == null) {
            return baseUri + httpServletRequest.getPathInfo();
        }
        return baseUri + httpServletRequest.getPathInfo() + "?" + httpServletRequest.getQueryString();
    }

    @GET
    @Path(value="/mapUriRDF")
    @Produces(value={"text/html"})
    public Response mapUriRdfHtml(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns, @QueryParam(value="baseUri") String baseUri, @QueryParam(value="rdfFormat") String formatName, @QueryParam(value="linksetInfo") Boolean linksetInfo, @QueryParam(value="overridePredicateURI") String overridePredicateURI, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        String fullPage;
        Set<Statement> statements = this.mapUriRdfInner(uris, lensUri, graph, targetUriPatterns, baseUri, formatName, linksetInfo, overridePredicateURI, httpServletRequest);
        if (formatName != null || formatName != null) {
            StringBuilder sb = new StringBuilder();
            RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)formatName, rdfFormats).get();
            this.generateTextarea(sb, "RDF", BridgeDbRdfTools.writeRDF(statements, (RDFFormat)format));
            fullPage = this.createHtmlPage("mapUri as RDF", sb.toString(), httpServletRequest);
        } else {
            String contextPath = httpServletRequest.getContextPath();
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("statements", statements);
            velocityContext.put("subject", (Object)"mapUri");
            velocityContext.put("contextPath", (Object)contextPath);
            String table = WebTemplates.getForm(velocityContext, "rdfQuad.vm");
            fullPage = this.createTablePage("mapUri as RDF", table, httpServletRequest);
        }
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    private void addTableCss(StringBuilder sb) {
        VelocityContext velocityContext = new VelocityContext();
        sb.append(WebTemplates.getForm(velocityContext, "jquery_dataTables_css.vm"));
    }

    private void addJQuery(StringBuilder sb) {
        VelocityContext velocityContext = new VelocityContext();
        sb.append(WebTemplates.getForm(velocityContext, "jquery.vm"));
    }

    private void addDataTable(StringBuilder sb) {
        VelocityContext velocityContext = new VelocityContext();
        sb.append(WebTemplates.getForm(velocityContext, "dataTables.vm"));
    }

    @GET
    @Path(value="/mapUriRDF")
    @Produces(value={"text/plain"})
    public Response mapUriRdfText(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns, @QueryParam(value="baseUri") String baseUri, @QueryParam(value="rdfFormat") String formatName, @QueryParam(value="linksetInfo") Boolean linksetInfo, @QueryParam(value="overridePredicateURI") String overridePredicateURI, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        Set<Statement> statements = this.mapUriRdfInner(uris, lensUri, graph, targetUriPatterns, baseUri, formatName, linksetInfo, overridePredicateURI, httpServletRequest);
        if (this.noContentOnEmpty & statements.isEmpty()) {
            return Response.noContent().build();
        }
        RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)formatName, rdfFormats).get();
        String rdfInfo = BridgeDbRdfTools.writeRDF(statements, (RDFFormat)format);
        return Response.ok((Object)rdfInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    private Set<Statement> mapUriRdfInner(List<String> uris, String lensUri, String graph, List<String> targetUriPatterns, String baseUri, String formatName, Boolean linksetInfo, String overridePredicateURI, HttpServletRequest httpServletRequest) throws BridgeDBException {
        Set<Mapping> mappings;
        boolean addLinks = linksetInfo == null ? false : linksetInfo;
        if (overridePredicateURI != null && overridePredicateURI.isEmpty()) {
            overridePredicateURI = null;
        }
        if (uris.size() == 1) {
            mappings = this.uriMapper.mapFull(uris.iterator().next(), lensUri, Boolean.valueOf(false), graph, targetUriPatterns);
        } else {
            mappings = new HashSet();
            for (String single : uris) {
                mappings.addAll(this.uriMapper.mapFull(single, lensUri, Boolean.valueOf(false), graph, targetUriPatterns));
            }
        }
        baseUri = this.checkBaseUri(baseUri, httpServletRequest);
        String context = this.checkContext(baseUri, httpServletRequest);
        Set statements = this.statementMaker.asRDF(mappings, baseUri, addLinks, overridePredicateURI);
        if (formatName != null || formatName != null) {
            RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)formatName, rdfFormats).get();
            if (linksetInfo != null && linksetInfo.booleanValue() && format.supportsContexts()) {
                statements.addAll(this.getMappingSetStatements(mappings, baseUri, context));
            }
        } else if (linksetInfo != null && linksetInfo.booleanValue()) {
            statements.addAll(this.getMappingSetStatements(mappings, baseUri, context));
        }
        return statements;
    }

    private String mapUriForm(boolean includeGraph, HttpServletRequest httpServletRequest) throws BridgeDBException {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("targetUriPatterns", (Object)UriPattern.getUriPatterns());
        velocityContext.put("lenses", (Object)LensTools.getLens((String)"all"));
        velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
        velocityContext.put("defaultLens", (Object)LensTools.byId((String)"Default"));
        velocityContext.put("formatName", (Object)"format");
        if (includeGraph) {
            velocityContext.put("graphName", (Object)"graph");
            velocityContext.put("graphs", (Object)GraphResolver.knownGraphs());
        }
        velocityContext.put("lenses", (Object)LensTools.getLens((String)"all"));
        velocityContext.put("lensURIName", (Object)"lensUri");
        velocityContext.put("mapURI", (Object)"mapUri");
        velocityContext.put("targetUriPatternName", (Object)"targetUriPattern");
        velocityContext.put("URI", (Object)"Uri");
        return WebTemplates.getForm(velocityContext, "mapUriForm.vm");
    }

    @Override
    @GET
    @Produces(value={"text/html"})
    @Path(value="/api")
    public Response apiPage(@Context HttpServletRequest httpServletRequest) throws BridgeDBException, UnsupportedEncodingException {
        return this.imsApiPage(httpServletRequest);
    }

    @Override
    @GET
    @Produces(value={"text/html"})
    @Path(value="/Lens")
    public Response getLensesHtml(@QueryParam(value="lensUri") String lensUri, @QueryParam(value="lensGroup") String lensGroup, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        List<Lens> lenses = this.getTheLens(lensUri, lensGroup);
        StringBuilder sb = new StringBuilder();
        if (lensUri != null && !lensUri.isEmpty()) {
            sb.append("<h2>For ").append("lensUri").append("=").append(lensUri).append("</h2>");
        } else if (lensGroup != null && !lensGroup.isEmpty()) {
            sb.append("<h2>For ").append("lensGroup").append("=").append(lensGroup).append("</h2>");
        } else {
            sb.append("<h2>For the public lens </h2>");
        }
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("lenses", lenses);
        velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
        velocityContext.put("dataSourceMethod", (Object)"dataSource/");
        sb.append(WebTemplates.getForm(velocityContext, "lensTable.vm"));
        sb.append("<p><a href=\"");
        sb.append(httpServletRequest.getContextPath());
        sb.append("/");
        sb.append("Lens");
        sb.append("XML");
        if (lensUri != null && !lensUri.isEmpty()) {
            sb.append("?");
            sb.append("lensUri");
            sb.append("=");
            sb.append(lensUri);
        } else if (lensGroup != null && !lensGroup.isEmpty()) {
            sb.append("?");
            sb.append("lensGroup");
            sb.append("=");
            sb.append(lensGroup);
        }
        sb.append("\">");
        sb.append("XML Format");
        sb.append("</a></p>\n");
        this.addLensGroups(sb, httpServletRequest);
        String fullPage = this.createHtmlPage("Lens Summary", sb.toString(), httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/lensGroup")
    public Response getLensGroup(@Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        StringBuilder sb = new StringBuilder();
        this.addLensGroups(sb, httpServletRequest);
        String fullPage = this.createHtmlPage("Lens Groups", sb.toString(), httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    private void addLensGroups(StringBuilder sb, HttpServletRequest httpServletRequest) {
        Set lensGroups = LensTools.getLensGroups();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("lensGroups", (Object)lensGroups);
        velocityContext.put("lensCall", (Object)(httpServletRequest.getContextPath() + "/" + "Lens" + "?" + "lensGroup" + "="));
        sb.append(WebTemplates.getForm(velocityContext, "lensGroup.vm"));
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/graphviz")
    public Response graphvizDot(@QueryParam(value="lensUri") String lensUri) throws BridgeDBException, UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        List rawProvenaceinfos = this.uriMapper.getMappingSetInfos(null, null, lensUri);
        SourceTargetCounter sourceTargetCounter = new SourceTargetCounter(rawProvenaceinfos);
        sb.append("digraph G {");
        for (MappingSetInfo info : sourceTargetCounter.getSummaryInfos()) {
            if (info.getSource().compareTo(info.getTarget()) >= 0) continue;
            sb.append("\"");
            sb.append(info.getSource().getFullName());
            sb.append("\" -> \"");
            sb.append(info.getTarget().getFullName());
            sb.append("\" [dir = both, label=\"");
            sb.append(this.formatter.format(info.getNumberOfLinks()) + "(" + info.getStringId() + ")");
            sb.append("\"");
            if (info.isTransitive()) {
                sb.append(", style=dashed");
            }
            sb.append("];\n");
        }
        sb.append("}");
        return Response.ok((Object)sb.toString(), (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/mapBySetRDF")
    @Deprecated
    public Response mapBySetRdfText(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns, @QueryParam(value="rdfFormat") String formatName, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        MappingsBySet mappingsBySet = this.mapBySetInner(uris, lensUri, graph, targetUriPatterns);
        if (mappingsBySet.isEmpty()) {
            return Response.noContent().build();
        }
        Set statements = this.statementMaker.asRDF(mappingsBySet, this.getBaseUri(httpServletRequest), "mappingSetRDF");
        RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)formatName, rdfFormats).get();
        String rdf = BridgeDbRdfTools.writeRDF((Set)statements, (RDFFormat)format);
        return Response.ok((Object)rdf, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    protected final void generateTextarea(StringBuilder sb, String fieldName, String text) {
        sb.append("<p>").append(fieldName);
        sb.append("<br/><textarea rows=\"40\" name=\"").append(fieldName).append("\" style=\"width:100%; background-color: #EEEEFF;\">");
        if (text != null) {
            sb.append(text);
        }
        sb.append("</textarea></p>\n");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/mapBySetRDF")
    @Deprecated
    public Response mapBySetRdfHtml(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns, @QueryParam(value="rdfFormat") String formatName, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        MappingsBySet mappingsBySet = this.mapBySetInner(uris, lensUri, graph, targetUriPatterns);
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>Warning unlike ");
        sb.append("mapBySet");
        sb.append(" this method does not include any protential mapping to self.</h2>");
        sb.append("<h4>Use MediaType.TEXT_PLAIN to remove HTML stuff</h4>");
        sb.append("<p>Warning MediaType.TEXT_PLAIN version returns status 204 if no mappings found.</p>");
        String fullBaseUri = this.getBaseUri(httpServletRequest);
        int pureLenght = fullBaseUri.length() - "mapBySet".length() - "RDF".length();
        String pureBaseUri = fullBaseUri.substring(0, pureLenght);
        Set statements = this.statementMaker.asRDF(mappingsBySet, pureBaseUri, "mappingSetRDF");
        RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)formatName, rdfFormats).get();
        String rdf = BridgeDbRdfTools.writeRDF((Set)statements, (RDFFormat)format);
        this.generateTextarea(sb, "RDF", rdf);
        String title = "HTML friendly mapBySetRDF Output";
        String fullPage = this.createHtmlPage(title, sb.toString(), httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/LensRDF")
    public Response lensRdfText(@QueryParam(value="rdfFormat") String formatName, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        Set statements = LensTools.getLensAsRdf((String)this.getBaseUri(httpServletRequest), (String)"all");
        if (statements.isEmpty()) {
            return Response.noContent().build();
        }
        RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)formatName, rdfFormats).get();
        String rdf = BridgeDbRdfTools.writeRDF((Set)statements, (RDFFormat)format);
        return Response.ok((Object)rdf, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/LensRDF")
    public Response lensRdfHtml(@QueryParam(value="rdfFormat") String formatName, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        Set statements = LensTools.getLensAsRdf((String)this.getBaseUri(httpServletRequest), (String)"all");
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>Warning unlike ");
        sb.append("mapBySet");
        sb.append(" this method does not include any protential mapping to self.</h2>");
        sb.append("<h4>Use MediaType.TEXT_PLAIN to remove HTML stuff</h4>");
        sb.append("<p>Warning MediaType.TEXT_PLAIN version returns status 204 if no mappings found.</p>");
        RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType((String)formatName, rdfFormats).get();
        String rdf = BridgeDbRdfTools.writeRDF((Set)statements, (RDFFormat)format);
        this.generateTextarea(sb, "RDF", rdf);
        String title = "HTML friendly mapBySetRDF Output";
        String fullPage = this.createHtmlPage(title, sb.toString(), httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @Override
    @GET
    @Produces(value={"text/html"})
    @Path(value="/mapBySet")
    public Response mapBySetHtml(@QueryParam(value="Uri") List<String> uris, @QueryParam(value="lensUri") String lensUri, @QueryParam(value="graph") String graph, @QueryParam(value="targetUriPattern") List<String> targetUriPatterns, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        Response result = this.mapBySet(uris, lensUri, graph, targetUriPatterns);
        if (this.noContentOnEmpty & result.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return result;
    }

    protected Response noContentWrapper(HttpServletRequest httpServletRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>Reply is an Empty Set or Empty Object</h1>\n");
        sb.append("<h2>Note: The XML and Json versions of this request simply return status 204 (No Context)</h2>");
        String fullPage = this.createHtmlPage("Empty Reply", sb.toString(), httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    private String getBaseUri(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getRequestURI();
    }

    @POST
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/URISpacesPerGraph")
    public List<URISpacesInGraphBean> URISpacesPerGraphAsXML() throws BridgeDBException {
        Map mappings = GraphResolver.getInstance().getAllowedUriPatterns();
        ArrayList<URISpacesInGraphBean> results = new ArrayList<URISpacesInGraphBean>();
        for (String graph : mappings.keySet()) {
            HashSet<String> patternStrings = new HashSet<String>();
            for (RegexUriPattern pattern : (Set)mappings.get(graph)) {
                patternStrings.add(pattern.getUriPattern());
            }
            results.add(new URISpacesInGraphBean(graph, patternStrings));
        }
        return results;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/URISpacesPerGraph")
    public List<URISpacesInGraphBean> URISpacesPerGraphAsXMLGet() throws BridgeDBException {
        return this.URISpacesPerGraphAsXML();
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="/URISpacesPerGraph")
    public Response URISpacesPerGraphAsHtml(@Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("mappings", (Object)GraphResolver.getInstance().getAllowedUriPatterns());
        String mainBody = WebTemplates.getForm(velocityContext, "uriSpacesPerGraph.vm");
        String fullPage = this.createHtmlPage("URI Spaces per Graph", mainBody, httpServletRequest);
        return Response.ok((Object)fullPage, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/URISpacesPerGraph")
    public Response URISpacesPerGraphAsHtmlGet(@Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        return this.URISpacesPerGraphAsHtml(httpServletRequest);
    }

    @GET
    @Path(value="/file/{id}")
    @Produces(value={"text/plain"})
    public Response getFile(@PathParam(value="id") String idString) throws MalformedURLException {
        Response.ResponseBuilder response;
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream input = classLoader.getResourceAsStream(idString);
        if (input != null) {
            response = Response.ok();
            response.header("Content-Disposition", (Object)("attachment; filename=" + idString));
            response.entity((Object)input);
        } else {
            String message = "File : " + idString + " not found";
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message);
        }
        return response.build();
    }

    @GET
    @Path(value="/image/{id}")
    @Produces(value={"image/png"})
    public Response getImage(@PathParam(value="id") String idString) throws MalformedURLException {
        return this.getFile(idString);
    }
}

