/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.pairs.IdSysCodePair;
import org.bridgedb.pairs.SyscodeBasedCodeMapper;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.ConfigReader;
import org.bridgedb.utils.Reporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class BridgeDbTest {
    static final Logger logger = Logger.getLogger(BridgeDbTest.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    @BeforeAll
    public static void setUplogger() throws Exception {
        ConfigReader.logToConsole();
    }

    @Test
    public void testConfigReader() throws BridgeDBException, IOException {
        InputStream stream;
        ConfigReader.getProperties();
        ConfigReader.getInputStream((String)"BridgeDb.properties");
        ConfigReader.getProperties((String)"BridgeDb.properties");
        ConfigReader.getProperty((String)"Species");
        ConfigReader.useTest();
        Assertions.assertTrue((boolean)ConfigReader.inTestMode());
        File localPropertiesFile = new File("local.properties");
        localPropertiesFile.createNewFile();
        File bridgeDbPropertiesFile = new File("BridgeDb.properties");
        bridgeDbPropertiesFile.createNewFile();
        File log4jFile = new File("log4j.properties");
        log4jFile.createNewFile();
        try {
            stream = Files.newInputStream(Paths.get("local.properties", new String[0]), new OpenOption[0]);
            try {
                BridgeDbTest.copyInputStreamToFile(stream, localPropertiesFile);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            stream = Files.newInputStream(Paths.get("BridgeDb.properties", new String[0]), new OpenOption[0]);
            try {
                BridgeDbTest.copyInputStreamToFile(stream, bridgeDbPropertiesFile);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            stream = Files.newInputStream(Paths.get("log4j.properties", new String[0]), new OpenOption[0]);
            try {
                BridgeDbTest.copyInputStreamToFile(stream, log4jFile);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file, false);){
            int read;
            byte[] bytes = new byte[8192];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }

    @Test
    public void testIdSysCodePair() throws BridgeDBException {
        IdSysCodePair sysCodePair = new IdSysCodePair("id2000", "Dr");
        IdSysCodePair sysCodePair2 = new IdSysCodePair("id2000", "Dr");
        Assertions.assertEquals((Object)"id2000", (Object)sysCodePair.getId());
        Assertions.assertEquals((Object)"Dr", (Object)sysCodePair.getSysCode());
        sysCodePair.getClass();
        System.out.println(sysCodePair.hashCode());
        sysCodePair.toString();
        sysCodePair.equals((Object)sysCodePair);
        DataSource sourceEG = DataSource.register((String)"dsEntrez Gene", (String)"Entrez Gene").asDataSource();
        DataSource sourceDrugBank = DataSource.register((String)"Dr", (String)"DrugBank").asDataSource();
        Xref source = new Xref("id1000", sourceEG);
        SyscodeBasedCodeMapper syscodeBasedCodeMapper = new SyscodeBasedCodeMapper();
        syscodeBasedCodeMapper.toIdSysCodePair(source);
        Assertions.assertNotNull((Object)syscodeBasedCodeMapper);
        SyscodeBasedCodeMapper syscodeBasedCodeMapper2 = new SyscodeBasedCodeMapper();
        Assertions.assertNotNull((Object)syscodeBasedCodeMapper2.toXref(sysCodePair));
    }

    @Test
    public void testBridgeDbException() throws BridgeDBException {
        BridgeDBException exc = new BridgeDBException("test message");
        Throwable throwNull = new Throwable("NullPointer", null);
        BridgeDBException excThrow = new BridgeDBException("test message", throwNull);
        Assertions.assertNotNull((Object)excThrow);
        BridgeDBException excThrow2 = new BridgeDBException("test message", throwNull, "test query");
        Assertions.assertNotNull((Object)excThrow2);
        IDMapperException idExc = new IDMapperException("IDMapperException");
        BridgeDBException idException = new BridgeDBException(idExc);
        Assertions.assertNotNull((Object)BridgeDBException.convertToBridgeDB((IDMapperException)idExc));
    }

    @Test
    public void testReporter() throws BridgeDBException {
        Reporter report = new Reporter();
        Reporter.println((String)"reporter print");
        Reporter.warn((String)"warning");
        Reporter.error((String)"error");
        Exception ex = new Exception("Reporter Test Exception");
        Reporter.error((String)"error", (Exception)ex);
    }

    @Test
    public void testLogErrors() {
        logger.trace((Object)"this is a trace");
        logger.info((Object)"this in info level");
        logger.warn((Object)"Warning");
        logger.error((Object)"This is a error");
    }
}

