/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SimpleLayout;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.Reporter;

public class ConfigReader {
    public static final String CONFIG_FILE_NAME = "BridgeDb.properties";
    public static final String LOCAL_FILE_NAME = "local.properties";
    public static final String LOG_PROPERTIES_FILE = "log4j.properties";
    public static final String CONFIG_FILE_PATH_PROPERTY = "ConfigPath";
    public static final String CONFIG_FILE_PATH_SOURCE_PROPERTY = "ConfigPathSource";
    private InputStream inputStream;
    private String findMethod;
    private String foundAt;
    private String error = null;
    private Properties properties = null;
    protected static boolean useTest = false;
    protected static boolean loggerSetup = false;
    private static ConfigReader propertyReader = null;
    private static final Logger logger = Logger.getLogger(ConfigReader.class);

    public static Properties getProperties() throws BridgeDBException {
        if (propertyReader == null) {
            ConfigReader.configureLogger();
            propertyReader = new ConfigReader(CONFIG_FILE_NAME);
            propertyReader.readProperties();
            ConfigReader.propertyReader.properties = ConfigReader.addLocalProperties(ConfigReader.propertyReader.properties);
        }
        return propertyReader.readProperties();
    }

    public static Properties getProperties(String fileName) throws BridgeDBException {
        ConfigReader.configureLogger();
        ConfigReader configReader = new ConfigReader(fileName);
        Properties original = configReader.readProperties();
        return ConfigReader.addLocalProperties(original);
    }

    private static Properties addLocalProperties(Properties original) throws BridgeDBException {
        logger.info((Object)"Adding local properties");
        ConfigReader localReader = new ConfigReader(LOCAL_FILE_NAME);
        localReader.properties = new Properties();
        try {
            localReader.properties.load(localReader.getInputStream());
            localReader.inputStream.close();
        }
        catch (IOException ex) {
            throw new BridgeDBException("Unexpected file not fond exception after file.exists returns true.", ex);
        }
        original.putAll((Map<?, ?>)localReader.properties);
        return original;
    }

    public static InputStream getInputStream(String fileName) throws BridgeDBException {
        ConfigReader.configureLogger();
        ConfigReader finder = new ConfigReader(fileName);
        return finder.getInputStream();
    }

    public static synchronized void configureLogger() throws BridgeDBException {
        if (!loggerSetup) {
            ConfigReader finder = new ConfigReader(LOG_PROPERTIES_FILE);
            Properties props = finder.readProperties();
            PropertyConfigurator.configure((Properties)props);
            logger.info((Object)("Logger configured from " + finder.foundAt + " by " + finder.findMethod));
            loggerSetup = true;
        }
    }

    public static void logToConsole() throws BridgeDBException {
        ConfigReader.configureLogger();
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
    }

    protected ConfigReader() {
    }

    private ConfigReader(String fileName) throws BridgeDBException {
        Reporter.println("Looking for " + fileName);
        try {
            if (this.loadDirectly(fileName)) {
                return;
            }
            if (this.loadByEnviromentVariable(fileName)) {
                return;
            }
            if (this.loadByCatalinaHomeConfigs(fileName)) {
                return;
            }
            if (this.loadFromDirectory(fileName, "conf/BridgeDb")) {
                return;
            }
            if (this.loadFromDirectory(fileName, "../conf/BridgeDb")) {
                return;
            }
            if (this.getInputStreamWithClassLoader(fileName)) {
                return;
            }
            throw new BridgeDBException("Unable to find " + fileName);
        }
        catch (IOException ex) {
            this.error = "Unexpected IOEXception after doing checks.";
            throw new BridgeDBException(this.error, ex);
        }
    }

    private InputStream getInputStream() throws BridgeDBException {
        if (this.error != null) {
            throw new BridgeDBException(this.error);
        }
        if (this.inputStream == null) {
            this.error = "InputStream already closed. Illegal attempt to use again.";
            throw new BridgeDBException(this.error);
        }
        return this.inputStream;
    }

    private Properties readProperties() throws BridgeDBException {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                this.properties.load(this.getInputStream());
                this.properties.put(CONFIG_FILE_PATH_PROPERTY, this.foundAt);
                this.properties.put(CONFIG_FILE_PATH_SOURCE_PROPERTY, this.findMethod);
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (IOException ex) {
                this.error = "Unexpected file not fond exception after file.exists returns true.";
                throw new BridgeDBException("Unexpected file not fond exception after file.exists returns true.", ex);
            }
        }
        return this.properties;
    }

    private boolean loadDirectly(String fileName) throws FileNotFoundException {
        File file = new File(fileName);
        if (!file.exists()) {
            Reporter.println("Unable to find " + file.getAbsolutePath() + " in local Directory ");
            return false;
        }
        this.inputStream = new FileInputStream(file);
        this.findMethod = "Loaded from run Directory.";
        this.foundAt = file.getAbsolutePath();
        Reporter.println("Loaded file " + fileName + " directly from " + this.foundAt);
        return true;
    }

    private boolean loadByEnviromentVariable(String fileName) throws BridgeDBException, FileNotFoundException {
        String envPath = System.getenv().get("BRIDGEDB_CONFIG");
        if (envPath == null || envPath.isEmpty()) {
            Reporter.warn("No environment variable BRIDGEDB_CONFIG found");
            return false;
        }
        File envDir = new File(envPath);
        if (!envDir.exists()) {
            this.error = "Environment Variable BRIDGEDB_CONFIG points to " + envPath + " but no directory found there";
            throw new BridgeDBException(this.error);
        }
        if (envDir.isDirectory()) {
            File file = new File(envDir, fileName);
            if (!file.exists()) {
                Reporter.warn("No file " + fileName + " found in BRIDGEDB_CONFIG directory " + envDir.getAbsolutePath());
                return false;
            }
            this.inputStream = new FileInputStream(file);
            this.findMethod = "Loaded from Environment Variable.";
            this.foundAt = file.getAbsolutePath();
            Reporter.println("Loaded file " + fileName + " using BRIDGEDB_CONFIG from " + this.foundAt);
            return true;
        }
        this.error = "Environment Variable BRIDGEDB_CONFIG points to " + envPath + " but is not a directory";
        throw new BridgeDBException(this.error);
    }

    private boolean loadByCatalinaHomeConfigs(String fileName) throws BridgeDBException, FileNotFoundException {
        String catalinaHomePath = System.getenv().get("CATALINA_HOME");
        if (catalinaHomePath == null || catalinaHomePath.isEmpty()) {
            Reporter.warn("No enviroment variable CATALINA_HOME found");
            return false;
        }
        File catalineHomeDir = new File(catalinaHomePath);
        if (!catalineHomeDir.exists()) {
            this.error = "Environment Variable CATALINA_HOME points to " + catalinaHomePath + " but no directory found there";
            throw new BridgeDBException(this.error);
        }
        if (!catalineHomeDir.isDirectory()) {
            this.error = "Environment Variable CATALINA_HOME points to " + catalinaHomePath + " but is not a directory";
            throw new BridgeDBException(this.error);
        }
        File envDir = new File(catalineHomeDir + "/conf/BridgeDb");
        if (!envDir.exists()) {
            Reporter.warn("No directory /conf/BridgeDb found in $CATALINA_HOME directory " + catalineHomeDir.getAbsolutePath());
            return false;
        }
        if (envDir.isDirectory()) {
            File file = new File(envDir, fileName);
            if (!file.exists()) {
                Reporter.warn("No file " + fileName + " found in $CATALINA_HOME/conf/BridgeDb directory " + envDir.getAbsolutePath());
                return false;
            }
            this.inputStream = new FileInputStream(file);
            this.findMethod = "Loaded from CATALINA_HOME configs.";
            this.foundAt = file.getAbsolutePath();
            Reporter.println("Loaded file " + fileName + " using CATALINA_HOME from " + this.foundAt);
            return true;
        }
        this.error = "Environment Variable CATALINA_HOME points to " + catalinaHomePath + " but $CATALINA_HOME/conf/BridgeDb is not a directory";
        throw new BridgeDBException(this.error);
    }

    private boolean loadFromDirectory(String fileName, String directoryName) throws FileNotFoundException {
        File directory = new File(directoryName);
        if (!directory.exists()) {
            Reporter.warn("No directory found at: " + directoryName + " at " + directory.getAbsolutePath());
            return false;
        }
        if (!directory.isDirectory()) {
            Reporter.warn(directoryName + " is not a directory ");
            return false;
        }
        File file = new File(directory, fileName);
        if (!file.exists()) {
            return false;
        }
        if (!file.exists()) {
            Reporter.warn("No file " + fileName + " found in " + directory.getAbsolutePath());
            return false;
        }
        this.inputStream = new FileInputStream(file);
        this.findMethod = "Loaded from directory: " + directoryName;
        this.foundAt = file.getAbsolutePath();
        Reporter.println("Loaded file " + fileName + " from " + this.foundAt);
        return true;
    }

    private boolean getInputStreamWithClassLoader(String fileName) throws FileNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL url = classLoader.getResource(fileName);
        if (url != null) {
            try {
                this.inputStream = url.openStream();
            }
            catch (IOException ex) {
                Reporter.error("Error opeing url " + url, ex);
                return false;
            }
            this.findMethod = "Loaded with class loader";
            this.foundAt = url.getPath();
            Reporter.println("Loaded " + fileName + " from " + url + " with class loader. ");
            return true;
        }
        Reporter.println("Not found by class loader. ");
        return false;
    }

    public static String getProperty(String propertyName) throws BridgeDBException {
        Properties properties = ConfigReader.getProperties();
        return properties.getProperty(propertyName);
    }

    public static void useTest() {
        useTest = true;
    }

    public static boolean inTestMode() {
        return useTest;
    }
}

