/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.srcgen;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.jfx.srcgen.model.JFxComponent;
import org.bridje.jfx.srcgen.model.ModelInf;
import org.bridje.jfx.srcgen.model.ObjectInf;
import org.bridje.srcgen.SourceGenerator;
import org.bridje.srcgen.SrcGenService;
import org.bridje.vfs.VFile;

@Component
class JFxSourceGenerator
implements SourceGenerator<ModelInf> {
    private static final Logger LOG = Logger.getLogger(JFxSourceGenerator.class.getName());
    @Inject
    private SrcGenService srcGen;

    JFxSourceGenerator() {
    }

    public Map<ModelInf, VFile> findData() {
        try {
            return this.srcGen.findData(ModelInf.class);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public void generateSources(ModelInf modelInf, VFile file) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("model", modelInf);
        this.srcGen.createClass(modelInf.getFullName(), "jfx/Model.ftl", data);
        data = new HashMap();
        data.put("model", modelInf);
        if (modelInf.getObjects() != null) {
            for (ObjectInf objectInf : modelInf.getObjects()) {
                data.put("object", objectInf);
                this.srcGen.createClass(objectInf.getFullName(), "jfx/Object.ftl", data);
                List<JFxComponent> components = objectInf.getComponents();
                if (objectInf.getComponents() == null) continue;
                for (JFxComponent component : components) {
                    data.put("object", objectInf);
                    data.put("component", component);
                    this.srcGen.createClass(objectInf.getFullName() + component.getType(), "jfx/" + component.getType() + ".ftl", data);
                }
            }
        }
    }
}

