/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.srcgen.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import org.bridje.jfx.srcgen.model.IncludeInf;
import org.bridje.jfx.srcgen.model.JFxComponent;
import org.bridje.jfx.srcgen.model.ModelInf;
import org.bridje.jfx.srcgen.model.ObListPropertyInf;
import org.bridje.jfx.srcgen.model.ObjectInfMapping;
import org.bridje.jfx.srcgen.model.PropertyInf;
import org.bridje.jfx.srcgen.model.TableComponent;
import org.bridje.jfx.srcgen.model.TreeTableComponent;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ObjectInf {
    @XmlID
    @XmlAttribute
    private String name;
    private String description;
    @XmlAttribute
    private String key;
    @XmlAttribute
    private String toString;
    @XmlTransient
    private PropertyInf keyProperty;
    @XmlTransient
    private PropertyInf toStringProperty;
    @XmlElementWrapper(name="properties")
    @XmlElements(value={@XmlElement(name="observableList", type=ObListPropertyInf.class), @XmlElement(name="property", type=PropertyInf.class)})
    private List<PropertyInf> properties;
    @XmlElementWrapper(name="includes")
    @XmlElements(value={@XmlElement(name="include", type=IncludeInf.class)})
    private List<IncludeInf> includes;
    @XmlTransient
    private ModelInf model;
    @XmlTransient
    private List<PropertyInf> allProperties;
    @XmlElementWrapper(name="components")
    @XmlElements(value={@XmlElement(name="table", type=TableComponent.class), @XmlElement(name="treeTable", type=TreeTableComponent.class)})
    private List<JFxComponent> components;
    @XmlAttribute
    private String base;
    @XmlElementWrapper(name="mappings")
    @XmlElements(value={@XmlElement(name="mapping", type=ObjectInfMapping.class)})
    private List<ObjectInfMapping> mappings;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<PropertyInf> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyInf>();
        }
        return this.properties;
    }

    public void setProperties(List<PropertyInf> properties) {
        this.properties = properties;
    }

    public ModelInf getModel() {
        return this.model;
    }

    public String getPackage() {
        return this.model.getPackage();
    }

    public String getFullName() {
        return this.getPackage() + "." + this.getName();
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.model = (ModelInf)parent;
    }

    public PropertyInf getKeyProperty() {
        return this.keyProperty;
    }

    public void setKeyProperty(PropertyInf keyProperty) {
        if (keyProperty == null && this.key != null) {
            keyProperty = this.findProperty(this.key);
        }
        this.keyProperty = keyProperty;
    }

    public List<IncludeInf> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<IncludeInf> includes) {
        this.includes = includes;
    }

    public PropertyInf getToStringProperty() {
        if (this.toString == null && this.key != null) {
            this.toString = this.key;
        }
        if (this.toStringProperty == null && this.toString != null) {
            this.toStringProperty = this.findProperty(this.toString);
        }
        return this.toStringProperty;
    }

    public void setToStringProperty(PropertyInf toStringProperty) {
        this.toStringProperty = toStringProperty;
    }

    public List<JFxComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<JFxComponent> components) {
        this.components = components;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public List<ObjectInfMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<ObjectInfMapping> mappings) {
        this.mappings = mappings;
    }

    public PropertyInf findProperty(String propName) {
        for (PropertyInf property : this.getProperties()) {
            if (!property.getName().equals(propName)) continue;
            return property;
        }
        return null;
    }

    public boolean isList(String propName) {
        PropertyInf prop = this.findProperty(propName);
        if (prop != null) {
            return prop.getIsList();
        }
        return false;
    }

    public boolean isObject(String propName) {
        PropertyInf prop = this.findProperty(propName);
        if (prop != null) {
            return this.model.isObject(prop.getType());
        }
        return false;
    }

    public ObjectInf findObject(String propName) {
        PropertyInf prop = this.findProperty(propName);
        if (prop != null) {
            return this.model.findObject(prop.getType());
        }
        return null;
    }
}

