(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'Hyperdrive-logging-api', 'Hyperdrive-krpc-shared-impl', 'kotlinx-coroutines-core', 'Hyperdrive-krpc-shared-api', 'kotlinx-serialization-kotlinx-serialization-core-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('Hyperdrive-logging-api'), require('Hyperdrive-krpc-shared-impl'), require('kotlinx-coroutines-core'), require('Hyperdrive-krpc-shared-api'), require('kotlinx-serialization-kotlinx-serialization-core-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'Hyperdrive-krpc-client-impl'.");
    }if (typeof this['Hyperdrive-logging-api'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl'. Its dependency 'Hyperdrive-logging-api' was not found. Please, check whether 'Hyperdrive-logging-api' is loaded prior to 'Hyperdrive-krpc-client-impl'.");
    }if (typeof this['Hyperdrive-krpc-shared-impl'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl'. Its dependency 'Hyperdrive-krpc-shared-impl' was not found. Please, check whether 'Hyperdrive-krpc-shared-impl' is loaded prior to 'Hyperdrive-krpc-client-impl'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'Hyperdrive-krpc-client-impl'.");
    }if (typeof this['Hyperdrive-krpc-shared-api'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl'. Its dependency 'Hyperdrive-krpc-shared-api' was not found. Please, check whether 'Hyperdrive-krpc-shared-api' is loaded prior to 'Hyperdrive-krpc-client-impl'.");
    }if (typeof this['kotlinx-serialization-kotlinx-serialization-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl'. Its dependency 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' is loaded prior to 'Hyperdrive-krpc-client-impl'.");
    }root['Hyperdrive-krpc-client-impl'] = factory(typeof this['Hyperdrive-krpc-client-impl'] === 'undefined' ? {} : this['Hyperdrive-krpc-client-impl'], kotlin, this['Hyperdrive-logging-api'], this['Hyperdrive-krpc-shared-impl'], this['kotlinx-coroutines-core'], this['Hyperdrive-krpc-shared-api'], this['kotlinx-serialization-kotlinx-serialization-core-js-legacy']);
  }
}(this, function (_, Kotlin, $module$Hyperdrive_logging_api, $module$Hyperdrive_krpc_shared_impl, $module$kotlinx_coroutines_core, $module$Hyperdrive_krpc_shared_api, $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Logger = $module$Hyperdrive_logging_api.org.brightify.hyperdrive.Logger;
  var getKClass = Kotlin.getKClass;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var SessionNodeExtension = $module$Hyperdrive_krpc_shared_impl.org.brightify.hyperdrive.krpc.SessionNodeExtension;
  var get_isActive = $module$kotlinx_coroutines_core.kotlinx.coroutines.get_isActive_e9pf1l$;
  var DefaultRPCNode$Factory = $module$Hyperdrive_krpc_shared_impl.org.brightify.hyperdrive.krpc.protocol.DefaultRPCNode.Factory;
  var Unit = Kotlin.kotlin.Unit;
  var ClosedReceiveChannelException = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.ClosedReceiveChannelException;
  var L500 = Kotlin.Long.fromInt(500);
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_s8cxhz$;
  var Throwable = Error;
  var withContext = $module$kotlinx_coroutines_core.kotlinx.coroutines.withContext_i5cbzn$;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var get_job = $module$kotlinx_coroutines_core.kotlinx.coroutines.get_job_qdnslq$;
  var cancelAndJoin = $module$kotlinx_coroutines_core.kotlinx.coroutines.cancelAndJoin_5dx9u$;
  var filterNotNull = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.filterNotNull_4gngrh$;
  var first = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.first_x2ftfk$;
  var ServiceRegistry = $module$Hyperdrive_krpc_shared_api.org.brightify.hyperdrive.krpc.ServiceRegistry;
  var Job = $module$kotlinx_coroutines_core.kotlinx.coroutines.Job;
  var SupervisorJob = $module$kotlinx_coroutines_core.kotlinx.coroutines.SupervisorJob_5dx9e$;
  var plus = $module$kotlinx_coroutines_core.kotlinx.coroutines.plus_7n4184$;
  var SessionNodeExtension$Factory = $module$Hyperdrive_krpc_shared_impl.org.brightify.hyperdrive.krpc.SessionNodeExtension.Factory;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var MutableStateFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.MutableStateFlow_mh5how$;
  var DefaultRPCHandshakePerformer$Behavior = $module$Hyperdrive_krpc_shared_impl.org.brightify.hyperdrive.krpc.protocol.ascension.DefaultRPCHandshakePerformer.Behavior;
  var DefaultRPCHandshakePerformer = $module$Hyperdrive_krpc_shared_impl.org.brightify.hyperdrive.krpc.protocol.ascension.DefaultRPCHandshakePerformer;
  var plus_0 = Kotlin.kotlin.collections.plus_mydzjv$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var RPCTransport = $module$Hyperdrive_krpc_shared_api.org.brightify.hyperdrive.krpc.RPCTransport;
  var CoroutineScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.CoroutineScope;
  var SessionContextKeyRegistry = $module$Hyperdrive_krpc_shared_api.org.brightify.hyperdrive.krpc.session.SessionContextKeyRegistry;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var LoggingLevel = $module$Hyperdrive_logging_api.org.brightify.hyperdrive.LoggingLevel;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var printStackTrace = Kotlin.kotlin.printStackTrace_dbl4o4$;
  var wrapFunction = Kotlin.wrapFunction;
  var Flow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.Flow;
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_lsve6m$;
  var receiveAsFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.receiveAsFlow_6u4434$;
  var onStart = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.onStart_fev64r$;
  var onCompletion = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.onCompletion_sp7fh9$;
  var emitAll = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.emitAll_c14n1u$;
  var flow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.flow_sxz0o1$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var SessionNodeExtension$Plugin = $module$Hyperdrive_krpc_shared_impl.org.brightify.hyperdrive.krpc.SessionNodeExtension.Plugin;
  var PluginGeneratedSerialDescriptor = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.internal.PluginGeneratedSerialDescriptor;
  var SerializablePayloadSerializer = $module$Hyperdrive_krpc_shared_api.org.brightify.hyperdrive.krpc.SerializablePayloadSerializer;
  var UnknownFieldException = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.UnknownFieldException;
  var internal = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.internal;
  var GeneratedSerializer = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.internal.GeneratedSerializer;
  var MissingFieldException_init = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.MissingFieldException_init_61zpoe$;
  var UnsupportedKey = $module$Hyperdrive_krpc_shared_impl.org.brightify.hyperdrive.krpc.UnsupportedKey;
  var Session$Context$Item = $module$Hyperdrive_krpc_shared_api.org.brightify.hyperdrive.krpc.session.Session.Context.Item;
  var asSequence = Kotlin.kotlin.sequences.asSequence_35ci02$;
  var map = Kotlin.kotlin.sequences.map_z5avom$;
  var toList = Kotlin.kotlin.sequences.toList_veqyi0$;
  var ListSerializer = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.builtins.ListSerializer_swdriu$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  function unsafeFlow$ObjectLiteral(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$.prototype.constructor = Coroutine$collect_42ocv1$;
  Coroutine$collect_42ocv1$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda;
  Coroutine$unsafeTransform$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  var unsafeTransform$lambda = wrapFunction(function () {
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
    function collect$ObjectLiteral(closure$action) {
      this.closure$action = closure$action;
    }
    collect$ObjectLiteral.prototype.emit_11rb$ = function (value, continuation) {
      return this.closure$action(value, continuation);
    };
    collect$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [FlowCollector]};
    function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
      CoroutineImpl.call(this, continuation_0);
      this.$controller = controller;
      this.exceptionState_0 = 1;
      this.local$closure$transform = closure$transform_0;
      this.local$this$unsafeTransform = this$unsafeTransform_0;
      this.local$$receiver = $receiver_0;
    }
    Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
    Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
    Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
    Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
      do
        try {
          switch (this.state_0) {
            case 0:
              this.state_0 = 2;
              this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new collect$ObjectLiteral(unsafeTransform$lambda$lambda(this.local$closure$transform, this.local$$receiver)), this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            case 1:
              throw this.exception_0;
            case 2:
              return this.result_0;
            default:this.state_0 = 1;
              throw new Error('State Machine Unreachable execution');
          }
        } catch (e) {
          if (this.state_0 === 1) {
            this.exceptionState_0 = this.state_0;
            throw e;
          } else {
            this.state_0 = this.exceptionState_0;
            this.exception_0 = e;
          }
        }
       while (true);
    };
    return function (closure$transform_0, this$unsafeTransform_0) {
      return function ($receiver_0, continuation_0, suspended) {
        var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
        if (suspended)
          return instance;
        else
          return instance.doResume(null);
      };
    };
  });
  function Coroutine$filter$lambda(closure$predicate_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$predicate = closure$predicate_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$filter$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$filter$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$filter$lambda.prototype.constructor = Coroutine$filter$lambda;
  Coroutine$filter$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$predicate(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (this.result_0) {
              this.state_0 = 3;
              this.result_0 = this.local$$receiver.emit_11rb$(this.local$value, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 3:
            return Unit;
          case 4:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function filter$lambda(closure$predicate_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$filter$lambda(closure$predicate_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function KRPCClient(connector, runScope, frameSerializerFactory, payloadSerializerFactory, serviceRegistry, sessionContextKeyRegistry, sessionPlugins, additionalExtensions) {
    KRPCClient$Companion_getInstance();
    if (serviceRegistry === void 0)
      serviceRegistry = ServiceRegistry.Empty;
    this.connector_0 = connector;
    this.runScope_0 = runScope;
    this.frameSerializerFactory_0 = frameSerializerFactory;
    this.payloadSerializerFactory_0 = payloadSerializerFactory;
    this.serviceRegistry_0 = serviceRegistry;
    this.sessionContextKeyRegistry_0 = sessionContextKeyRegistry;
    this.sessionPlugins_0 = sessionPlugins;
    this.additionalExtensions_0 = additionalExtensions;
    this.$delegate_pprhjq$_0 = plus(runScope, SupervisorJob(runScope.coroutineContext.get_j3r2sn$(Job.Key)));
    this.builtinExtensions_0 = listOf(new SessionNodeExtension$Factory(this.sessionContextKeyRegistry_0, this.payloadSerializerFactory_0, this.sessionPlugins_0));
    this.activeNode_1 = MutableStateFlow(null);
    this.handshakePerformer_0 = new DefaultRPCHandshakePerformer(this.frameSerializerFactory_0, DefaultRPCHandshakePerformer$Behavior.Client);
    this.combinedExtensions_0 = plus_0(this.builtinExtensions_0, this.additionalExtensions_0);
  }
  function KRPCClient$Companion() {
    KRPCClient$Companion_instance = this;
    this.logger = Logger.Companion.invoke_lmshww$(getKClass(KRPCClient));
  }
  KRPCClient$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var KRPCClient$Companion_instance = null;
  function KRPCClient$Companion_getInstance() {
    if (KRPCClient$Companion_instance === null) {
      new KRPCClient$Companion();
    }return KRPCClient$Companion_instance;
  }
  function Coroutine$requireSession($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$requireSession.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$requireSession.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$requireSession.prototype.constructor = Coroutine$requireSession;
  Coroutine$requireSession.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.activeNode_0(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var value = this.result_0.getExtension_mof857$(SessionNodeExtension.Identifier);
            var requireNotNull$result;
            if (value == null) {
              var message = "Couldn't get session, probably the other party doesn't have the session extension active.";
              throw IllegalArgumentException_init(message.toString());
            } else {
              requireNotNull$result = value;
            }

            return requireNotNull$result;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KRPCClient.prototype.requireSession = function (continuation_0, suspended) {
    var instance = new Coroutine$requireSession(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$withSession_bclh2w$($this, block_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$block = block_0;
  }
  Coroutine$withSession_bclh2w$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$withSession_bclh2w$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$withSession_bclh2w$.prototype.constructor = Coroutine$withSession_bclh2w$;
  Coroutine$withSession_bclh2w$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.requireSession(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var session = this.result_0;
            return this.local$block(session);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KRPCClient.prototype.withSession_bclh2w$ = function (block_0, continuation_0, suspended) {
    var instance = new Coroutine$withSession_bclh2w$(this, block_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$KRPCClient$run$lambda$lambda$lambda(closure$node_0, this$KRPCClient_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$node = closure$node_0;
    this.local$this$KRPCClient = this$KRPCClient_0;
  }
  Coroutine$KRPCClient$run$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$KRPCClient$run$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$KRPCClient$run$lambda$lambda$lambda.prototype.constructor = Coroutine$KRPCClient$run$lambda$lambda$lambda;
  Coroutine$KRPCClient$run$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var $this = KRPCClient$Companion_getInstance().logger;
            var level = LoggingLevel.Info;
            if ($this.isLoggingEnabled_8vfh7l$(level)) {
              println($this.format_gszidq$(level, 'Client node initialized.'));
              null != null ? (printStackTrace(null), Unit) : null;
            }
            return this.local$this$KRPCClient.activeNode_1.value = this.local$closure$node, Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function KRPCClient$run$lambda$lambda$lambda(closure$node_0, this$KRPCClient_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$KRPCClient$run$lambda$lambda$lambda(closure$node_0, this$KRPCClient_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$KRPCClient$run$lambda$lambda(this$KRPCClient_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$KRPCClient = this$KRPCClient_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$KRPCClient$run$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$KRPCClient$run$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$KRPCClient$run$lambda$lambda.prototype.constructor = Coroutine$KRPCClient$run$lambda$lambda;
  Coroutine$KRPCClient$run$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var $this = KRPCClient$Companion_getInstance().logger;
            var level = LoggingLevel.Info;
            if ($this.isLoggingEnabled_8vfh7l$(level)) {
              println($this.format_gszidq$(level, 'Connection created: ' + this.local$$receiver));
              null != null ? (printStackTrace(null), Unit) : null;
            }
            this.state_0 = 2;
            this.result_0 = (new DefaultRPCNode$Factory(this.local$this$KRPCClient.handshakePerformer_0, this.local$this$KRPCClient.payloadSerializerFactory_0, this.local$this$KRPCClient.combinedExtensions_0, this.local$this$KRPCClient.serviceRegistry_0)).create_p4fu0n$(this.local$$receiver, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var node = this.result_0;
            this.state_0 = 3;
            this.result_0 = node.run_g2bo5h$(KRPCClient$run$lambda$lambda$lambda(node, this.local$this$KRPCClient), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            var $this_0 = KRPCClient$Companion_getInstance().logger;
            var level_0 = LoggingLevel.Info;
            if ($this_0.isLoggingEnabled_8vfh7l$(level_0)) {
              println($this_0.format_gszidq$(level_0, 'Relasing connection: ' + this.local$$receiver));
              null != null ? (printStackTrace(null), Unit) : null;
            }
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function KRPCClient$run$lambda$lambda(this$KRPCClient_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$KRPCClient$run$lambda$lambda(this$KRPCClient_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$KRPCClient$run$lambda(this$KRPCClient_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 8;
    this.local$this$KRPCClient = this$KRPCClient_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$KRPCClient$run$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$KRPCClient$run$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$KRPCClient$run$lambda.prototype.constructor = Coroutine$KRPCClient$run$lambda;
  Coroutine$KRPCClient$run$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 1;
            continue;
          case 1:
            if (!get_isActive(this.local$$receiver)) {
              this.state_0 = 9;
              continue;
            }
            this.exceptionState_0 = 3;
            this.state_0 = 2;
            this.result_0 = this.local$this$KRPCClient.connector_0.withConnection_7sfv2e$(KRPCClient$run$lambda$lambda(this.local$this$KRPCClient), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 2:
            this.exceptionState_0 = 8;
            this.state_0 = 7;
            continue;
          case 3:
            this.exceptionState_0 = 8;
            var t = this.exception_0;
            if (Kotlin.isType(t, Throwable)) {
              this.local$this$KRPCClient.activeNode_1.value = null;
              if (Kotlin.isType(t, ClosedReceiveChannelException) || this.local$this$KRPCClient.connector_0.isConnectionCloseException_tcv7n7$(t)) {
                var $this = KRPCClient$Companion_getInstance().logger;
                var level = LoggingLevel.Warn;
                if ($this.isLoggingEnabled_8vfh7l$(level)) {
                  println($this.format_gszidq$(level, 'Client connection disconnected. Trying to reconnect soon.'));
                  t != null ? (printStackTrace(t), Unit) : null;
                }this.state_0 = 4;
                this.result_0 = delay(L500, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                var $this_0 = KRPCClient$Companion_getInstance().logger;
                var level_0 = LoggingLevel.Error;
                if ($this_0.isLoggingEnabled_8vfh7l$(level_0)) {
                  println($this_0.format_gszidq$(level_0, 'Unexpected error! Rethrowing.'));
                  t != null ? (printStackTrace(t), Unit) : null;
                }throw t;
              }
            } else {
              throw t;
            }

          case 4:
            this.state_0 = 5;
            continue;
          case 5:
            this.state_0 = 6;
            continue;
          case 6:
            this.state_0 = 7;
            continue;
          case 7:
            this.state_0 = 1;
            continue;
          case 8:
            throw this.exception_0;
          case 9:
            return Unit;
          default:this.state_0 = 8;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 8) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function KRPCClient$run$lambda(this$KRPCClient_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$KRPCClient$run$lambda(this$KRPCClient_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  KRPCClient.prototype.run = function (continuation) {
    return withContext(this.coroutineContext, KRPCClient$run$lambda(this), continuation);
  };
  function Coroutine$KRPCClient$start$lambda(this$KRPCClient_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$KRPCClient = this$KRPCClient_0;
  }
  Coroutine$KRPCClient$start$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$KRPCClient$start$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$KRPCClient$start$lambda.prototype.constructor = Coroutine$KRPCClient$start$lambda;
  Coroutine$KRPCClient$start$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$KRPCClient.run(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function KRPCClient$start$lambda(this$KRPCClient_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$KRPCClient$start$lambda(this$KRPCClient_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  KRPCClient.prototype.start = function () {
    return launch(this, void 0, void 0, KRPCClient$start$lambda(this));
  };
  function Coroutine$close($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$close.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$close.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$close.prototype.constructor = Coroutine$close;
  Coroutine$close.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = cancelAndJoin(get_job(this.$this.coroutineContext), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KRPCClient.prototype.close = function (continuation_0, suspended) {
    var instance = new Coroutine$close(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$singleCall_pwyv76$($this, serviceCall_0, request_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$serviceCall = serviceCall_0;
    this.local$request = request_0;
  }
  Coroutine$singleCall_pwyv76$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$singleCall_pwyv76$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$singleCall_pwyv76$.prototype.constructor = Coroutine$singleCall_pwyv76$;
  Coroutine$singleCall_pwyv76$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.activeTransport_0(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.result_0.singleCall_pwyv76$(this.local$serviceCall, this.local$request, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KRPCClient.prototype.singleCall_pwyv76$ = function (serviceCall_0, request_0, continuation_0, suspended) {
    var instance = new Coroutine$singleCall_pwyv76$(this, serviceCall_0, request_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$clientStream_c3knkx$($this, serviceCall_0, request_0, clientStream_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$serviceCall = serviceCall_0;
    this.local$request = request_0;
    this.local$clientStream = clientStream_0;
  }
  Coroutine$clientStream_c3knkx$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$clientStream_c3knkx$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$clientStream_c3knkx$.prototype.constructor = Coroutine$clientStream_c3knkx$;
  Coroutine$clientStream_c3knkx$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.activeTransport_0(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.result_0.clientStream_c3knkx$(this.local$serviceCall, this.local$request, this.local$clientStream, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KRPCClient.prototype.clientStream_c3knkx$ = function (serviceCall_0, request_0, clientStream_0, continuation_0, suspended) {
    var instance = new Coroutine$clientStream_c3knkx$(this, serviceCall_0, request_0, clientStream_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$serverStream_s23hg4$($this, serviceCall_0, request_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$serviceCall = serviceCall_0;
    this.local$request = request_0;
  }
  Coroutine$serverStream_s23hg4$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$serverStream_s23hg4$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$serverStream_s23hg4$.prototype.constructor = Coroutine$serverStream_s23hg4$;
  Coroutine$serverStream_s23hg4$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.activeTransport_0(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.result_0.serverStream_s23hg4$(this.local$serviceCall, this.local$request, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KRPCClient.prototype.serverStream_s23hg4$ = function (serviceCall_0, request_0, continuation_0, suspended) {
    var instance = new Coroutine$serverStream_s23hg4$(this, serviceCall_0, request_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$biStream_4hjk1h$($this, serviceCall_0, request_0, clientStream_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$serviceCall = serviceCall_0;
    this.local$request = request_0;
    this.local$clientStream = clientStream_0;
  }
  Coroutine$biStream_4hjk1h$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$biStream_4hjk1h$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$biStream_4hjk1h$.prototype.constructor = Coroutine$biStream_4hjk1h$;
  Coroutine$biStream_4hjk1h$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.activeTransport_0(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.result_0.biStream_4hjk1h$(this.local$serviceCall, this.local$request, this.local$clientStream, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KRPCClient.prototype.biStream_4hjk1h$ = function (serviceCall_0, request_0, clientStream_0, continuation_0, suspended) {
    var instance = new Coroutine$biStream_4hjk1h$(this, serviceCall_0, request_0, clientStream_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$activeTransport_0($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$activeTransport_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$activeTransport_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$activeTransport_0.prototype.constructor = Coroutine$activeTransport_0;
  Coroutine$activeTransport_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.activeNode_0(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0.transport;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  KRPCClient.prototype.activeTransport_0 = function (continuation_0, suspended) {
    var instance = new Coroutine$activeTransport_0(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$KRPCClient$activeNode$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$KRPCClient$activeNode$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$KRPCClient$activeNode$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$KRPCClient$activeNode$lambda.prototype.constructor = Coroutine$KRPCClient$activeNode$lambda;
  Coroutine$KRPCClient$activeNode$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return get_isActive(this.local$it);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function KRPCClient$activeNode$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$KRPCClient$activeNode$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  KRPCClient.prototype.activeNode_0 = function (continuation) {
    var $receiver = filterNotNull(this.activeNode_1);
    return first(new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(filter$lambda(KRPCClient$activeNode$lambda), $receiver)), continuation);
  };
  Object.defineProperty(KRPCClient.prototype, 'coroutineContext', {
    configurable: true,
    get: function () {
      return this.$delegate_pprhjq$_0.coroutineContext;
    }
  });
  KRPCClient.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KRPCClient',
    interfaces: [CoroutineScope, RPCTransport]
  };
  function KRPCClient_init(connector, runScope, serializerRegistry, serviceRegistry, sessionContextKeyRegistry, sessionPlugins, additionalExtensions, $this) {
    if (serviceRegistry === void 0)
      serviceRegistry = ServiceRegistry.Empty;
    if (sessionContextKeyRegistry === void 0)
      sessionContextKeyRegistry = SessionContextKeyRegistry.Empty;
    if (sessionPlugins === void 0)
      sessionPlugins = emptyList();
    if (additionalExtensions === void 0)
      additionalExtensions = emptyList();
    $this = $this || Object.create(KRPCClient.prototype);
    KRPCClient.call($this, connector, runScope, serializerRegistry.transportFrameSerializerFactory, serializerRegistry.payloadSerializerFactory, serviceRegistry, sessionContextKeyRegistry, sessionPlugins, additionalExtensions);
    return $this;
  }
  function SessionContextSnapshotPlugin() {
    this.listeners_0 = ArrayList_init();
    this.latestContextSnapshot_0 = null;
  }
  function Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda(closure$listener_0, this$SessionContextSnapshotPlugin_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$listener = closure$listener_0;
    this.local$this$SessionContextSnapshotPlugin = this$SessionContextSnapshotPlugin_0;
  }
  Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda.prototype.constructor = Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda;
  Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$this$SessionContextSnapshotPlugin.registerListener_dueozy$(this.local$closure$listener), Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SessionContextSnapshotPlugin$observe$lambda$lambda(closure$listener_0, this$SessionContextSnapshotPlugin_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda(closure$listener_0, this$SessionContextSnapshotPlugin_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda_0(closure$listener_0, this$SessionContextSnapshotPlugin_0, $receiver_0, it_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$listener = closure$listener_0;
    this.local$this$SessionContextSnapshotPlugin = this$SessionContextSnapshotPlugin_0;
  }
  Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda_0.prototype.constructor = Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda_0;
  Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$this$SessionContextSnapshotPlugin.unregisterListener_dueozy$(this.local$closure$listener), Unit;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SessionContextSnapshotPlugin$observe$lambda$lambda_0(closure$listener_0, this$SessionContextSnapshotPlugin_0) {
    return function ($receiver_0, it_0, continuation_0, suspended) {
      var instance = new Coroutine$SessionContextSnapshotPlugin$observe$lambda$lambda_0(closure$listener_0, this$SessionContextSnapshotPlugin_0, $receiver_0, it_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$SessionContextSnapshotPlugin$observe$lambda(closure$key_0, this$SessionContextSnapshotPlugin_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$key = closure$key_0;
    this.local$this$SessionContextSnapshotPlugin = this$SessionContextSnapshotPlugin_0;
    this.local$channel = void 0;
    this.local$listener = void 0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$SessionContextSnapshotPlugin$observe$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$SessionContextSnapshotPlugin$observe$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$SessionContextSnapshotPlugin$observe$lambda.prototype.constructor = Coroutine$SessionContextSnapshotPlugin$observe$lambda;
  Coroutine$SessionContextSnapshotPlugin$observe$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            this.local$channel = Channel();
            this.local$listener = new SessionContextSnapshotPlugin$FlowListener(this.local$closure$key, this.local$channel);
            var contextSnapshot = this.local$this$SessionContextSnapshotPlugin.latestContextSnapshot_0;
            if (contextSnapshot != null) {
              this.state_0 = 2;
              this.result_0 = this.local$$receiver.emit_11rb$((tmp$ = contextSnapshot.get_rp3xq3$(this.local$closure$key)) != null ? tmp$.value : null, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            continue;
          case 3:
            this.state_0 = 4;
            this.result_0 = emitAll(this.local$$receiver, onCompletion(onStart(receiveAsFlow(this.local$channel), SessionContextSnapshotPlugin$observe$lambda$lambda(this.local$listener, this.local$this$SessionContextSnapshotPlugin)), SessionContextSnapshotPlugin$observe$lambda$lambda_0(this.local$listener, this.local$this$SessionContextSnapshotPlugin)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function SessionContextSnapshotPlugin$observe$lambda(closure$key_0, this$SessionContextSnapshotPlugin_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$SessionContextSnapshotPlugin$observe$lambda(closure$key_0, this$SessionContextSnapshotPlugin_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  SessionContextSnapshotPlugin.prototype.observe_rp3xq3$ = function (key) {
    return flow(SessionContextSnapshotPlugin$observe$lambda(key, this));
  };
  SessionContextSnapshotPlugin.prototype.registerListener_dueozy$ = function (listener) {
    this.listeners_0.add_11rb$(listener);
  };
  SessionContextSnapshotPlugin.prototype.unregisterListener_dueozy$ = function (listener) {
    this.listeners_0.remove_11rb$(listener);
  };
  SessionContextSnapshotPlugin.prototype.onBindComplete_88b8tg$ = function (session, continuation) {
    this.latestContextSnapshot_0 = session.copyOfContext();
  };
  function Coroutine$onContextChanged_l5v3g1$($this, session_0, modifiedKeys_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$contextSnapshot = void 0;
    this.local$session = session_0;
    this.local$modifiedKeys = modifiedKeys_0;
  }
  Coroutine$onContextChanged_l5v3g1$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onContextChanged_l5v3g1$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onContextChanged_l5v3g1$.prototype.constructor = Coroutine$onContextChanged_l5v3g1$;
  Coroutine$onContextChanged_l5v3g1$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$contextSnapshot = this.local$session.copyOfContext();
            this.$this.latestContextSnapshot_0 = this.local$contextSnapshot;
            this.local$tmp$ = this.$this.listeners_0.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 5;
              continue;
            }
            var listener = this.local$tmp$.next();
            if (this.local$modifiedKeys.contains_11rb$(listener.key)) {
              this.state_0 = 3;
              this.result_0 = this.$this.notify_0(listener, this.local$contextSnapshot, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 3:
            this.state_0 = 4;
            continue;
          case 4:
            this.state_0 = 2;
            continue;
          case 5:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  SessionContextSnapshotPlugin.prototype.onContextChanged_l5v3g1$ = function (session_0, modifiedKeys_0, continuation_0, suspended) {
    var instance = new Coroutine$onContextChanged_l5v3g1$(this, session_0, modifiedKeys_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$notify_0($this, $receiver_0, context_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$$receiver = $receiver_0;
    this.local$context = context_0;
  }
  Coroutine$notify_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$notify_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$notify_0.prototype.constructor = Coroutine$notify_0;
  Coroutine$notify_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            this.state_0 = 2;
            this.result_0 = this.local$$receiver.onValueChanged_trkh7z$((tmp$ = this.local$context.get_rp3xq3$(this.local$$receiver.key)) != null ? tmp$.value : null, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  SessionContextSnapshotPlugin.prototype.notify_0 = function ($receiver_0, context_0, continuation_0, suspended) {
    var instance = new Coroutine$notify_0(this, $receiver_0, context_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function SessionContextSnapshotPlugin$Listener() {
  }
  SessionContextSnapshotPlugin$Listener.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Listener',
    interfaces: []
  };
  function SessionContextSnapshotPlugin$FlowListener(key, channel) {
    this.key_b46xji$_0 = key;
    this.channel_0 = channel;
  }
  Object.defineProperty(SessionContextSnapshotPlugin$FlowListener.prototype, 'key', {
    get: function () {
      return this.key_b46xji$_0;
    }
  });
  function Coroutine$onValueChanged_trkh7z$($this, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$value = value_0;
  }
  Coroutine$onValueChanged_trkh7z$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onValueChanged_trkh7z$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onValueChanged_trkh7z$.prototype.constructor = Coroutine$onValueChanged_trkh7z$;
  Coroutine$onValueChanged_trkh7z$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.channel_0.send_11rb$(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  SessionContextSnapshotPlugin$FlowListener.prototype.onValueChanged_trkh7z$ = function (value_0, continuation_0, suspended) {
    var instance = new Coroutine$onValueChanged_trkh7z$(this, value_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  SessionContextSnapshotPlugin$FlowListener.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FlowListener',
    interfaces: [SessionContextSnapshotPlugin$Listener]
  };
  SessionContextSnapshotPlugin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SessionContextSnapshotPlugin',
    interfaces: [SessionNodeExtension$Plugin]
  };
  function SessionContextStoragePlugin(storage, payloadSerializerFactory, sessionContextKeyRegistry) {
    this.storage_0 = storage;
    this.payloadSerializerFactory_0 = payloadSerializerFactory;
    this.sessionContextKeyRegistry_0 = sessionContextKeyRegistry;
    this.serializationStrategy_0 = ListSerializer(SessionContextStoragePlugin$SerializedItem$Companion_getInstance().serializer());
  }
  function SessionContextStoragePlugin$SerializedItem(keyQualifiedName, revision, value) {
    SessionContextStoragePlugin$SerializedItem$Companion_getInstance();
    this.keyQualifiedName = keyQualifiedName;
    this.revision = revision;
    this.value = value;
  }
  function SessionContextStoragePlugin$SerializedItem$Companion() {
    SessionContextStoragePlugin$SerializedItem$Companion_instance = this;
  }
  SessionContextStoragePlugin$SerializedItem$Companion.prototype.serializer = function () {
    return SessionContextStoragePlugin$SerializedItem$$serializer_getInstance();
  };
  SessionContextStoragePlugin$SerializedItem$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SessionContextStoragePlugin$SerializedItem$Companion_instance = null;
  function SessionContextStoragePlugin$SerializedItem$Companion_getInstance() {
    if (SessionContextStoragePlugin$SerializedItem$Companion_instance === null) {
      new SessionContextStoragePlugin$SerializedItem$Companion();
    }return SessionContextStoragePlugin$SerializedItem$Companion_instance;
  }
  function SessionContextStoragePlugin$SerializedItem$$serializer() {
    this.descriptor_pwnyu2$_0 = new PluginGeneratedSerialDescriptor('org.brightify.hyperdrive.krpc.client.impl.SessionContextStoragePlugin.SerializedItem', this, 3);
    this.descriptor.addElement_ivxn3r$('keyQualifiedName', false);
    this.descriptor.addElement_ivxn3r$('revision', false);
    this.descriptor.addElement_ivxn3r$('value', false);
    SessionContextStoragePlugin$SerializedItem$$serializer_instance = this;
  }
  Object.defineProperty(SessionContextStoragePlugin$SerializedItem$$serializer.prototype, 'descriptor', {
    configurable: true,
    get: function () {
      return this.descriptor_pwnyu2$_0;
    }
  });
  SessionContextStoragePlugin$SerializedItem$$serializer.prototype.serialize_55azsf$ = function (encoder, value) {
    var output = encoder.beginStructure_24f42q$(this.descriptor);
    output.encodeStringElement_iij8qq$(this.descriptor, 0, value.keyQualifiedName);
    output.encodeIntElement_ptg7oe$(this.descriptor, 1, value.revision);
    output.encodeSerializableElement_r4qlx7$(this.descriptor, 2, new SerializablePayloadSerializer(), value.value);
    output.endStructure_24f42q$(this.descriptor);
  };
  SessionContextStoragePlugin$SerializedItem$$serializer.prototype.deserialize_bq71mq$ = function (decoder) {
    var index;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_24f42q$(this.descriptor);
    loopLabel: while (true) {
      index = input.decodeElementIndex_24f42q$(this.descriptor);
      switch (index) {
        case 0:
          local0 = input.decodeStringElement_szpzho$(this.descriptor, 0);
          bitMask0 |= 1;
          break;
        case 1:
          local1 = input.decodeIntElement_szpzho$(this.descriptor, 1);
          bitMask0 |= 2;
          break;
        case 2:
          local2 = input.decodeSerializableElement_12e8id$(this.descriptor, 2, new SerializablePayloadSerializer(), local2);
          bitMask0 |= 4;
          break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_24f42q$(this.descriptor);
    return SessionContextStoragePlugin$SessionContextStoragePlugin$SerializedItem_init(bitMask0, local0, local1, local2, null);
  };
  SessionContextStoragePlugin$SerializedItem$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.IntSerializer, new SerializablePayloadSerializer()];
  };
  SessionContextStoragePlugin$SerializedItem$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SessionContextStoragePlugin$SerializedItem$$serializer_instance = null;
  function SessionContextStoragePlugin$SerializedItem$$serializer_getInstance() {
    if (SessionContextStoragePlugin$SerializedItem$$serializer_instance === null) {
      new SessionContextStoragePlugin$SerializedItem$$serializer();
    }return SessionContextStoragePlugin$SerializedItem$$serializer_instance;
  }
  function SessionContextStoragePlugin$SessionContextStoragePlugin$SerializedItem_init(seen1, keyQualifiedName, revision, value, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SessionContextStoragePlugin$SerializedItem.prototype);
    if ((seen1 & 1) === 0)
      throw MissingFieldException_init('keyQualifiedName');
    else
      $this.keyQualifiedName = keyQualifiedName;
    if ((seen1 & 2) === 0)
      throw MissingFieldException_init('revision');
    else
      $this.revision = revision;
    if ((seen1 & 4) === 0)
      throw MissingFieldException_init('value');
    else
      $this.value = value;
    return $this;
  }
  SessionContextStoragePlugin$SerializedItem.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SerializedItem',
    interfaces: []
  };
  function SessionContextStoragePlugin$Storage() {
  }
  SessionContextStoragePlugin$Storage.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Storage',
    interfaces: []
  };
  function SessionContextStoragePlugin$onBindComplete$lambda(closure$resolvedItems, this$SessionContextStoragePlugin) {
    return function ($receiver) {
      var tmp$;
      tmp$ = closure$resolvedItems.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        this$SessionContextStoragePlugin.putItem_0($receiver, item);
      }
      return Unit;
    };
  }
  function Coroutine$onBindComplete_88b8tg$($this, session_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$session = session_0;
  }
  Coroutine$onBindComplete_88b8tg$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onBindComplete_88b8tg$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onBindComplete_88b8tg$.prototype.constructor = Coroutine$onBindComplete_88b8tg$;
  Coroutine$onBindComplete_88b8tg$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.storage_0.restore(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$tmp$ = this.result_0;
            if (this.local$tmp$ == null) {
              return;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 3:
            var restoredItems = this.local$tmp$;
            var deserializedItems = this.$this.payloadSerializerFactory_0.deserialize_h7get$(this.$this.serializationStrategy_0, restoredItems);
            var destination = ArrayList_init_0(collectionSizeOrDefault(deserializedItems, 10));
            var tmp$;
            tmp$ = deserializedItems.iterator();
            while (tmp$.hasNext()) {
              var item = tmp$.next();
              var tmp$_0 = destination.add_11rb$;
              var transform$result;
              var key = this.$this.sessionContextKeyRegistry_0.getKeyByQualifiedName_61zpoe$(item.keyQualifiedName);
              if (key != null) {
                transform$result = this.$this.deserialize_0(key, item);
              } else {
                transform$result = new Session$Context$Item(new UnsupportedKey(item.keyQualifiedName), item.revision, item.value);
              }
              tmp$_0.call(destination, transform$result);
            }

            var resolvedItems = destination;
            this.state_0 = 4;
            this.result_0 = this.local$session.contextTransaction_see47s$(SessionContextStoragePlugin$onBindComplete$lambda(resolvedItems, this.$this), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  SessionContextStoragePlugin.prototype.onBindComplete_88b8tg$ = function (session_0, continuation_0, suspended) {
    var instance = new Coroutine$onBindComplete_88b8tg$(this, session_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function SessionContextStoragePlugin$onContextChanged$lambda(this$SessionContextStoragePlugin) {
    return function (item) {
      return this$SessionContextStoragePlugin.serialize_0(item);
    };
  }
  function Coroutine$onContextChanged_l5v3g1$_0($this, session_0, modifiedKeys_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$session = session_0;
  }
  Coroutine$onContextChanged_l5v3g1$_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onContextChanged_l5v3g1$_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onContextChanged_l5v3g1$_0.prototype.constructor = Coroutine$onContextChanged_l5v3g1$_0;
  Coroutine$onContextChanged_l5v3g1$_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var serializedItems = map(asSequence(this.local$session.iterator()), SessionContextStoragePlugin$onContextChanged$lambda(this.$this));
            this.state_0 = 2;
            this.result_0 = this.$this.storage_0.store_b5mk1c$(this.$this.payloadSerializerFactory_0.serialize_tf03ej$(this.$this.serializationStrategy_0, toList(serializedItems)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  SessionContextStoragePlugin.prototype.onContextChanged_l5v3g1$ = function (session_0, modifiedKeys_0, continuation_0, suspended) {
    var instance = new Coroutine$onContextChanged_l5v3g1$_0(this, session_0, modifiedKeys_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  SessionContextStoragePlugin.prototype.deserialize_0 = function (key, dto) {
    var value = this.payloadSerializerFactory_0.deserialize_h7get$(key.serializer, dto.value);
    return new Session$Context$Item(key, dto.revision, value);
  };
  SessionContextStoragePlugin.prototype.serialize_0 = function ($receiver) {
    return new SessionContextStoragePlugin$SerializedItem($receiver.key.qualifiedName, $receiver.revision, this.payloadSerializerFactory_0.serialize_tf03ej$($receiver.key.serializer, $receiver.value));
  };
  SessionContextStoragePlugin.prototype.putItem_0 = function ($receiver, item) {
    $receiver.set_emtk8x$(item.key, item.value);
  };
  SessionContextStoragePlugin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SessionContextStoragePlugin',
    interfaces: [SessionNodeExtension$Plugin]
  };
  $$importsForInline$$['Hyperdrive-logging-api'] = $module$Hyperdrive_logging_api;
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  var package$org = _.org || (_.org = {});
  var package$brightify = package$org.brightify || (package$org.brightify = {});
  var package$hyperdrive = package$brightify.hyperdrive || (package$brightify.hyperdrive = {});
  var package$krpc = package$hyperdrive.krpc || (package$hyperdrive.krpc = {});
  var package$client = package$krpc.client || (package$krpc.client = {});
  var package$impl = package$client.impl || (package$client.impl = {});
  package$impl.KRPCClient_init_1o457k$ = KRPCClient_init;
  package$impl.KRPCClient = KRPCClient;
  SessionContextSnapshotPlugin.Listener = SessionContextSnapshotPlugin$Listener;
  package$impl.SessionContextSnapshotPlugin = SessionContextSnapshotPlugin;
  Object.defineProperty(SessionContextStoragePlugin$SerializedItem, 'Companion', {
    get: SessionContextStoragePlugin$SerializedItem$Companion_getInstance
  });
  Object.defineProperty(SessionContextStoragePlugin$SerializedItem, '$serializer', {
    get: SessionContextStoragePlugin$SerializedItem$$serializer_getInstance
  });
  SessionContextStoragePlugin.SerializedItem_init_kcyfm5$ = SessionContextStoragePlugin$SessionContextStoragePlugin$SerializedItem_init;
  SessionContextStoragePlugin.SerializedItem = SessionContextStoragePlugin$SerializedItem;
  SessionContextStoragePlugin.Storage = SessionContextStoragePlugin$Storage;
  package$impl.SessionContextStoragePlugin = SessionContextStoragePlugin;
  SessionContextStoragePlugin$SerializedItem$$serializer.prototype.typeParametersSerializers = GeneratedSerializer.prototype.typeParametersSerializers;
  Kotlin.defineModule('Hyperdrive-krpc-client-impl', _);
  return _;
}));

//# sourceMappingURL=Hyperdrive-krpc-client-impl.js.map
