(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'ktor-ktor-io-js-legacy', 'kotlinx-coroutines-core', 'ktor-ktor-http-js-legacy', 'ktor-ktor-client-core-js-legacy', 'Hyperdrive-krpc-shared-impl-ktor-js-legacy', 'Hyperdrive-krpc-client-api-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('ktor-ktor-io-js-legacy'), require('kotlinx-coroutines-core'), require('ktor-ktor-http-js-legacy'), require('ktor-ktor-client-core-js-legacy'), require('Hyperdrive-krpc-shared-impl-ktor-js-legacy'), require('Hyperdrive-krpc-client-api-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl-ktor-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'Hyperdrive-krpc-client-impl-ktor-js-legacy'.");
    }if (typeof this['ktor-ktor-io-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl-ktor-js-legacy'. Its dependency 'ktor-ktor-io-js-legacy' was not found. Please, check whether 'ktor-ktor-io-js-legacy' is loaded prior to 'Hyperdrive-krpc-client-impl-ktor-js-legacy'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl-ktor-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'Hyperdrive-krpc-client-impl-ktor-js-legacy'.");
    }if (typeof this['ktor-ktor-http-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl-ktor-js-legacy'. Its dependency 'ktor-ktor-http-js-legacy' was not found. Please, check whether 'ktor-ktor-http-js-legacy' is loaded prior to 'Hyperdrive-krpc-client-impl-ktor-js-legacy'.");
    }if (typeof this['ktor-ktor-client-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl-ktor-js-legacy'. Its dependency 'ktor-ktor-client-core-js-legacy' was not found. Please, check whether 'ktor-ktor-client-core-js-legacy' is loaded prior to 'Hyperdrive-krpc-client-impl-ktor-js-legacy'.");
    }if (typeof this['Hyperdrive-krpc-shared-impl-ktor-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl-ktor-js-legacy'. Its dependency 'Hyperdrive-krpc-shared-impl-ktor-js-legacy' was not found. Please, check whether 'Hyperdrive-krpc-shared-impl-ktor-js-legacy' is loaded prior to 'Hyperdrive-krpc-client-impl-ktor-js-legacy'.");
    }if (typeof this['Hyperdrive-krpc-client-api-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'Hyperdrive-krpc-client-impl-ktor-js-legacy'. Its dependency 'Hyperdrive-krpc-client-api-js-legacy' was not found. Please, check whether 'Hyperdrive-krpc-client-api-js-legacy' is loaded prior to 'Hyperdrive-krpc-client-impl-ktor-js-legacy'.");
    }root['Hyperdrive-krpc-client-impl-ktor-js-legacy'] = factory(typeof this['Hyperdrive-krpc-client-impl-ktor-js-legacy'] === 'undefined' ? {} : this['Hyperdrive-krpc-client-impl-ktor-js-legacy'], kotlin, this['ktor-ktor-io-js-legacy'], this['kotlinx-coroutines-core'], this['ktor-ktor-http-js-legacy'], this['ktor-ktor-client-core-js-legacy'], this['Hyperdrive-krpc-shared-impl-ktor-js-legacy'], this['Hyperdrive-krpc-client-api-js-legacy']);
  }
}(this, function (_, Kotlin, $module$ktor_ktor_io_js_legacy, $module$kotlinx_coroutines_core, $module$ktor_ktor_http_js_legacy, $module$ktor_ktor_client_core_js_legacy, $module$Hyperdrive_krpc_shared_impl_ktor_js_legacy, $module$Hyperdrive_krpc_client_api_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var EOFException = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.errors.EOFException;
  var get_isActive = $module$kotlinx_coroutines_core.kotlinx.coroutines.get_isActive_e9pf1l$;
  var URLProtocol = $module$ktor_ktor_http_js_legacy.io.ktor.http.URLProtocol;
  var Unit = Kotlin.kotlin.Unit;
  var webSocketSession = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.features.websocket.webSocketSession_e8a0az$;
  var WebSocketSessionConnection = $module$Hyperdrive_krpc_shared_impl_ktor_js_legacy.org.brightify.hyperdrive.krpc.ktor.WebSocketSessionConnection;
  var HttpClient = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.HttpClient_f0veat$;
  var getCallableRef = Kotlin.getCallableRef;
  var WebSockets = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.features.websocket.WebSockets;
  var Mutex = $module$kotlinx_coroutines_core.kotlinx.coroutines.sync.Mutex_6taknv$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var RPCClientConnector = $module$Hyperdrive_krpc_client_api_js_legacy.org.brightify.hyperdrive.krpc.client.RPCClientConnector;
  function WebSocketClient(host, port, path, useSecureConnection, clientFactory) {
    if (host === void 0)
      host = 'localhost';
    if (port === void 0)
      port = 8000;
    if (path === void 0)
      path = '/';
    if (useSecureConnection === void 0)
      useSecureConnection = false;
    if (clientFactory === void 0)
      clientFactory = getCallableRef('HttpClient', function (p1) {
        return HttpClient(p1);
      });
    this.host_0 = host;
    this.port_0 = port;
    this.path_0 = path;
    this.useSecureConnection_0 = useSecureConnection;
    this.httpClient_0 = clientFactory(WebSocketClient$httpClient$lambda);
    this.activeConnection_0 = null;
    this.connectingMutex_0 = Mutex();
  }
  function Coroutine$withConnection_7sfv2e$($this, block_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$connection = void 0;
    this.local$block = block_0;
  }
  Coroutine$withConnection_7sfv2e$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$withConnection_7sfv2e$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$withConnection_7sfv2e$.prototype.constructor = Coroutine$withConnection_7sfv2e$;
  Coroutine$withConnection_7sfv2e$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.connect_0(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$connection = this.result_0;
            this.state_0 = 3;
            this.result_0 = this.local$block(this.local$connection, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 4;
            this.result_0 = this.local$connection.close(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            this.$this.activeConnection_0 = null;
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketClient.prototype.withConnection_7sfv2e$ = function (block_0, continuation_0, suspended) {
    var instance = new Coroutine$withConnection_7sfv2e$(this, block_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  WebSocketClient.prototype.isConnectionCloseException_tcv7n7$ = function (throwable) {
    return Kotlin.isType(throwable, EOFException) || Kotlin.isType(throwable, EOFException);
  };
  function WebSocketClient$connect$lambda$lambda$lambda($receiver, it) {
    $receiver.protocol = URLProtocol.Companion.WSS;
    return Unit;
  }
  function WebSocketClient$connect$lambda$lambda(this$WebSocketClient) {
    return function ($receiver) {
      if (this$WebSocketClient.useSecureConnection_0) {
        $receiver.url_6yzzjr$(WebSocketClient$connect$lambda$lambda$lambda);
      }return Unit;
    };
  }
  function Coroutine$connect_0($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 8;
    this.$this = $this;
    this.local$$receiver = void 0;
  }
  Coroutine$connect_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$connect_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$connect_0.prototype.constructor = Coroutine$connect_0;
  Coroutine$connect_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$$receiver = this.$this.connectingMutex_0;
            this.state_0 = 1;
            this.result_0 = this.local$$receiver.lock_s8jyv4$(null, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            this.exceptionState_0 = 6;
            var oldConnection = this.$this.activeConnection_0;
            if (oldConnection != null && get_isActive(oldConnection)) {
              this.state_0 = 2;
              this.result_0 = oldConnection.close(this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 2:
            this.state_0 = 3;
            continue;
          case 3:
            this.state_0 = 4;
            this.result_0 = webSocketSession(this.$this.httpClient_0, void 0, this.$this.host_0, this.$this.port_0, this.$this.path_0, WebSocketClient$connect$lambda$lambda(this.$this), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            var webSocketSession_0 = this.result_0;
            var newConnection = new WebSocketSessionConnection(webSocketSession_0);
            this.$this.activeConnection_0 = newConnection;
            this.result_0 = newConnection;
            this.exceptionState_0 = 8;
            this.finallyPath_0 = [5];
            this.state_0 = 7;
            continue;
          case 5:
            return this.result_0;
          case 6:
            this.finallyPath_0 = [8];
            this.state_0 = 7;
            continue;
          case 7:
            this.exceptionState_0 = 8;
            this.local$$receiver.unlock_s8jyv4$(null);
            this.state_0 = this.finallyPath_0.shift();
            continue;
          case 8:
            throw this.exception_0;
          default:this.state_0 = 8;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 8) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  WebSocketClient.prototype.connect_0 = function (continuation_0, suspended) {
    var instance = new Coroutine$connect_0(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function WebSocketClient$httpClient$lambda($receiver) {
    $receiver.install_xlxg29$(WebSockets.Feature);
    return Unit;
  }
  WebSocketClient.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WebSocketClient',
    interfaces: [RPCClientConnector]
  };
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  var package$org = _.org || (_.org = {});
  var package$brightify = package$org.brightify || (package$org.brightify = {});
  var package$hyperdrive = package$brightify.hyperdrive || (package$brightify.hyperdrive = {});
  var package$krpc = package$hyperdrive.krpc || (package$hyperdrive.krpc = {});
  var package$client = package$krpc.client || (package$krpc.client = {});
  var package$impl = package$client.impl || (package$client.impl = {});
  var package$ktor = package$impl.ktor || (package$impl.ktor = {});
  package$ktor.WebSocketClient = WebSocketClient;
  Kotlin.defineModule('Hyperdrive-krpc-client-impl-ktor-js-legacy', _);
  return _;
}));

//# sourceMappingURL=Hyperdrive-krpc-client-impl-ktor-js-legacy.js.map
