/*
 * Decompiled with CFR 0.152.
 */
package org.brightify.hyperdrive.multiplatformx.property.impl;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.brightify.hyperdrive.multiplatformx.CancellationToken;
import org.brightify.hyperdrive.multiplatformx.property.ObservableProperty;
import org.brightify.hyperdrive.multiplatformx.property.impl.ValueChangeListenerHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B=\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000@RX\u0096\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/brightify/hyperdrive/multiplatformx/property/impl/FilterObservableProperty;", "T", "Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty;", "Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty$Listener;", "filtered", "initialValue", "predicate", "Lkotlin/Function1;", "", "equalityPolicy", "Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty$EqualityPolicy;", "(Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty$EqualityPolicy;)V", "listeners", "Lorg/brightify/hyperdrive/multiplatformx/property/impl/ValueChangeListenerHandler;", "<set-?>", "value", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "addListener", "Lorg/brightify/hyperdrive/multiplatformx/CancellationToken;", "listener", "removeListener", "valueDidChange", "", "oldValue", "newValue", "(Ljava/lang/Object;Ljava/lang/Object;)V", "multiplatformx-api"})
public final class FilterObservableProperty<T>
implements ObservableProperty<T>,
ObservableProperty.Listener<T> {
    @NotNull
    private final ObservableProperty<T> filtered;
    @NotNull
    private final Function1<T, Boolean> predicate;
    @NotNull
    private final ObservableProperty.EqualityPolicy<T> equalityPolicy;
    private T value;
    @NotNull
    private final ValueChangeListenerHandler<T, T> listeners;

    public FilterObservableProperty(@NotNull ObservableProperty<T> filtered, T initialValue, @NotNull Function1<? super T, Boolean> predicate, @NotNull ObservableProperty.EqualityPolicy<T> equalityPolicy) {
        Intrinsics.checkNotNullParameter(filtered, (String)"filtered");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter(equalityPolicy, (String)"equalityPolicy");
        this.filtered = filtered;
        this.predicate = predicate;
        this.equalityPolicy = equalityPolicy;
        this.value = initialValue;
        this.listeners = ValueChangeListenerHandler.Companion.invoke(this);
        this.filtered.addListener(this);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void valueDidChange(T oldValue, T newValue) {
        if (!((Boolean)this.predicate.invoke(newValue)).booleanValue()) {
            return;
        }
        T oldFilteredValue = this.getValue();
        if (this.equalityPolicy.isEqual(oldFilteredValue, newValue)) {
            return;
        }
        this.listeners.runNotifyingListeners(newValue, (Function1)new Function1<T, Unit>(this){
            final /* synthetic */ FilterObservableProperty<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(T it) {
                FilterObservableProperty.access$setValue$p(this.this$0, it);
            }
        });
    }

    @Override
    @NotNull
    public CancellationToken addListener(@NotNull ObservableProperty.Listener<T> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return this.listeners.addListener(listener2);
    }

    @Override
    public boolean removeListener(@NotNull ObservableProperty.Listener<T> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return this.listeners.removeListener(listener2);
    }

    @Override
    public void valueWillChange(T oldValue, T newValue) {
        ObservableProperty.Listener.DefaultImpls.valueWillChange(this, oldValue, newValue);
    }

    public static final /* synthetic */ void access$setValue$p(FilterObservableProperty $this, Object object) {
        $this.value = object;
    }
}

