/*
 * Decompiled with CFR 0.152.
 */
package org.brightify.hyperdrive.multiplatformx.property.impl;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.brightify.hyperdrive.multiplatformx.CancellationToken;
import org.brightify.hyperdrive.multiplatformx.property.DeferredObservableProperty;
import org.brightify.hyperdrive.multiplatformx.property.ObservableProperty;
import org.brightify.hyperdrive.multiplatformx.property.ValueChangeListener;
import org.brightify.hyperdrive.multiplatformx.property.impl.ValueChangeListenerHandler;
import org.brightify.hyperdrive.utils.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B5\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u0011\u0010\u0018\u001a\u00028\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0011\u0010\u001a\u001a\u00028\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J#\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lorg/brightify/hyperdrive/multiplatformx/property/impl/MapDeferredObservableProperty;", "T", "U", "Lorg/brightify/hyperdrive/multiplatformx/property/DeferredObservableProperty;", "Lorg/brightify/hyperdrive/multiplatformx/property/DeferredObservableProperty$Listener;", "mapped", "transform", "Lkotlin/Function1;", "equalityPolicy", "Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty$EqualityPolicy;", "(Lorg/brightify/hyperdrive/multiplatformx/property/DeferredObservableProperty;Lkotlin/jvm/functions/Function1;Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty$EqualityPolicy;)V", "latestValue", "Lorg/brightify/hyperdrive/utils/Optional;", "getLatestValue", "()Lorg/brightify/hyperdrive/utils/Optional;", "setLatestValue", "(Lorg/brightify/hyperdrive/utils/Optional;)V", "listeners", "Lorg/brightify/hyperdrive/multiplatformx/property/impl/ValueChangeListenerHandler;", "valueFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "addListener", "Lorg/brightify/hyperdrive/multiplatformx/CancellationToken;", "listener", "await", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nextValue", "removeListener", "", "valueDidChange", "", "oldValue", "newValue", "(Lorg/brightify/hyperdrive/utils/Optional;Ljava/lang/Object;)V", "multiplatformx-api"})
public final class MapDeferredObservableProperty<T, U>
implements DeferredObservableProperty<U>,
DeferredObservableProperty.Listener<T> {
    @NotNull
    private final DeferredObservableProperty<T> mapped;
    @NotNull
    private final Function1<T, U> transform;
    @NotNull
    private final ObservableProperty.EqualityPolicy<U> equalityPolicy;
    @NotNull
    private final ValueChangeListenerHandler<Optional<U>, U> listeners;
    @NotNull
    private Optional<? extends U> latestValue;
    @NotNull
    private final MutableSharedFlow<U> valueFlow;

    /*
     * WARNING - void declaration
     */
    public MapDeferredObservableProperty(@NotNull DeferredObservableProperty<T> mapped, @NotNull Function1<? super T, ? extends U> transform, @NotNull ObservableProperty.EqualityPolicy<U> equalityPolicy) {
        Optional optional;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(mapped, (String)"mapped");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Intrinsics.checkNotNullParameter(equalityPolicy, (String)"equalityPolicy");
        this.mapped = mapped;
        this.transform = transform;
        this.equalityPolicy = equalityPolicy;
        this.listeners = ValueChangeListenerHandler.Companion.invoke(this);
        Optional<T> optional2 = this.mapped.getLatestValue();
        Function1<T, U> transform$iv = this.transform;
        boolean $i$f$map = false;
        void $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap = false;
        void var9_9 = $this$flatMap$iv$iv;
        if (var9_9 instanceof Optional.Some) {
            Object it$iv = ((Optional.Some)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            optional = (Optional)new Optional.Some(transform$iv.invoke(it$iv));
        } else if (var9_9 instanceof Optional.None) {
            optional = (Optional)Optional.None.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.latestValue = optional;
        this.valueFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.mapped.addListener(this);
    }

    @Override
    @NotNull
    public Optional<U> getLatestValue() {
        return this.latestValue;
    }

    public void setLatestValue(@NotNull Optional<? extends U> optional) {
        Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
        this.latestValue = optional;
    }

    @Override
    @Nullable
    public Object await(@NotNull Continuation<? super U> $completion) {
        Object object;
        Optional<U> $this$someOrDefault$iv = this.getLatestValue();
        boolean $i$f$someOrDefault = false;
        Optional<U> optional = $this$someOrDefault$iv;
        if (optional instanceof Optional.Some) {
            object = ((Optional.Some)$this$someOrDefault$iv).getValue();
        } else if (Intrinsics.areEqual(optional, (Object)Optional.None.INSTANCE)) {
            boolean bl = false;
            object = this.nextValue($completion);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Override
    @Nullable
    public Object nextValue(@NotNull Continuation<? super U> $completion) {
        return FlowKt.first((Flow)((Flow)this.valueFlow), $completion);
    }

    @Override
    public void valueDidChange(@NotNull Optional<? extends T> oldValue, T newValue) {
        Intrinsics.checkNotNullParameter(oldValue, (String)"oldValue");
        Optional<U> currentValue = this.getLatestValue();
        Object newTransformedValue = this.transform.invoke(newValue);
        if (currentValue instanceof Optional.Some && this.equalityPolicy.isEqual(((Optional.Some)currentValue).getValue(), newTransformedValue)) {
            return;
        }
        this.listeners.runNotifyingListeners(newTransformedValue, (Function1)new Function1<U, Boolean>(this){
            final /* synthetic */ MapDeferredObservableProperty<T, U> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(U it) {
                this.this$0.setLatestValue((Optional)new Optional.Some(it));
                return MapDeferredObservableProperty.access$getValueFlow$p(this.this$0).tryEmit(it);
            }
        });
    }

    @Override
    @NotNull
    public CancellationToken addListener(@NotNull DeferredObservableProperty.Listener<U> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return this.listeners.addListener((ValueChangeListener)listener2);
    }

    @Override
    public boolean removeListener(@NotNull DeferredObservableProperty.Listener<U> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return this.listeners.removeListener((ValueChangeListener)listener2);
    }

    @Override
    public void valueWillChange(@NotNull Optional<? extends T> oldValue, T newValue) {
        DeferredObservableProperty.Listener.DefaultImpls.valueWillChange(this, oldValue, newValue);
    }

    public static final /* synthetic */ MutableSharedFlow access$getValueFlow$p(MapDeferredObservableProperty $this) {
        return $this.valueFlow;
    }
}

