/*
 * Decompiled with CFR 0.152.
 */
package org.brightify.hyperdrive.multiplatformx.property.impl;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.brightify.hyperdrive.multiplatformx.CancellationToken;
import org.brightify.hyperdrive.multiplatformx.property.ObservableProperty;
import org.brightify.hyperdrive.multiplatformx.property.ValueChangeListener;
import org.brightify.hyperdrive.multiplatformx.property.impl.ValueChangeListenerHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B5\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u00028\u00012\u0006\u0010\r\u001a\u00028\u0001@RX\u0096\u000e\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/brightify/hyperdrive/multiplatformx/property/impl/MapObservableProperty;", "T", "U", "Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty;", "Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty$Listener;", "mapped", "transform", "Lkotlin/Function1;", "equalityPolicy", "Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty$EqualityPolicy;", "(Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty;Lkotlin/jvm/functions/Function1;Lorg/brightify/hyperdrive/multiplatformx/property/ObservableProperty$EqualityPolicy;)V", "listeners", "Lorg/brightify/hyperdrive/multiplatformx/property/impl/ValueChangeListenerHandler;", "<set-?>", "value", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "addListener", "Lorg/brightify/hyperdrive/multiplatformx/CancellationToken;", "listener", "removeListener", "", "valueDidChange", "", "oldValue", "newValue", "(Ljava/lang/Object;Ljava/lang/Object;)V", "multiplatformx-api"})
public final class MapObservableProperty<T, U>
implements ObservableProperty<U>,
ObservableProperty.Listener<T> {
    @NotNull
    private final ObservableProperty<T> mapped;
    @NotNull
    private final Function1<T, U> transform;
    @NotNull
    private final ObservableProperty.EqualityPolicy<U> equalityPolicy;
    private U value;
    @NotNull
    private final ValueChangeListenerHandler<U, U> listeners;

    public MapObservableProperty(@NotNull ObservableProperty<T> mapped, @NotNull Function1<? super T, ? extends U> transform, @NotNull ObservableProperty.EqualityPolicy<U> equalityPolicy) {
        Intrinsics.checkNotNullParameter(mapped, (String)"mapped");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Intrinsics.checkNotNullParameter(equalityPolicy, (String)"equalityPolicy");
        this.mapped = mapped;
        this.transform = transform;
        this.equalityPolicy = equalityPolicy;
        this.value = this.transform.invoke(this.mapped.getValue());
        this.listeners = ValueChangeListenerHandler.Companion.invoke(this);
        this.mapped.addListener(this);
    }

    @Override
    public U getValue() {
        return this.value;
    }

    @Override
    public void valueDidChange(T oldValue, T newValue) {
        Object newTransformedValue = this.transform.invoke(newValue);
        if (this.equalityPolicy.isEqual(this.getValue(), newTransformedValue)) {
            return;
        }
        this.listeners.runNotifyingListeners(newTransformedValue, (Function1)new Function1<U, Unit>(this){
            final /* synthetic */ MapObservableProperty<T, U> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(U it) {
                MapObservableProperty.access$setValue$p(this.this$0, it);
            }
        });
    }

    @Override
    @NotNull
    public CancellationToken addListener(@NotNull ObservableProperty.Listener<U> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return this.listeners.addListener((ValueChangeListener)listener2);
    }

    @Override
    public boolean removeListener(@NotNull ObservableProperty.Listener<U> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return this.listeners.removeListener((ValueChangeListener)listener2);
    }

    @Override
    public void valueWillChange(T oldValue, T newValue) {
        ObservableProperty.Listener.DefaultImpls.valueWillChange(this, oldValue, newValue);
    }

    public static final /* synthetic */ void access$setValue$p(MapObservableProperty $this, Object object) {
        $this.value = object;
    }
}

