/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.service.PaymentInfoService;
import org.broadleafcommerce.core.payment.service.SecurePaymentInfoService;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.web.checkout.model.CheckoutForm;
import org.broadleafcommerce.core.web.checkout.validator.CheckoutFormValidator;
import org.broadleafcommerce.openadmin.time.SystemTime;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerPhoneImpl;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.CustomerAddressService;
import org.broadleafcommerce.profile.core.service.CustomerPhoneService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller(value="blCheckoutController")
@RequestMapping(value={"/checkout"})
public class CheckoutController {
    private static final Log LOG = LogFactory.getLog(CheckoutController.class);
    @Resource(name="blCartService")
    protected CartService cartService;
    @Resource(name="blCustomerState")
    protected CustomerState customerState;
    @Resource(name="blCustomerAddressService")
    protected CustomerAddressService customerAddressService;
    @Resource(name="blCustomerPhoneService")
    protected CustomerPhoneService customerPhoneService;
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blStateService")
    protected StateService stateService;
    @Resource(name="blCountryService")
    protected CountryService countryService;
    @Resource(name="blPaymentInfoService")
    protected PaymentInfoService paymentInfoService;
    @Resource(name="blSecurePaymentInfoService")
    protected SecurePaymentInfoService securePaymentInfoService;
    @Resource(name="blCheckoutFormValidator")
    protected CheckoutFormValidator checkoutFormValidator;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    protected String checkoutView;
    protected String receiptView;

    public void setReceiptView(String receiptView) {
        this.receiptView = receiptView;
    }

    public void setCheckoutView(String checkoutView) {
        this.checkoutView = checkoutView;
    }

    private CheckoutForm copyAddress(CheckoutForm checkoutForm) {
        checkoutForm.getShippingAddress().setFirstName(checkoutForm.getBillingAddress().getFirstName());
        checkoutForm.getShippingAddress().setLastName(checkoutForm.getBillingAddress().getLastName());
        checkoutForm.getShippingAddress().setAddressLine1(checkoutForm.getBillingAddress().getAddressLine1());
        checkoutForm.getShippingAddress().setAddressLine2(checkoutForm.getBillingAddress().getAddressLine2());
        checkoutForm.getShippingAddress().setCity(checkoutForm.getBillingAddress().getCity());
        checkoutForm.getShippingAddress().setState(checkoutForm.getBillingAddress().getState());
        checkoutForm.getShippingAddress().setPostalCode(checkoutForm.getBillingAddress().getPostalCode());
        checkoutForm.getShippingAddress().setCountry(checkoutForm.getBillingAddress().getCountry());
        checkoutForm.getShippingAddress().setPrimaryPhone(checkoutForm.getBillingAddress().getPrimaryPhone());
        return checkoutForm;
    }

    @RequestMapping(value={"/checkout.htm"}, method={RequestMethod.POST})
    public String processCheckout(@ModelAttribute CheckoutForm checkoutForm, BindingResult errors, ModelMap model, HttpServletRequest request) {
        if (checkoutForm.getIsSameAddress()) {
            this.copyAddress(checkoutForm);
        }
        this.checkoutFormValidator.validate(checkoutForm, (Errors)errors);
        if (errors.hasErrors()) {
            return this.checkout(checkoutForm, errors, model, request);
        }
        checkoutForm.getBillingAddress().setCountry(this.countryService.findCountryByAbbreviation(checkoutForm.getBillingAddress().getCountry().getAbbreviation()));
        checkoutForm.getBillingAddress().setState(this.stateService.findStateByAbbreviation(checkoutForm.getBillingAddress().getState().getAbbreviation()));
        checkoutForm.getShippingAddress().setCountry(this.countryService.findCountryByAbbreviation(checkoutForm.getShippingAddress().getCountry().getAbbreviation()));
        checkoutForm.getShippingAddress().setState(this.stateService.findStateByAbbreviation(checkoutForm.getShippingAddress().getState().getAbbreviation()));
        Order order = this.retrieveCartOrder(request, model);
        order.setOrderNumber(new SimpleDateFormat("yyyyMMddHHmmssS").format(SystemTime.asDate()));
        List groups = order.getFulfillmentGroups();
        if (groups.size() < 1) {
            return "redirect:/basket/currentCart.htm";
        }
        FulfillmentGroup group = (FulfillmentGroup)groups.get(0);
        group.setOrder(order);
        group.setAddress(checkoutForm.getShippingAddress());
        group.setShippingPrice(order.getTotalShipping());
        HashMap<PaymentInfo, CreditCardPaymentInfo> payments = new HashMap<PaymentInfo, CreditCardPaymentInfo>();
        CreditCardPaymentInfo creditCardPaymentInfo = (CreditCardPaymentInfo)this.securePaymentInfoService.create(PaymentInfoType.CREDIT_CARD);
        creditCardPaymentInfo.setCvvCode(checkoutForm.getCreditCardCvvCode());
        creditCardPaymentInfo.setExpirationMonth(Integer.valueOf(Integer.parseInt(checkoutForm.getCreditCardExpMonth())));
        creditCardPaymentInfo.setExpirationYear(Integer.valueOf(Integer.parseInt(checkoutForm.getCreditCardExpYear())));
        creditCardPaymentInfo.setPan(checkoutForm.getCreditCardNumber());
        creditCardPaymentInfo.setReferenceNumber(checkoutForm.getCreditCardNumber());
        PaymentInfo paymentInfo = this.paymentInfoService.create();
        paymentInfo.setAddress(checkoutForm.getBillingAddress());
        paymentInfo.setOrder(order);
        paymentInfo.setType(PaymentInfoType.CREDIT_CARD);
        paymentInfo.setReferenceNumber(checkoutForm.getCreditCardNumber());
        paymentInfo.setAmount(order.getTotal());
        payments.put(paymentInfo, creditCardPaymentInfo);
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>();
        paymentInfos.add(paymentInfo);
        order.setPaymentInfos(paymentInfos);
        order.setStatus(OrderStatus.SUBMITTED);
        order.setSubmitDate(Calendar.getInstance().getTime());
        try {
            this.checkoutService.performCheckout(order, payments);
        }
        catch (CheckoutException e) {
            LOG.error((Object)"Cannot perform checkout", (Throwable)e);
        }
        Customer customer = order.getCustomer();
        if (StringUtils.isEmpty((String)customer.getFirstName())) {
            customer.setFirstName(checkoutForm.getBillingAddress().getFirstName());
        }
        if (StringUtils.isEmpty((String)customer.getLastName())) {
            customer.setLastName(checkoutForm.getBillingAddress().getLastName());
        }
        if (StringUtils.isEmpty((String)customer.getEmailAddress())) {
            customer.setEmailAddress(order.getEmailAddress());
        }
        this.customerService.saveCustomer(customer, false);
        return this.receiptView != null ? "redirect:" + this.receiptView : "redirect:/orders/viewOrderConfirmation.htm?orderNumber=" + order.getOrderNumber();
    }

    @RequestMapping(value={"/checkout.htm"}, method={RequestMethod.GET})
    public String checkout(@ModelAttribute CheckoutForm checkoutForm, BindingResult errors, ModelMap model, HttpServletRequest request) {
        model.addAttribute("stateList", (Object)this.stateService.findStates());
        List countries = this.countryService.findCountries();
        Collections.sort(countries, new ReverseComparator((Comparator)new BeanComparator("abbreviation")));
        model.addAttribute("countryList", (Object)countries);
        Customer currentCustomer = this.customerState.getCustomer(request);
        model.addAttribute("customer", (Object)currentCustomer);
        List customerPhones = this.customerPhoneService.readAllCustomerPhonesByCustomerId(currentCustomer.getId());
        while (customerPhones.size() < 2) {
            customerPhones.add(new CustomerPhoneImpl());
        }
        this.customerAddressService.readActiveCustomerAddressesByCustomerId(currentCustomer.getId());
        model.addAttribute("order", (Object)this.retrieveCartOrder(request, model));
        return this.checkoutView;
    }

    protected Order retrieveCartOrder(HttpServletRequest request, ModelMap model) {
        Customer currentCustomer = this.customerState.getCustomer(request);
        Order currentCartOrder = null;
        if (currentCustomer != null && (currentCartOrder = this.cartService.findCartForCustomer(currentCustomer)) == null) {
            currentCartOrder = this.cartService.createNewCartForCustomer(currentCustomer);
        }
        return currentCartOrder;
    }
}

