/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.web.security;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.web.controller.BroadleafControllerUtility;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.stereotype.Component;

@Component(value="blAuthenticationSuccessRedirectStrategy")
public class BroadleafAuthenticationSuccessRedirectStrategy
implements RedirectStrategy {
    private String redirectPath = "/redirect";
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        if (BroadleafControllerUtility.isAjaxRequest((HttpServletRequest)request)) {
            request.getSession().setAttribute("BLC_REDIRECT_URL", (Object)url);
            url = this.getRedirectPath();
        }
        this.redirectStrategy.sendRedirect(request, response, url);
    }

    public String updateLoginErrorUrlForAjax(String url) {
        String blcAjax = "blcAjax";
        url = url != null && url.indexOf("?") > 0 ? url + "&" + blcAjax + "=true" : url + "?" + blcAjax + "=true";
        return url;
    }

    public String getRedirectPath() {
        return this.redirectPath;
    }

    public void setRedirectPath(String redirectPath) {
        this.redirectPath = redirectPath;
    }

    public RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }
}

