/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.order;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.api.wrapper.FulfillmentGroupItemWrapper;
import org.broadleafcommerce.core.web.api.wrapper.FulfillmentGroupWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="blRestFulfillmentEndpoint")
@Scope(value="singleton")
@Path(value="/cart/fulfillment/")
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
public class FulfillmentEndpoint
implements ApplicationContextAware {
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    protected ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @GET
    @Path(value="groups")
    public List<FulfillmentGroupWrapper> findFulfillmentGroupsForOrder(@Context HttpServletRequest request) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null && cart.getFulfillmentGroups() != null && !cart.getFulfillmentGroups().isEmpty()) {
                List fulfillmentGroups = cart.getFulfillmentGroups();
                ArrayList<FulfillmentGroupWrapper> fulfillmentGroupWrappers = new ArrayList<FulfillmentGroupWrapper>();
                for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
                    FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                    fulfillmentGroupWrapper.wrap(fulfillmentGroup, request);
                    fulfillmentGroupWrappers.add(fulfillmentGroupWrapper);
                }
                return fulfillmentGroupWrappers;
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @DELETE
    @Path(value="groups")
    public OrderWrapper removeAllFulfillmentGroupsFromOrder(@Context HttpServletRequest request, @QueryParam(value="priceOrder") @DefaultValue(value="true") boolean priceOrder) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null) {
                try {
                    this.fulfillmentGroupService.removeAllFulfillmentGroupsFromOrder(cart, priceOrder);
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrap(cart, request);
                    return wrapper;
                }
                catch (PricingException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @POST
    @Path(value="group")
    public FulfillmentGroupWrapper addFulfillmentGroupToOrder(@Context HttpServletRequest request, FulfillmentGroupWrapper wrapper, @QueryParam(value="priceOrder") @DefaultValue(value="true") boolean priceOrder) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            FulfillmentGroupRequest fulfillmentGroupRequest;
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null && (fulfillmentGroupRequest = wrapper.unwrap(request, this.context)).getOrder() != null && fulfillmentGroupRequest.getOrder().getId().equals(cart.getId())) {
                try {
                    fulfillmentGroupRequest.setOrder(cart);
                    FulfillmentGroup fulfillmentGroup = this.fulfillmentGroupService.addFulfillmentGroupToOrder(fulfillmentGroupRequest, priceOrder);
                    FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                    fulfillmentGroupWrapper.wrap(fulfillmentGroup, request);
                    return fulfillmentGroupWrapper;
                }
                catch (PricingException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @PUT
    @Path(value="group/{fulfillmentGroupId}")
    public FulfillmentGroupWrapper addItemToFulfillmentGroup(@Context HttpServletRequest request, @PathParam(value="fulfillmentGroupId") Long fulfillmentGroupId, FulfillmentGroupItemWrapper wrapper, @QueryParam(value="priceOrder") @DefaultValue(value="true") boolean priceOrder) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            FulfillmentGroupItemRequest fulfillmentGroupItemRequest;
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null && (fulfillmentGroupItemRequest = wrapper.unwrap(request, this.context)).getOrderItem() != null) {
                FulfillmentGroup fulfillmentGroup = null;
                OrderItem orderItem = null;
                for (FulfillmentGroup fg : cart.getFulfillmentGroups()) {
                    if (!fg.getId().equals(fulfillmentGroupId)) continue;
                    fulfillmentGroup = fg;
                }
                fulfillmentGroupItemRequest.setFulfillmentGroup(fulfillmentGroup);
                for (OrderItem oi : cart.getOrderItems()) {
                    if (!oi.getId().equals(fulfillmentGroupItemRequest.getOrderItem().getId())) continue;
                    orderItem = oi;
                }
                fulfillmentGroupItemRequest.setOrderItem(orderItem);
                if (fulfillmentGroup != null && orderItem != null) {
                    try {
                        FulfillmentGroup fg = this.fulfillmentGroupService.addItemToFulfillmentGroup(fulfillmentGroupItemRequest, priceOrder);
                        FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                        fulfillmentGroupWrapper.wrap(fg, request);
                        return fulfillmentGroupWrapper;
                    }
                    catch (PricingException e) {
                        throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }
}

