/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductBundleWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductWrapper;

@XmlRootElement(name="category")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CategoryWrapper
extends BaseWrapper
implements APIWrapper<Category> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String name;
    @XmlElement
    protected String description;
    @XmlElement
    protected String url;
    @XmlElement
    protected String urlKey;
    @XmlElement
    protected Date activeStartDate;
    @XmlElement
    protected Date activeEndDate;
    @XmlElement(name="category")
    @XmlElementWrapper(name="subcategories")
    List<CategoryWrapper> subcategories;
    @XmlElement(name="product")
    @XmlElementWrapper(name="products")
    List<ProductWrapper> products;

    @Override
    public void wrap(Category category, HttpServletRequest request) {
        Integer subcategoryDepth = (Integer)request.getAttribute("subcategoryDepth");
        this.wrap(category, subcategoryDepth, request);
    }

    private void wrap(Category category, Integer depth, HttpServletRequest request) {
        this.id = category.getId();
        this.name = category.getName();
        this.description = category.getDescription();
        this.activeStartDate = category.getActiveStartDate();
        this.activeEndDate = category.getActiveEndDate();
        this.url = category.getUrl();
        this.urlKey = category.getUrlKey();
        Integer productLimit = (Integer)request.getAttribute("productLimit");
        Integer productOffset = (Integer)request.getAttribute("productOffset");
        Integer subcategoryLimit = (Integer)request.getAttribute("subcategoryLimit");
        Integer subcategoryOffset = (Integer)request.getAttribute("subcategoryOffset");
        if (productLimit != null && productOffset != null && subcategoryLimit != null && subcategoryOffset != null && depth != null) {
            CatalogService catalogService = (CatalogService)this.context.getBean("blCatalogService");
            List productList = catalogService.findProductsForCategory(category, productLimit.intValue(), productOffset.intValue());
            if (productList != null && !productList.isEmpty()) {
                if (this.products == null) {
                    this.products = new ArrayList<ProductWrapper>();
                }
                for (Product p : productList) {
                    ProductWrapper productWrapper = p instanceof ProductBundle ? (ProductWrapper)this.context.getBean(ProductBundleWrapper.class.getName()) : (ProductWrapper)this.context.getBean(ProductWrapper.class.getName());
                    productWrapper.wrap(p, request);
                    this.products.add(productWrapper);
                }
            }
            this.subcategories = this.buildSubcategoryTree(this.subcategories, category, request, depth);
        }
    }

    protected List<CategoryWrapper> buildSubcategoryTree(List<CategoryWrapper> wrappers, Category root, HttpServletRequest request, int depth) {
        CatalogService catalogService = (CatalogService)this.context.getBean("blCatalogService");
        if (depth <= 0) {
            return wrappers;
        }
        Integer subcategoryLimit = (Integer)request.getAttribute("subcategoryLimit");
        Integer subcategoryOffset = (Integer)request.getAttribute("subcategoryOffset");
        List subcategories = catalogService.findAllSubCategories(root, subcategoryLimit.intValue(), subcategoryOffset.intValue());
        if (subcategories != null && !subcategories.isEmpty() && wrappers == null) {
            wrappers = new ArrayList<CategoryWrapper>();
        }
        for (Category c : subcategories) {
            CategoryWrapper subcategoryWrapper = (CategoryWrapper)this.context.getBean(CategoryWrapper.class.getName());
            subcategoryWrapper.wrap(c, depth - 1, request);
            wrappers.add(subcategoryWrapper);
        }
        return wrappers;
    }
}

