/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductOptionValueWrapper;

@XmlRootElement(name="productOption")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProductOptionWrapper
extends BaseWrapper
implements APIWrapper<ProductOption> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String attributeName;
    @XmlElement
    protected String label;
    @XmlElement
    protected Boolean required;
    @XmlElement
    protected String productOptionType;
    @XmlElement(name="allowedValue")
    @XmlElementWrapper(name="allowedValues")
    protected List<ProductOptionValueWrapper> allowedValues;

    @Override
    public void wrap(ProductOption model, HttpServletRequest request) {
        List optionValues;
        this.id = model.getId();
        this.attributeName = model.getAttributeName();
        this.label = model.getLabel();
        this.required = model.getRequired();
        if (model.getType() != null) {
            this.productOptionType = model.getType().getType();
        }
        if ((optionValues = model.getAllowedValues()) != null) {
            ArrayList<ProductOptionValueWrapper> allowedValueWrappers = new ArrayList<ProductOptionValueWrapper>();
            for (ProductOptionValue value : optionValues) {
                ProductOptionValueWrapper optionValueWrapper = (ProductOptionValueWrapper)this.context.getBean(ProductOptionValueWrapper.class.getName());
                optionValueWrapper.wrap(value, request);
                allowedValueWrappers.add(optionValueWrapper);
            }
            this.allowedValues = allowedValueWrappers;
        }
    }
}

