/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.checkout.validator;

import org.broadleafcommerce.core.web.checkout.model.BillingInfoForm;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component(value="blBillingInfoFormValidator")
public class BillingInfoFormValidator
implements Validator {
    public boolean supports(Class clazz) {
        return clazz.equals(BillingInfoForm.class);
    }

    public void validate(Object obj, Errors errors) {
        BillingInfoForm billingInfoForm = (BillingInfoForm)obj;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.firstName", (String)"firstName.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.lastName", (String)"lastName.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.addressLine1", (String)"addressLine1.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.city", (String)"city.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"address.postalCode", (String)"postalCode.required");
        if (billingInfoForm.getAddress().getCountry() == null) {
            errors.rejectValue("address.country", "country.required", null, null);
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"creditCardName", (String)"creditCardName.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"creditCardNumber", (String)"creditCardNumber.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"creditCardCvvCode", (String)"creditCardCvvCode.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"creditCardExpMonth", (String)"creditCardExpMonth.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"creditCardExpYear", (String)"creditCardExpYear.required");
    }
}

