/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.security.MergeCartProcessor;
import org.broadleafcommerce.common.service.GenericResponse;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.core.web.controller.account.ResetPasswordForm;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.validator.ResetPasswordValidator;
import org.broadleafcommerce.profile.web.core.service.LoginService;
import org.springframework.security.core.Authentication;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

public class BroadleafLoginController
extends BroadleafAbstractController {
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blResetPasswordValidator")
    protected ResetPasswordValidator resetPasswordValidator;
    @Resource(name="blLoginService")
    protected LoginService loginService;
    @Resource(name="blMergeCartProcessor")
    protected MergeCartProcessor mergeCartProcessor;
    protected static String loginView = "authentication/login";
    protected static String forgotPasswordView = "authentication/forgotPassword";
    protected static String forgotUsernameView = "authentication/forgotUsername";
    protected static String forgotPasswordSuccessView = "authentication/forgotPasswordSuccess";
    protected static String resetPasswordView = "authentication/resetPassword";
    protected static String resetPasswordErrorView = "authentication/resetPasswordError";
    protected static String resetPasswordSuccessView = "redirect:/";
    protected static String resetPasswordFormView = "authentication/resetPasswordForm";

    public String login(HttpServletRequest request, HttpServletResponse response, Model model) {
        if (StringUtils.isNotBlank((String)request.getParameter("successUrl"))) {
            model.addAttribute("successUrl", (Object)request.getParameter("successUrl"));
        }
        return this.getLoginView();
    }

    public String forgotPassword(HttpServletRequest request, HttpServletResponse response, Model model) {
        return this.getForgotPasswordView();
    }

    public String processForgotPassword(String username, HttpServletRequest request, Model model) {
        GenericResponse errorResponse = this.customerService.sendForgotPasswordNotification(username, this.getResetPasswordUrl(request));
        if (errorResponse.getHasErrors()) {
            String errorCode = (String)errorResponse.getErrorCodesList().get(0);
            model.addAttribute("errorCode", (Object)errorCode);
            return this.getForgotPasswordView();
        }
        request.getSession(true).setAttribute("forgot_password_username", (Object)username);
        return this.getForgotPasswordSuccessView();
    }

    public String forgotUsername(HttpServletRequest request, HttpServletResponse response, Model model) {
        return this.getForgotUsernameView();
    }

    public String processForgotUsername(String email, HttpServletRequest request, HttpServletResponse response, Model model) {
        GenericResponse errorResponse = this.customerService.sendForgotUsernameNotification(email);
        if (errorResponse.getHasErrors()) {
            String errorCode = (String)errorResponse.getErrorCodesList().get(0);
            request.setAttribute("errorCode", (Object)errorCode);
            return this.getForgotUsernameView();
        }
        return this.buildRedirectToLoginWithMessage("usernameSent");
    }

    public String resetPassword(HttpServletRequest request, HttpServletResponse response, Model model) {
        ResetPasswordForm resetPasswordForm = this.initResetPasswordForm(request);
        model.addAttribute("resetPasswordForm", (Object)resetPasswordForm);
        GenericResponse errorResponse = this.customerService.checkPasswordResetToken(resetPasswordForm.getToken());
        if (errorResponse.getHasErrors()) {
            String errorCode = (String)errorResponse.getErrorCodesList().get(0);
            request.setAttribute("errorCode", (Object)errorCode);
            return this.getResetPasswordErrorView();
        }
        return this.getResetPasswordView();
    }

    public String processResetPassword(ResetPasswordForm resetPasswordForm, HttpServletRequest request, HttpServletResponse response, Model model, BindingResult errors) throws ServiceException {
        GenericResponse errorResponse = new GenericResponse();
        this.resetPasswordValidator.validate(resetPasswordForm.getUsername(), resetPasswordForm.getPassword(), resetPasswordForm.getPasswordConfirm(), (Errors)errors);
        if (errorResponse.getHasErrors()) {
            return this.getResetPasswordView();
        }
        errorResponse = this.customerService.resetPasswordUsingToken(resetPasswordForm.getUsername(), resetPasswordForm.getToken(), resetPasswordForm.getPassword(), resetPasswordForm.getPasswordConfirm());
        if (errorResponse.getHasErrors()) {
            String errorCode = (String)errorResponse.getErrorCodesList().get(0);
            request.setAttribute("errorCode", (Object)errorCode);
            return this.getResetPasswordView();
        }
        Authentication auth = this.loginService.loginCustomer(resetPasswordForm.getUsername(), resetPasswordForm.getPassword());
        this.mergeCartProcessor.execute(request, response, auth);
        return this.getResetPasswordSuccessView();
    }

    protected String buildRedirectToLoginWithMessage(String message) {
        StringBuffer url = new StringBuffer("redirect:").append(this.getLoginView()).append("?messageCode=").append(message);
        return url.toString();
    }

    public ResetPasswordForm initResetPasswordForm(HttpServletRequest request) {
        ResetPasswordForm resetPasswordForm = new ResetPasswordForm();
        String username = (String)request.getSession(true).getAttribute("forgot_password_username");
        String token = request.getParameter("token");
        resetPasswordForm.setToken(token);
        resetPasswordForm.setUsername(username);
        return resetPasswordForm;
    }

    public String getLoginView() {
        return loginView;
    }

    public String getForgotUsernameView() {
        return forgotUsernameView;
    }

    public String getForgotPasswordView() {
        return forgotPasswordView;
    }

    public String getResetPasswordView() {
        return resetPasswordView;
    }

    public String getForgotPasswordSuccessView() {
        return forgotPasswordSuccessView;
    }

    public String getResetPasswordFormView() {
        return resetPasswordFormView;
    }

    public String getResetPasswordScheme(HttpServletRequest request) {
        return request.getScheme();
    }

    public String getResetPasswordPort(HttpServletRequest request, String scheme) {
        if ("http".equalsIgnoreCase(scheme) && request.getServerPort() != 80) {
            return ":" + request.getServerPort();
        }
        if ("https".equalsIgnoreCase(scheme) && request.getServerPort() != 443) {
            return ":" + request.getServerPort();
        }
        return "";
    }

    public String getResetPasswordUrl(HttpServletRequest request) {
        String url = request.getScheme() + "://" + request.getServerName() + this.getResetPasswordPort(request, request.getScheme() + "/");
        url = request.getContextPath() != null && !"".equals(request.getContextPath()) ? url + request.getContextPath() + this.getResetPasswordView() : url + this.getResetPasswordView();
        return url;
    }

    public String getResetPasswordErrorView() {
        return resetPasswordErrorView;
    }

    public String getResetPasswordSuccessView() {
        return resetPasswordSuccessView;
    }
}

