/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.web.controller.account.AbstractAccountController;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.ui.Model;

public class BroadleafOrderHistoryController
extends AbstractAccountController {
    protected static String orderHistoryView = "account/orderHistory";
    protected static String orderDetailsView = "account/partials/orderDetails";
    protected static String orderDetailsRedirectView = "account/partials/orderDetails";

    public String viewOrderHistory(HttpServletRequest request, Model model) {
        List orders = this.orderService.findOrdersForCustomer(CustomerState.getCustomer(), OrderStatus.SUBMITTED);
        model.addAttribute("orders", (Object)orders);
        return BroadleafOrderHistoryController.getOrderHistoryView();
    }

    public String viewOrderDetails(HttpServletRequest request, Model model, String orderNumber) {
        Order order = this.orderService.findOrderByOrderNumber(orderNumber);
        if (order == null) {
            throw new IllegalArgumentException("The orderNumber provided is not valid");
        }
        model.addAttribute("order", (Object)order);
        return this.isAjaxRequest(request) ? BroadleafOrderHistoryController.getOrderDetailsView() : BroadleafOrderHistoryController.getOrderDetailsRedirectView();
    }

    public static String getOrderHistoryView() {
        return orderHistoryView;
    }

    public static void setOrderHistoryView(String orderHistoryView) {
        BroadleafOrderHistoryController.orderHistoryView = orderHistoryView;
    }

    public static String getOrderDetailsView() {
        return orderDetailsView;
    }

    public static void setOrderDetailsView(String orderDetailsView) {
        BroadleafOrderHistoryController.orderDetailsView = orderDetailsView;
    }

    public static String getOrderDetailsRedirectView() {
        return orderDetailsRedirectView;
    }

    public static void setOrderDetailsRedirectView(String orderDetailsRedirectView) {
        BroadleafOrderHistoryController.orderDetailsRedirectView = orderDetailsRedirectView;
    }
}

