/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.web.util.ProcessorUtils;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;

@Component(value="blAddSortLinkProcessor")
public class AddSortLinkProcessor
extends AbstractAttributeModifierAttrProcessor {
    protected boolean allowMultipleSorts = false;

    public AddSortLinkProcessor() {
        super("addsortlink");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        BroadleafRequestContext blcContext = BroadleafRequestContext.getBroadleafRequestContext();
        HttpServletRequest request = blcContext.getRequest();
        String baseUrl = request.getRequestURL().toString();
        HashMap<String, String[]> params = new HashMap<String, String[]>(request.getParameterMap());
        String key = ProductSearchCriteria.SORT_STRING;
        String sortField = element.getAttributeValue(attributeName);
        ArrayList<String[]> sortedFields = new ArrayList<String[]>();
        String[] paramValues = (String[])params.get(key);
        if (paramValues != null && paramValues.length > 0) {
            String sortQueries = paramValues[0];
            for (String sortQuery : sortQueries.split(",")) {
                String[] sort = sortQuery.split(" ");
                if (sort.length != 2) continue;
                sortedFields.add(new String[]{sort[0], sort[1]});
            }
        }
        boolean currentlySortingOnThisField = false;
        boolean currentlyAscendingOnThisField = false;
        for (String[] sortedField : sortedFields) {
            if (!sortField.equals(sortedField[0])) continue;
            currentlySortingOnThisField = true;
            currentlyAscendingOnThisField = sortedField[1].equals("asc");
            sortedField[1] = currentlyAscendingOnThisField ? "desc" : "asc";
        }
        String sortString = sortField;
        String classString = "";
        if (currentlySortingOnThisField) {
            classString = classString + "active ";
            if (currentlyAscendingOnThisField) {
                sortString = sortString + " desc";
                classString = classString + "asc ";
            } else {
                sortString = sortString + " asc";
                classString = classString + "desc ";
            }
        } else {
            sortString = sortString + " asc";
            classString = classString + "asc ";
            params.remove(ProductSearchCriteria.PAGE_NUMBER);
        }
        if (this.allowMultipleSorts) {
            StringBuilder sortSb = new StringBuilder();
            for (String[] sortedField : sortedFields) {
                sortSb.append(sortedField[0]).append(" ").append(sortedField[1]).append(",");
            }
            sortString = sortSb.toString();
            if (sortString.charAt(sortString.length() - 1) == ',') {
                sortString = sortString.substring(0, sortString.length() - 1);
            }
        }
        params.put(key, new String[]{sortString});
        String url = ProcessorUtils.getUrl(baseUrl, params);
        attrs.put("class", classString);
        attrs.put("href", url);
        return attrs;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

