/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.broadleafcommerce.common.web.dialect.AbstractModelVariableModifierProcessor;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.profile.core.domain.Address;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;

@Component(value="blGoogleAnalyticsProcessor")
public class GoogleAnalyticsProcessor
extends AbstractModelVariableModifierProcessor {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Value(value="${googleAnalytics.webPropertyId}")
    protected String webPropertyId;
    @Value(value="${googleAnalytics.affiliation}")
    protected String affiliation = "";
    protected boolean testLocal = false;

    public GoogleAnalyticsProcessor() {
        super("googleanalytics");
    }

    public int getPrecedence() {
        return 100000;
    }

    protected void modifyModelAttributes(Arguments arguments, Element element) {
        String orderNumber = element.getAttributeValue("orderNumber");
        Order order = null;
        if (orderNumber != null) {
            order = this.orderService.findOrderByOrderNumber(orderNumber);
        }
        this.addToModel(arguments, "analytics", this.analytics(this.webPropertyId, order));
    }

    protected String analytics(String webPropertyId, Order order) {
        StringBuffer sb = new StringBuffer();
        sb.append("var _gaq = _gaq || [];\n");
        sb.append("_gaq.push(['_setAccount', '" + webPropertyId + "']);");
        sb.append("_gaq.push(['_trackPageview']);");
        if (this.testLocal) {
            sb.append("_gaq.push(['_setDomainName', '127.0.0.1']);");
        }
        if (order != null) {
            Address paymentAddress = this.getBillingAddress(order);
            if (paymentAddress != null) {
                sb.append("_gaq.push(['_addTrans','" + order.getOrderNumber() + "'");
                sb.append(",'" + this.affiliation + "'");
                sb.append(",'" + order.getTotal() + "'");
                sb.append(",'" + order.getTotalTax() + "'");
                sb.append(",'" + order.getTotalShipping() + "'");
                sb.append(",'" + paymentAddress.getCity() + "'");
                sb.append(",'" + paymentAddress.getState().getName() + "'");
                sb.append(",'" + paymentAddress.getCountry().getName() + "'");
                sb.append("]);");
            }
            for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                for (FulfillmentGroupItem fulfillmentGroupItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                    OrderItem orderItem = fulfillmentGroupItem.getOrderItem();
                    Sku sku = null;
                    if (orderItem instanceof DiscreteOrderItem) {
                        sku = ((DiscreteOrderItem)orderItem).getSku();
                    } else if (orderItem instanceof BundleOrderItem) {
                        sku = ((BundleOrderItem)orderItem).getSku();
                    }
                    sb.append("_gaq.push(['_addItem','" + order.getOrderNumber() + "'");
                    sb.append(",'" + sku.getId() + "'");
                    sb.append(",'" + sku.getName() + "'");
                    sb.append(",'" + this.getVariation(orderItem) + "'");
                    sb.append(",'" + orderItem.getPrice() + "'");
                    sb.append(",'" + orderItem.getQuantity() + "'");
                    sb.append("]);");
                }
            }
            sb.append("_gaq.push(['_trackTrans']);");
        }
        sb.append(" (function() {var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);})();");
        return sb.toString();
    }

    protected String getVariation(OrderItem item) {
        if (MapUtils.isEmpty((Map)item.getOrderItemAttributes())) {
            return item.getCategory() == null ? "" : item.getCategory().getName();
        }
        String result = "";
        for (Map.Entry entry : item.getOrderItemAttributes().entrySet()) {
            result = result + ((OrderItemAttribute)entry.getValue()).getValue() + " ";
        }
        return result.substring(0, result.length() - 1);
    }

    protected Address getBillingAddress(Order order) {
        PaymentInfo paymentInfo = null;
        if (order.getPaymentInfos().size() > 0) {
            paymentInfo = (PaymentInfo)order.getPaymentInfos().get(0);
        }
        Address address = null;
        address = paymentInfo == null || paymentInfo.getAddress() == null ? ((FulfillmentGroup)order.getFulfillmentGroups().get(0)).getAddress() : paymentInfo.getAddress();
        return address;
    }

    protected void setTestLocal(boolean testLocal) {
        this.testLocal = testLocal;
    }

    public boolean getTestLocal() {
        return this.testLocal;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }
}

