/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.web.api.BroadleafWebServicesException;
import org.broadleafcommerce.core.web.api.wrapper.ErrorMessageWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ErrorWrapper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.annotation.Scope;

@Scope(value="singleton")
@Provider
public class BroadleafRestExceptionMapper
implements ExceptionMapper<Throwable>,
MessageSourceAware,
ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(BroadleafRestExceptionMapper.class);
    protected String messageKeyPrefix = BroadleafWebServicesException.class.getName() + '.';
    @Context
    protected HttpHeaders headers;
    protected MessageSource messageSource;
    protected ApplicationContext context;

    public Response toResponse(Throwable t) {
        MediaType mediaType = this.resolveResponseMediaType(t);
        ErrorWrapper errorWrapper = (ErrorWrapper)this.context.getBean(ErrorWrapper.class.getName());
        Locale locale = null;
        BroadleafRequestContext requestContext = BroadleafRequestContext.getBroadleafRequestContext();
        if (requestContext != null) {
            locale = requestContext.getJavaLocale();
        }
        if (t instanceof BroadleafWebServicesException) {
            BroadleafWebServicesException blcException = (BroadleafWebServicesException)t;
            if (t.getCause() != null) {
                LOG.error((Object)"An error occured invoking a REST service.", t.getCause());
            }
            errorWrapper.setHttpStatusCode(blcException.getHttpStatusCode());
            if (blcException.getLocale() != null) {
                locale = blcException.getLocale();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (blcException.getMessages() != null && !blcException.getMessages().isEmpty()) {
                Set<String> keys = blcException.getMessages().keySet();
                for (String key : keys) {
                    ErrorMessageWrapper errorMessageWrapper = (ErrorMessageWrapper)this.context.getBean(ErrorMessageWrapper.class.getName());
                    errorMessageWrapper.setMessageKey(this.resolveClientMessageKey(key));
                    errorMessageWrapper.setMessage(this.messageSource.getMessage(key, blcException.getMessages().get(key), key, locale));
                    errorWrapper.getMessages().add(errorMessageWrapper);
                }
            } else {
                ErrorMessageWrapper errorMessageWrapper = (ErrorMessageWrapper)this.context.getBean(ErrorMessageWrapper.class.getName());
                errorMessageWrapper.setMessageKey(this.resolveClientMessageKey("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError"));
                errorMessageWrapper.setMessage(this.messageSource.getMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError", null, "org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError", locale));
                errorWrapper.getMessages().add(errorMessageWrapper);
            }
        } else {
            if (t instanceof WebApplicationException) {
                if (t.getCause() != null) {
                    LOG.error((Object)"An error occured invoking a REST service.", t.getCause());
                }
                WebApplicationException webAppException = (WebApplicationException)t;
                return webAppException.getResponse();
            }
            LOG.error((Object)"An error occured invoking a REST service", t);
            if (locale == null) {
                locale = Locale.getDefault();
            }
            errorWrapper.setHttpStatusCode(500);
            ErrorMessageWrapper errorMessageWrapper = (ErrorMessageWrapper)this.context.getBean(ErrorMessageWrapper.class.getName());
            errorMessageWrapper.setMessageKey(this.resolveClientMessageKey("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError"));
            errorMessageWrapper.setMessage(this.messageSource.getMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError", null, "org.broadleafcommerce.core.web.api.BroadleafWebServicesException.unknownError", locale));
            errorWrapper.getMessages().add(errorMessageWrapper);
        }
        return Response.status((int)this.resolveResponseStatusCode(t, errorWrapper)).type(mediaType).entity((Object)errorWrapper).build();
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void setMessageKeyPrefix(String prefix) {
        this.messageKeyPrefix = prefix;
    }

    protected int resolveResponseStatusCode(Throwable t, ErrorWrapper error) {
        if (error.getHttpStatusCode() == null) {
            return 500;
        }
        return error.getHttpStatusCode();
    }

    protected MediaType resolveResponseMediaType(Throwable t) {
        if (this.headers.getAcceptableMediaTypes() != null && !this.headers.getAcceptableMediaTypes().isEmpty()) {
            List types = this.headers.getAcceptableMediaTypes();
            for (MediaType type : types) {
                if (!MediaType.APPLICATION_XML_TYPE.equals((Object)type) && !MediaType.APPLICATION_JSON_TYPE.equals((Object)type)) continue;
                return type;
            }
        }
        if (MediaType.APPLICATION_XML_TYPE.equals((Object)this.headers.getMediaType())) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        return MediaType.APPLICATION_JSON_TYPE;
    }

    protected String resolveClientMessageKey(String key) {
        if (this.messageKeyPrefix != null) {
            return StringUtils.remove((String)key, (String)this.messageKeyPrefix);
        }
        return key;
    }
}

