/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.order;

import java.util.HashMap;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.exception.OfferMaxUseExceededException;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.exception.UpdateCartException;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.api.BroadleafWebServicesException;
import org.broadleafcommerce.core.web.api.endpoint.BaseEndpoint;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.BeansException;

public abstract class CartEndpoint
extends BaseEndpoint {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOfferService")
    protected OfferService offerService;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;

    public OrderWrapper findCartForCustomer(HttpServletRequest request) {
        Order cart = CartState.getCart();
        if (cart != null) {
            OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
            wrapper.wrapDetails(cart, request);
            return wrapper;
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public OrderWrapper createNewCartForCustomer(HttpServletRequest request) {
        Order cart;
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer == null) {
            customer = this.customerService.createCustomerFromId(null);
        }
        if ((cart = this.orderService.findCartForCustomer(customer)) == null) {
            cart = this.orderService.createNewCartForCustomer(customer);
            CartState.setCart(cart);
        }
        OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
        wrapper.wrapDetails(cart, request);
        return wrapper;
    }

    public OrderWrapper addProductToOrder(HttpServletRequest request, UriInfo uriInfo, Long productId, Long categoryId, int quantity, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                HashMap<String, String> productOptions = this.getOptions(uriInfo);
                OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
                orderItemRequestDTO.setProductId(productId);
                orderItemRequestDTO.setCategoryId(categoryId);
                orderItemRequestDTO.setQuantity(Integer.valueOf(quantity));
                if (productOptions.size() > 0) {
                    orderItemRequestDTO.setItemAttributes(productOptions);
                }
                Order order = this.orderService.addItem(cart.getId(), orderItemRequestDTO, priceOrder);
                order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                wrapper.wrapDetails(order, request);
                return wrapper;
            }
            catch (PricingException e) {
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e);
            }
            catch (AddToCartException e) {
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e);
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    protected HashMap<String, String> getOptions(UriInfo uriInfo) {
        MultivaluedMap multiValuedMap = uriInfo.getQueryParameters();
        HashMap<String, String> productOptions = new HashMap<String, String>();
        Set keySet = multiValuedMap.keySet();
        for (String key : keySet) {
            if (multiValuedMap.getFirst((Object)key) == null || !key.startsWith("productOption.")) continue;
            productOptions.put(StringUtils.removeStart((String)key, (String)"productOption."), (String)multiValuedMap.getFirst((Object)key));
        }
        return productOptions;
    }

    public OrderWrapper removeItemFromOrder(HttpServletRequest request, Long itemId, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                Order order = this.orderService.removeItem(cart.getId(), itemId, priceOrder);
                order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                wrapper.wrapDetails(order, request);
                return wrapper;
            }
            catch (PricingException e) {
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
            }
            catch (RemoveFromCartException e) {
                if (e.getCause() instanceof ItemNotFoundException) {
                    throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode(), null, null, e.getCause()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartItemNotFound", itemId);
                }
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e);
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public OrderWrapper updateItemQuantity(HttpServletRequest request, Long itemId, Integer quantity, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
                orderItemRequestDTO.setOrderItemId(itemId);
                orderItemRequestDTO.setQuantity(quantity);
                Order order = this.orderService.updateItemQuantity(cart.getId(), orderItemRequestDTO, priceOrder);
                order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                wrapper.wrapDetails(order, request);
                return wrapper;
            }
            catch (UpdateCartException e) {
                if (e.getCause() instanceof ItemNotFoundException) {
                    throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode(), null, null, e.getCause()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartItemNotFound", itemId);
                }
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.updateCartError");
            }
            catch (RemoveFromCartException e) {
                if (e.getCause() instanceof ItemNotFoundException) {
                    throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode(), null, null, e.getCause()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartItemNotFound", itemId);
                }
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.updateCartError");
            }
            catch (PricingException pe) {
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, pe).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public OrderWrapper addOfferCode(HttpServletRequest request, String promoCode, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart == null) {
            throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
        }
        OfferCode offerCode = this.offerService.lookupOfferCodeByCode(promoCode);
        if (offerCode == null) {
            throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.promoCodeInvalid", promoCode);
        }
        try {
            cart = this.orderService.addOfferCode(cart, offerCode, priceOrder);
            OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
            wrapper.wrapDetails(cart, request);
            return wrapper;
        }
        catch (PricingException e) {
            throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
        }
        catch (OfferMaxUseExceededException e) {
            throw BroadleafWebServicesException.build(Response.Status.BAD_REQUEST.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.promoCodeMaxUsages", promoCode);
        }
    }

    public OrderWrapper removeOfferCode(HttpServletRequest request, String promoCode, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart == null) {
            throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
        }
        OfferCode offerCode = this.offerService.lookupOfferCodeByCode(promoCode);
        if (offerCode == null) {
            throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.promoCodeInvalid", promoCode);
        }
        try {
            cart = this.orderService.removeOfferCode(cart, offerCode, priceOrder);
            OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
            wrapper.wrapDetails(cart, request);
            return wrapper;
        }
        catch (PricingException e) {
            throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
        }
    }

    public OrderWrapper removeAllOfferCodes(HttpServletRequest request, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart == null) {
            throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
        }
        try {
            cart = this.orderService.removeAllOfferCodes(cart, priceOrder);
            return this.wrapCart(request, cart);
        }
        catch (PricingException e) {
            throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
        }
    }

    public OrderWrapper updateProductOptions(HttpServletRequest request, UriInfo uriInfo, Long itemId, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
                HashMap<String, String> productOptions = this.getOptions(uriInfo);
                orderItemRequestDTO.setOrderItemId(itemId);
                if (productOptions.size() > 0) {
                    orderItemRequestDTO.setItemAttributes(productOptions);
                }
                Order order = this.orderService.updateProductOptionsForItem(cart.getId(), orderItemRequestDTO, priceOrder);
                order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                return this.wrapCart(request, cart);
            }
            catch (UpdateCartException e) {
                if (e.getCause() instanceof ItemNotFoundException) {
                    throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode(), null, null, e.getCause()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartItemNotFound", itemId);
                }
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.updateCartError");
            }
            catch (PricingException pe) {
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, pe).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    protected OrderWrapper wrapCart(HttpServletRequest request, Order cart) {
        try {
            OrderWrapper orderWrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
            orderWrapper.wrapDetails(cart, request);
            return orderWrapper;
        }
        catch (BeansException e) {
            throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e);
        }
    }
}

