/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.checkout.section;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class CheckoutSectionStateType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, CheckoutSectionStateType> TYPES = new LinkedHashMap<String, CheckoutSectionStateType>();
    public static final CheckoutSectionStateType FORM = new CheckoutSectionStateType("FORM", "Show Form State");
    public static final CheckoutSectionStateType SAVED = new CheckoutSectionStateType("SAVED", "Show Saved State");
    public static final CheckoutSectionStateType INACTIVE = new CheckoutSectionStateType("INACTIVE", "Show Inactive State");
    private String type;
    private String friendlyType;

    public static CheckoutSectionStateType getInstance(String type) {
        return TYPES.get(type);
    }

    public CheckoutSectionStateType() {
    }

    public CheckoutSectionStateType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CheckoutSectionStateType other = (CheckoutSectionStateType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

