/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.vendor.service.exception.FulfillmentPriceException;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.FulfillmentOptionService;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.service.OrderToPaymentRequestDTOService;
import org.broadleafcommerce.core.pricing.service.FulfillmentPricingService;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FulfillmentEstimationResponse;
import org.broadleafcommerce.core.web.checkout.model.BillingInfoForm;
import org.broadleafcommerce.core.web.checkout.model.OrderInfoForm;
import org.broadleafcommerce.core.web.checkout.model.ShippingInfoForm;
import org.broadleafcommerce.core.web.checkout.section.CheckoutSectionDTO;
import org.broadleafcommerce.core.web.checkout.section.CheckoutSectionStateType;
import org.broadleafcommerce.core.web.checkout.section.CheckoutSectionViewType;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.CustomerAddressService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.joda.time.DateTime;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.element.AbstractLocalVariableDefinitionElementProcessor;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

public class OnePageCheckoutProcessor
extends AbstractLocalVariableDefinitionElementProcessor {
    @Resource(name="blStateService")
    protected StateService stateService;
    @Resource(name="blCountryService")
    protected CountryService countryService;
    @Resource(name="blCustomerAddressService")
    protected CustomerAddressService customerAddressService;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Resource(name="blFulfillmentOptionService")
    protected FulfillmentOptionService fulfillmentOptionService;
    @Resource(name="blFulfillmentPricingService")
    protected FulfillmentPricingService fulfillmentPricingService;
    @Resource(name="blOrderToPaymentRequestDTOService")
    protected OrderToPaymentRequestDTOService orderToPaymentRequestDTOService;

    public OnePageCheckoutProcessor() {
        super("one_page_checkout");
    }

    public int getPrecedence() {
        return 100;
    }

    protected boolean removeHostElement(Arguments arguments, Element element) {
        return false;
    }

    protected Map<String, Object> getNewLocalVariables(Arguments arguments, Element element) {
        Expression expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue("orderInfoForm"));
        OrderInfoForm orderInfoForm = (OrderInfoForm)expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue("shippingInfoForm"));
        ShippingInfoForm shippingInfoForm = (ShippingInfoForm)expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue("billingInfoForm"));
        BillingInfoForm billingInfoForm = (BillingInfoForm)expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue("orderInfoHelpMessage"));
        String orderInfoHelpMessage = (String)expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue("billingInfoHelpMessage"));
        String billingInfoHelpMessage = (String)expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue("shippingInfoHelpMessage"));
        String shippingInfoHelpMessage = (String)expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        this.prepopulateCheckoutForms(CartState.getCart(), orderInfoForm, shippingInfoForm, billingInfoForm);
        HashMap<String, Object> localVars = new HashMap<String, Object>();
        Order cart = CartState.getCart();
        if (cart != null && !(cart instanceof NullOrderImpl)) {
            localVars.put("paymentRequestDTO", this.orderToPaymentRequestDTOService.translateOrder(cart));
        }
        int numShippableFulfillmentGroups = this.calculateNumShippableFulfillmentGroups();
        localVars.put("numShippableFulfillmentGroups", numShippableFulfillmentGroups);
        this.populateFulfillmentOptionsAndEstimationOnModel(localVars);
        localVars.put("orderInfoHelpMessage", orderInfoHelpMessage);
        localVars.put("billingInfoHelpMessage", billingInfoHelpMessage);
        localVars.put("shippingInfoHelpMessage", shippingInfoHelpMessage);
        this.populateSectionViewStates(localVars);
        localVars.put("states", this.stateService.findStates());
        localVars.put("countries", this.countryService.findCountries());
        localVars.put("expirationMonths", this.populateExpirationMonths());
        localVars.put("expirationYears", this.populateExpirationYears());
        this.populateProcessingError(localVars);
        return localVars;
    }

    protected void prepopulateCheckoutForms(Order cart, OrderInfoForm orderInfoForm, ShippingInfoForm shippingForm, BillingInfoForm billingForm) {
        FulfillmentGroup firstShippableFulfillmentGroup;
        if (orderInfoForm != null) {
            orderInfoForm.setEmailAddress(cart.getEmailAddress());
        }
        if ((firstShippableFulfillmentGroup = this.fulfillmentGroupService.getFirstShippableFulfillmentGroup(cart)) != null) {
            FulfillmentOption fulfillmentOption = firstShippableFulfillmentGroup.getFulfillmentOption();
            if (fulfillmentOption != null) {
                if (firstShippableFulfillmentGroup.getAddress() != null) {
                    shippingForm.setAddress(firstShippableFulfillmentGroup.getAddress());
                }
                shippingForm.setFulfillmentOption(fulfillmentOption);
                shippingForm.setFulfillmentOptionId(fulfillmentOption.getId());
            } else {
                CustomerAddress defaultAddress = this.customerAddressService.findDefaultCustomerAddress(CustomerState.getCustomer().getId());
                if (defaultAddress != null) {
                    shippingForm.setAddress(defaultAddress.getAddress());
                    shippingForm.setAddressName(defaultAddress.getAddressName());
                }
            }
        }
        if (cart.getPayments() != null) {
            for (OrderPayment payment : cart.getPayments()) {
                if (!PaymentType.CREDIT_CARD.equals((Object)payment.getType()) || payment.getBillingAddress() == null) continue;
                billingForm.setAddress(payment.getBillingAddress());
            }
        }
    }

    protected int calculateNumShippableFulfillmentGroups() {
        int numShippableFulfillmentGroups = 0;
        List fulfillmentGroups = CartState.getCart().getFulfillmentGroups();
        if (fulfillmentGroups != null) {
            for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
                if (!this.fulfillmentGroupService.isShippable(fulfillmentGroup.getType())) continue;
                ++numShippableFulfillmentGroups;
            }
        }
        return numShippableFulfillmentGroups;
    }

    protected void populateProcessingError(Map<String, Object> localVars) {
        BroadleafRequestContext blcContext = BroadleafRequestContext.getBroadleafRequestContext();
        HttpServletRequest request = blcContext.getRequest();
        String processorError = request.getParameter("PAYMENT_PROCESSING_ERROR");
        localVars.put("PAYMENT_PROCESSING_ERROR", processorError);
    }

    protected void populateSectionViewStates(Map<String, Object> localVars) {
        boolean orderInfoPopulated = this.hasPopulatedOrderInfo(CartState.getCart());
        boolean billingPopulated = this.hasPopulatedBillingAddress(CartState.getCart());
        boolean shippingPopulated = this.hasPopulatedShippingAddress(CartState.getCart());
        localVars.put("orderInfoPopulated", orderInfoPopulated);
        localVars.put("billingPopulated", billingPopulated);
        localVars.put("shippingPopulated", shippingPopulated);
        boolean showBillingInfoSection = true;
        boolean showShippingInfoSection = true;
        boolean showAllPaymentMethods = true;
        int numShippableFulfillmentGroups = this.calculateNumShippableFulfillmentGroups();
        if (numShippableFulfillmentGroups == 0) {
            showShippingInfoSection = false;
        }
        boolean orderContainsThirdPartyPayment = false;
        if (CartState.getCart().getPayments() != null) {
            for (OrderPayment payment : CartState.getCart().getPayments()) {
                if (!PaymentType.THIRD_PARTY_ACCOUNT.equals((Object)payment.getType()) || !payment.isActive()) continue;
                orderContainsThirdPartyPayment = true;
            }
        }
        Money orderTotalAfterAppliedPayments = CartState.getCart().getTotalAfterAppliedPayments();
        if (orderContainsThirdPartyPayment) {
            showBillingInfoSection = false;
            showAllPaymentMethods = false;
        } else if (orderTotalAfterAppliedPayments != null && orderTotalAfterAppliedPayments.isZero()) {
            showAllPaymentMethods = false;
        }
        localVars.put("showBillingInfoSection", showBillingInfoSection);
        localVars.put("showAllPaymentMethods", showAllPaymentMethods);
        localVars.put("orderContainsThirdPartyPayment", orderContainsThirdPartyPayment);
        LinkedList<CheckoutSectionDTO> drawnSections = new LinkedList<CheckoutSectionDTO>();
        CheckoutSectionDTO orderInfoSection = new CheckoutSectionDTO(CheckoutSectionViewType.ORDER_INFO, orderInfoPopulated);
        CheckoutSectionDTO billingInfoSection = new CheckoutSectionDTO(CheckoutSectionViewType.BILLING_INFO, billingPopulated);
        CheckoutSectionDTO shippingInfoSection = new CheckoutSectionDTO(CheckoutSectionViewType.SHIPPING_INFO, shippingPopulated);
        CheckoutSectionDTO paymentInfoSection = new CheckoutSectionDTO(CheckoutSectionViewType.PAYMENT_INFO, false);
        String orderInfoHelpMessage = (String)localVars.get("orderInfoHelpMessage");
        String billingInfoHelpMessage = (String)localVars.get("billingInfoHelpMessage");
        String shippingInfoHelpMessage = (String)localVars.get("shippingInfoHelpMessage");
        drawnSections.add(orderInfoSection);
        if (showBillingInfoSection) {
            billingInfoSection.setHelpMessage(orderInfoHelpMessage);
            drawnSections.add(billingInfoSection);
        }
        if (showShippingInfoSection) {
            if (showBillingInfoSection) {
                shippingInfoSection.setHelpMessage(billingInfoHelpMessage);
            } else {
                shippingInfoSection.setHelpMessage(orderInfoHelpMessage);
            }
            drawnSections.add(shippingInfoSection);
        }
        if (showShippingInfoSection) {
            paymentInfoSection.setHelpMessage(shippingInfoHelpMessage);
        } else if (showBillingInfoSection) {
            paymentInfoSection.setHelpMessage(billingInfoHelpMessage);
        } else {
            paymentInfoSection.setHelpMessage(orderInfoHelpMessage);
        }
        drawnSections.add(paymentInfoSection);
        CheckoutSectionDTO firstSection = (CheckoutSectionDTO)drawnSections.get(0);
        firstSection.setState(CheckoutSectionStateType.FORM);
        ListIterator itr = drawnSections.listIterator();
        while (itr.hasNext()) {
            CheckoutSectionDTO previousSection = null;
            if (itr.hasPrevious()) {
                previousSection = (CheckoutSectionDTO)drawnSections.get(itr.previousIndex());
            }
            CheckoutSectionDTO section = (CheckoutSectionDTO)itr.next();
            if (previousSection != null && previousSection.isPopulated()) {
                section.setState(CheckoutSectionStateType.FORM);
            }
            if (section.isPopulated()) {
                section.setState(CheckoutSectionStateType.SAVED);
            }
            if (CheckoutSectionViewType.PAYMENT_INFO.equals(section.getView()) && showBillingInfoSection && !billingPopulated) {
                section.setState(CheckoutSectionStateType.INACTIVE);
                section.setHelpMessage(billingInfoHelpMessage);
            }
            BroadleafRequestContext blcContext = BroadleafRequestContext.getBroadleafRequestContext();
            HttpServletRequest request = blcContext.getRequest();
            boolean editOrderInfo = BooleanUtils.toBoolean((String)request.getParameter("edit-order-info"));
            boolean editBillingInfo = BooleanUtils.toBoolean((String)request.getParameter("edit-billing"));
            boolean editShippingInfo = BooleanUtils.toBoolean((String)request.getParameter("edit-shipping"));
            if (CheckoutSectionViewType.ORDER_INFO.equals(section.getView()) && editOrderInfo) {
                section.setState(CheckoutSectionStateType.FORM);
                continue;
            }
            if (CheckoutSectionViewType.BILLING_INFO.equals(section.getView()) && editBillingInfo) {
                section.setState(CheckoutSectionStateType.FORM);
                continue;
            }
            if (!CheckoutSectionViewType.SHIPPING_INFO.equals(section.getView()) || !editShippingInfo) continue;
            section.setState(CheckoutSectionStateType.FORM);
        }
        localVars.put("checkoutSectionDTOs", drawnSections);
    }

    protected void populateFulfillmentOptionsAndEstimationOnModel(Map<String, Object> localVars) {
        List fulfillmentOptions = this.fulfillmentOptionService.readAllFulfillmentOptions();
        Order cart = CartState.getCart();
        if (!(cart instanceof NullOrderImpl) && cart.getFulfillmentGroups().size() > 0 && this.hasPopulatedShippingAddress(cart)) {
            HashSet options = new HashSet();
            options.addAll(fulfillmentOptions);
            FulfillmentEstimationResponse estimateResponse = null;
            try {
                estimateResponse = this.fulfillmentPricingService.estimateCostForFulfillmentGroup(this.fulfillmentGroupService.getFirstShippableFulfillmentGroup(cart), options);
            }
            catch (FulfillmentPriceException e) {
                // empty catch block
            }
            localVars.put("estimateResponse", estimateResponse);
        }
        localVars.put("fulfillmentOptions", fulfillmentOptions);
    }

    protected boolean hasPopulatedOrderInfo(Order cart) {
        return StringUtils.isNotBlank((String)cart.getEmailAddress());
    }

    protected boolean hasPopulatedBillingAddress(Order cart) {
        if (cart.getPayments() == null) {
            return false;
        }
        for (OrderPayment payment : cart.getPayments()) {
            if (!payment.isActive() || !PaymentType.CREDIT_CARD.equals((Object)payment.getType()) || payment.getBillingAddress() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean hasPopulatedShippingAddress(Order cart) {
        if (cart.getFulfillmentGroups() == null) {
            return false;
        }
        for (FulfillmentGroup fulfillmentGroup : cart.getFulfillmentGroups()) {
            if (!this.fulfillmentGroupService.isShippable(fulfillmentGroup.getType()) || fulfillmentGroup.getAddress() != null && fulfillmentGroup.getFulfillmentOption() != null) continue;
            return false;
        }
        return true;
    }

    protected List<String> populateExpirationMonths() {
        DateFormatSymbols dateFormatter;
        if (BroadleafRequestContext.hasLocale()) {
            Locale locale = BroadleafRequestContext.getBroadleafRequestContext().getJavaLocale();
            dateFormatter = new DateFormatSymbols(locale);
        } else {
            dateFormatter = new DateFormatSymbols();
        }
        ArrayList<String> expirationMonths = new ArrayList<String>();
        DecimalFormat formatter = new DecimalFormat("00");
        String[] months = dateFormatter.getMonths();
        for (int i = 1; i < months.length; ++i) {
            expirationMonths.add(formatter.format(i) + " - " + months[i - 1]);
        }
        return expirationMonths;
    }

    protected List<String> populateExpirationYears() {
        ArrayList<String> expirationYears = new ArrayList<String>();
        DateTime dateTime = new DateTime();
        for (int i = 0; i < 10; ++i) {
            expirationYears.add(dateTime.plusYears(i).getYear() + "");
        }
        return expirationYears;
    }
}

