/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.cache.engine;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.cache.engine.HydratedAnnotationManager;
import org.broadleafcommerce.profile.cache.engine.HydratedCache;
import org.broadleafcommerce.profile.cache.engine.HydratedCacheElement;
import org.broadleafcommerce.profile.cache.engine.HydratedCacheManager;
import org.broadleafcommerce.profile.cache.engine.HydrationDescriptor;
import org.broadleafcommerce.profile.cache.engine.HydrationScanner;
import org.hibernate.cache.CacheKey;

@Deprecated
public class HydratedCacheManagerImpl
implements CacheEventListener,
HydratedCacheManager,
HydratedAnnotationManager {
    private static final Log LOG = LogFactory.getLog(HydratedCacheManagerImpl.class);
    private static final HydratedCacheManagerImpl MANAGER = new HydratedCacheManagerImpl();
    private Map<String, HydratedCache> hydratedCacheContainer = new Hashtable<String, HydratedCache>(100);
    private Map<String, HydrationDescriptor> hydrationDescriptors = new Hashtable<String, HydrationDescriptor>(100);

    public static HydratedCacheManagerImpl getInstance() {
        return MANAGER;
    }

    private HydratedCacheManagerImpl() {
    }

    public void addHydratedCache(HydratedCache cache) {
        this.hydratedCacheContainer.put(cache.getCacheRegion() + "_" + cache.getCacheName(), cache);
    }

    public HydratedCache removeHydratedCache(String cacheRegion, String cacheName) {
        return this.hydratedCacheContainer.remove(cacheRegion + "_" + cacheName);
    }

    public HydratedCache getHydratedCache(String cacheRegion, String cacheName) {
        if (!this.containsCache(cacheRegion, cacheName)) {
            HydratedCache cache = new HydratedCache(cacheRegion, cacheName);
            this.addHydratedCache(cache);
        }
        return this.hydratedCacheContainer.get(cacheRegion + "_" + cacheName);
    }

    public boolean containsCache(String cacheRegion, String cacheName) {
        return this.hydratedCacheContainer.containsKey(cacheRegion + "_" + cacheName);
    }

    @Override
    public HydrationDescriptor getHydrationDescriptor(Object entity) {
        if (this.hydrationDescriptors.containsKey(entity.getClass().getName())) {
            return this.hydrationDescriptors.get(entity.getClass().getName());
        }
        HydrationDescriptor descriptor = new HydrationDescriptor();
        Class<?> topEntityClass = this.getTopEntityClass(entity);
        HydrationScanner scanner = new HydrationScanner(topEntityClass, entity.getClass());
        scanner.init();
        descriptor.setHydratedMutators(scanner.getCacheMutators());
        Map<String, Method[]> mutators = scanner.getIdMutators();
        if (mutators.size() != 1) {
            throw new RuntimeException("Broadleaf Commerce Hydrated Cache currently only supports entities with a single @Id annotation.");
        }
        Method[] singleMutators = mutators.values().iterator().next();
        descriptor.setIdMutators(singleMutators);
        String cacheRegion = scanner.getCacheRegion();
        if (cacheRegion == null || "".equals(cacheRegion)) {
            cacheRegion = topEntityClass.getName();
        }
        descriptor.setCacheRegion(cacheRegion);
        this.hydrationDescriptors.put(entity.getClass().getName(), descriptor);
        return descriptor;
    }

    public Class<?> getTopEntityClass(Object entity) {
        Class<?> myClass = entity.getClass();
        for (Class<?> superClass = entity.getClass().getSuperclass(); superClass != null && superClass.getName().startsWith("org.broadleaf"); superClass = superClass.getSuperclass()) {
            myClass = superClass;
        }
        return myClass;
    }

    @Override
    public Object getHydratedCacheElementItem(String cacheRegion, String cacheName, Serializable elementKey, String elementItemName) {
        Object response = null;
        HydratedCache hydratedCache = this.getHydratedCache(cacheRegion, cacheName);
        HydratedCacheElement element = hydratedCache.getCacheElement(cacheRegion, cacheName, elementKey);
        if (element != null) {
            response = element.getCacheElementItem(elementItemName, elementKey);
        }
        return response;
    }

    @Override
    public void addHydratedCacheElementItem(String cacheRegion, String cacheName, Serializable elementKey, String elementItemName, Object elementValue) {
        HydratedCache hydratedCache = this.getHydratedCache(cacheRegion, cacheName);
        HydratedCacheElement element = hydratedCache.getCacheElement(cacheRegion, cacheName, elementKey);
        if (element == null) {
            element = new HydratedCacheElement();
            hydratedCache.addCacheElement(cacheRegion, cacheName, elementKey, element);
        }
        element.putCacheElementItem(elementItemName, elementKey, elementValue);
    }

    public void dispose() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Disposing of all hydrated cache members");
        }
        this.hydratedCacheContainer.clear();
    }

    private void removeCache(String cacheRegion, Serializable key) {
        String myKey;
        HydratedCache cache;
        String cacheName = cacheRegion;
        if (key instanceof CacheKey) {
            cacheName = ((CacheKey)key).getEntityOrRoleName();
            key = ((CacheKey)key).getKey();
        }
        if (this.containsCache(cacheRegion, cacheName) && (cache = this.hydratedCacheContainer.get(cacheRegion + "_" + cacheName)).containsKey(myKey = cacheRegion + "_" + cacheName + "_" + key)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Clearing hydrated cache for cache name: " + cacheRegion + "_" + cacheName + "_" + key));
            }
            cache.removeCacheElement(cacheRegion, cacheName, key);
        }
    }

    private void removeAll(String cacheName) {
        if (this.hydratedCacheContainer.containsKey(cacheName)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Clearing all hydrated caches for cache name: " + cacheName));
            }
            this.hydratedCacheContainer.remove(cacheName);
        }
    }

    public void notifyElementEvicted(Ehcache arg0, Element arg1) {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyElementExpired(Ehcache arg0, Element arg1) {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyElementPut(Ehcache arg0, Element arg1) throws CacheException {
    }

    public void notifyElementRemoved(Ehcache arg0, Element arg1) throws CacheException {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyElementUpdated(Ehcache arg0, Element arg1) throws CacheException {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyRemoveAll(Ehcache arg0) {
        this.removeAll(arg0.getName());
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }
}

