/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.CountryDao;
import org.broadleafcommerce.profile.core.domain.Country;
import org.springframework.stereotype.Repository;

@Repository(value="blCountryDao")
public class CountryDaoImpl
implements CountryDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Country findCountryByAbbreviation(String abbreviation) {
        return (Country)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.core.domain.Country"), (Object)abbreviation);
    }

    @Override
    public List<Country> findCountries() {
        Query query = this.em.createNamedQuery("BC_FIND_COUNTRIES");
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    @Override
    public Country save(Country country) {
        return (Country)this.em.merge((Object)country);
    }
}

