/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.CustomerPhoneDao;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.springframework.stereotype.Repository;

@Repository(value="blCustomerPhoneDao")
public class CustomerPhoneDaoImpl
implements CustomerPhoneDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public List<CustomerPhone> readActiveCustomerPhonesByCustomerId(Long customerId) {
        Query query = this.em.createNamedQuery("BC_READ_ACTIVE_CUSTOMER_PHONES_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        return query.getResultList();
    }

    @Override
    public CustomerPhone save(CustomerPhone customerPhone) {
        return (CustomerPhone)this.em.merge((Object)customerPhone);
    }

    @Override
    public CustomerPhone readCustomerPhoneById(Long customerPhoneId) {
        return (CustomerPhone)this.em.find(this.entityConfiguration.lookupEntityClass(CustomerPhone.class.getName()), (Object)customerPhoneId);
    }

    @Override
    public void makeCustomerPhoneDefault(Long customerPhoneId, Long customerId) {
        List<CustomerPhone> customerPhones = this.readActiveCustomerPhonesByCustomerId(customerId);
        for (CustomerPhone customerPhone : customerPhones) {
            customerPhone.getPhone().setDefault(customerPhone.getId().equals(customerPhoneId));
            this.em.merge((Object)customerPhone);
        }
    }

    @Override
    public void deleteCustomerPhoneById(Long customerPhoneId) {
        CustomerPhone customerPhone = this.readCustomerPhoneById(customerPhoneId);
        if (customerPhone != null) {
            this.em.remove((Object)customerPhone);
        }
    }

    @Override
    public CustomerPhone findDefaultCustomerPhone(Long customerId) {
        Query query = this.em.createNamedQuery("BC_FIND_DEFAULT_PHONE_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        List customerPhones = query.getResultList();
        return customerPhones.isEmpty() ? null : (CustomerPhone)customerPhones.get(0);
    }

    @Override
    public List<CustomerPhone> readAllCustomerPhonesByCustomerId(Long customerId) {
        Query query = this.em.createNamedQuery("BC_READ_ALL_CUSTOMER_PHONES_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        return query.getResultList();
    }

    @Override
    public CustomerPhone create() {
        return (CustomerPhone)this.entityConfiguration.createEntityInstance(CustomerPhone.class.getName());
    }
}

