/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.domain.LocaleImpl;
import org.broadleafcommerce.openadmin.audit.Auditable;
import org.broadleafcommerce.openadmin.audit.AuditableListener;
import org.broadleafcommerce.openadmin.client.dto.VisibilityEnum;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.presentation.AdminPresentationClass;
import org.broadleafcommerce.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.profile.core.domain.ChallengeQuestion;
import org.broadleafcommerce.profile.core.domain.ChallengeQuestionImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@EntityListeners(value={AuditableListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CUSTOMER", uniqueConstraints={@UniqueConstraint(columnNames={"USER_NAME"})})
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blStandardElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="baseCustomer")
public class CustomerImpl
implements Customer {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="CUSTOMER_ID")
    @AdminPresentation(friendlyName="Customer Id", group="Primary Key", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Embedded
    protected Auditable auditable = new Auditable();
    @Column(name="USER_NAME")
    @AdminPresentation(friendlyName="UserName", order=1, group="Customer", prominent=true)
    protected String username;
    @Column(name="PASSWORD")
    @AdminPresentation(excluded=true)
    protected String password;
    @Column(name="FIRST_NAME")
    @AdminPresentation(friendlyName="First Name", order=2, group="Customer", prominent=true)
    protected String firstName;
    @Column(name="LAST_NAME")
    @AdminPresentation(friendlyName="Last Name", order=3, group="Customer", prominent=true)
    protected String lastName;
    @Column(name="EMAIL_ADDRESS")
    @Index(name="CUSTOMER_EMAIL_INDEX", columnNames={"EMAIL_ADDRESS"})
    @AdminPresentation(friendlyName="Email Address", order=4, group="Customer")
    protected String emailAddress;
    @ManyToOne(targetEntity=ChallengeQuestionImpl.class)
    @JoinColumn(name="CHALLENGE_QUESTION_ID")
    @Index(name="CUSTOMER_CHALLENGE_INDEX", columnNames={"CHALLENGE_QUESTION_ID"})
    @AdminPresentation(friendlyName="Challenge Question", group="Customer", excluded=true, visibility=VisibilityEnum.GRID_HIDDEN)
    protected ChallengeQuestion challengeQuestion;
    @Column(name="CHALLENGE_ANSWER")
    @AdminPresentation(excluded=true)
    protected String challengeAnswer;
    @Column(name="PASSWORD_CHANGE_REQUIRED")
    @AdminPresentation(excluded=true)
    protected boolean passwordChangeRequired = false;
    @Column(name="RECEIVE_EMAIL")
    @AdminPresentation(friendlyName="Customer Receive Email", group="Customer")
    protected boolean receiveEmail = true;
    @Column(name="IS_REGISTERED")
    @AdminPresentation(friendlyName="Customer Registered", group="Customer")
    protected boolean registered = false;
    @ManyToOne(targetEntity=LocaleImpl.class)
    @JoinColumn(name="LOCALE_CODE")
    @AdminPresentation(friendlyName="Customer Locale", group="Customer", excluded=true, visibility=VisibilityEnum.GRID_HIDDEN)
    protected Locale customerLocale;
    @Transient
    protected String unencodedPassword;
    @Transient
    protected String unencodedChallengeAnswer;
    @Transient
    protected boolean anonymous;
    @Transient
    protected boolean cookied;
    @Transient
    protected boolean loggedIn;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isPasswordChangeRequired() {
        return this.passwordChangeRequired;
    }

    @Override
    public void setPasswordChangeRequired(boolean passwordChangeRequired) {
        this.passwordChangeRequired = passwordChangeRequired;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public ChallengeQuestion getChallengeQuestion() {
        return this.challengeQuestion;
    }

    @Override
    public void setChallengeQuestion(ChallengeQuestion challengeQuestion) {
        this.challengeQuestion = challengeQuestion;
    }

    @Override
    public String getChallengeAnswer() {
        return this.challengeAnswer;
    }

    @Override
    public void setChallengeAnswer(String challengeAnswer) {
        this.challengeAnswer = challengeAnswer;
    }

    @Override
    public String getUnencodedPassword() {
        return this.unencodedPassword;
    }

    @Override
    public void setUnencodedPassword(String unencodedPassword) {
        this.unencodedPassword = unencodedPassword;
    }

    @Override
    public boolean isReceiveEmail() {
        return this.receiveEmail;
    }

    @Override
    public void setReceiveEmail(boolean receiveEmail) {
        this.receiveEmail = receiveEmail;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    @Override
    public String getUnencodedChallengeAnswer() {
        return this.unencodedChallengeAnswer;
    }

    @Override
    public void setUnencodedChallengeAnswer(String unencodedChallengeAnswer) {
        this.unencodedChallengeAnswer = unencodedChallengeAnswer;
    }

    @Override
    public Auditable getAuditable() {
        return this.auditable;
    }

    @Override
    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public boolean isCookied() {
        return this.cookied;
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
        if (anonymous) {
            this.cookied = false;
            this.loggedIn = false;
        }
    }

    @Override
    public void setCookied(boolean cookied) {
        this.cookied = cookied;
        if (cookied) {
            this.anonymous = false;
            this.loggedIn = false;
        }
    }

    @Override
    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
        if (loggedIn) {
            this.anonymous = false;
            this.cookied = false;
        }
    }

    @Override
    public Locale getCustomerLocale() {
        return this.customerLocale;
    }

    @Override
    public void setCustomerLocale(Locale customerLocale) {
        this.customerLocale = customerLocale;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomerImpl other = (CustomerImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }
}

