/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.profile.core.domain.Role;
import org.broadleafcommerce.profile.core.domain.RoleImpl;
import org.broadleafcommerce.profile.core.domain.User;
import org.broadleafcommerce.profile.core.domain.UserImpl;
import org.broadleafcommerce.profile.core.domain.UserRole;
import org.broadleafcommerce.profile.core.domain.listener.TemporalTimestampListener;
import org.hibernate.annotations.Index;

@Entity
@EntityListeners(value={TemporalTimestampListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_USER_ROLE")
public class UserRoleImpl
implements UserRole {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UserRoleId", strategy=GenerationType.TABLE)
    @TableGenerator(name="UserRoleId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="UserRoleImpl", allocationSize=50)
    @Column(name="USER_ROLE_ID")
    protected Long id;
    @ManyToOne(targetEntity=UserImpl.class, optional=false)
    @JoinColumn(name="USER_ID")
    @Index(name="USERROLE_USER_INDEX", columnNames={"USER_ID"})
    protected User user;
    @OneToOne(cascade={CascadeType.ALL}, targetEntity=RoleImpl.class, optional=false)
    @JoinColumn(name="ROLE_ID")
    protected Role role;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public void setRole(Role role) {
        this.role = role;
    }

    @Override
    public String getRoleName() {
        return this.role.getRoleName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserRoleImpl other = (UserRoleImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.role == null ? other.role != null : !this.role.equals(other.role)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

