/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerRole;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.RoleService;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Deprecated
public class UserDetailsServiceImpl
implements UserDetailsService {
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blRoleService")
    protected RoleService roleService;
    protected boolean forcePasswordChange = false;

    public void setForcePasswordChange(boolean forcePasswordChange) {
        this.forcePasswordChange = forcePasswordChange;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        Customer customer = this.customerService.readCustomerByUsername(username);
        if (customer == null) {
            throw new UsernameNotFoundException("The customer was not found");
        }
        User returnUser = null;
        boolean pwChangeRequired = customer.isPasswordChangeRequired();
        List<GrantedAuthority> grantedAuthorities = this.createGrantedAuthorities(this.roleService.findCustomerRolesByCustomerId(customer.getId()));
        if (pwChangeRequired) {
            if (this.forcePasswordChange) {
                returnUser = new User(username, customer.getPassword(), true, true, !customer.isPasswordChangeRequired(), true, grantedAuthorities.toArray(new GrantedAuthority[0]));
            } else {
                grantedAuthorities.add((GrantedAuthority)new GrantedAuthorityImpl("ROLE_PASSWORD_CHANGE_REQUIRED"));
                returnUser = new User(username, customer.getPassword(), true, true, true, true, grantedAuthorities.toArray(new GrantedAuthority[0]));
            }
        } else {
            returnUser = new User(username, customer.getPassword(), true, true, !customer.isPasswordChangeRequired(), true, grantedAuthorities.toArray(new GrantedAuthority[0]));
        }
        return returnUser;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    protected List<GrantedAuthority> createGrantedAuthorities(List<CustomerRole> customerRoles) {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        grantedAuthorities.add((GrantedAuthority)new GrantedAuthorityImpl("ROLE_USER"));
        for (CustomerRole role : customerRoles) {
            grantedAuthorities.add((GrantedAuthority)new GrantedAuthorityImpl(role.getRoleName()));
        }
        return grantedAuthorities;
    }
}

