/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.email.dao;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.broadleafcommerce.openadmin.time.SystemTime;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.email.dao.EmailReportingDao;
import org.broadleafcommerce.profile.email.domain.EmailTarget;
import org.broadleafcommerce.profile.email.domain.EmailTracking;
import org.broadleafcommerce.profile.email.domain.EmailTrackingClicks;
import org.broadleafcommerce.profile.email.domain.EmailTrackingOpens;
import org.springframework.stereotype.Repository;

@Repository(value="blEmailReportingDao")
public class EmailReportingDaoImpl
implements EmailReportingDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Long createTracking(String emailAddress, String type, String extraValue) {
        EmailTracking tracking = (EmailTracking)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.email.domain.EmailTracking");
        tracking.setDateSent(SystemTime.asDate());
        tracking.setEmailAddress(emailAddress);
        tracking.setType(type);
        this.em.persist((Object)tracking);
        return tracking.getId();
    }

    @Override
    public EmailTarget createTarget() {
        EmailTarget target = (EmailTarget)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.email.domain.EmailTarget");
        return target;
    }

    @Override
    public EmailTracking retrieveTracking(Long emailId) {
        return (EmailTracking)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.email.domain.EmailTracking"), (Object)emailId);
    }

    @Override
    public void recordOpen(Long emailId, String userAgent) {
        EmailTrackingOpens opens = (EmailTrackingOpens)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.email.domain.EmailTrackingOpens");
        opens.setEmailTracking(this.retrieveTracking(emailId));
        opens.setDateOpened(SystemTime.asDate());
        opens.setUserAgent(userAgent);
        this.em.persist((Object)opens);
    }

    @Override
    public void recordClick(Long emailId, Customer customer, String destinationUri, String queryString) {
        EmailTrackingClicks clicks = (EmailTrackingClicks)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.email.domain.EmailTrackingClicks");
        clicks.setEmailTracking(this.retrieveTracking(emailId));
        clicks.setDateClicked(SystemTime.asDate());
        clicks.setDestinationUri(destinationUri);
        clicks.setQueryString(queryString);
        clicks.setCustomer(customer);
        this.em.persist((Object)clicks);
    }
}

