/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.extensibility.context;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.extensibility.context.ResourceInputStream;
import org.broadleafcommerce.profile.extensibility.context.merge.MergeXmlConfigResource;
import org.broadleafcommerce.profile.extensibility.context.merge.exceptions.MergeException;
import org.broadleafcommerce.profile.extensibility.context.merge.exceptions.MergeManagerSetupException;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class MergeApplicationContextXmlConfigResource
extends MergeXmlConfigResource {
    private static final Log LOG = LogFactory.getLog(MergeApplicationContextXmlConfigResource.class);

    public Resource[] getConfigResources(ResourceInputStream[] sources, ResourceInputStream[] patches) throws BeansException {
        Resource[] configResources = null;
        ResourceInputStream merged = null;
        try {
            merged = this.merge(sources);
            if (patches != null) {
                ResourceInputStream[] patches2 = new ResourceInputStream[patches.length + 1];
                patches2[0] = merged;
                System.arraycopy(patches, 0, patches2, 1, patches.length);
                merged = this.merge(patches2);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean eof = false;
            while (!eof) {
                int temp = merged.read();
                if (temp == -1) {
                    eof = true;
                    continue;
                }
                baos.write(temp);
            }
            configResources = new Resource[]{new ByteArrayResource(baos.toByteArray())};
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Merged ApplicationContext Including Patches: \n" + this.serialize(configResources[0])));
            }
        }
        catch (MergeException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (MergeManagerSetupException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        finally {
            if (merged != null) {
                try {
                    merged.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Unable to merge source and patch locations", e);
                }
            }
        }
        return configResources;
    }
}

