/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.extensibility.context;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.broadleafcommerce.profile.extensibility.context.MergeApplicationContextXmlConfigResource;
import org.broadleafcommerce.profile.extensibility.context.ResourceInputStream;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;

public class MergeFileSystemXMLApplicationContext
extends AbstractXmlApplicationContext {
    protected Resource[] configResources;

    protected Resource[] getConfigResources() {
        return this.configResources;
    }

    public MergeFileSystemXMLApplicationContext(String[] sourceLocations, String[] patchLocations) throws BeansException {
        this(sourceLocations, patchLocations, null);
    }

    public MergeFileSystemXMLApplicationContext(String[] sourceLocations, String[] patchLocations, ApplicationContext parent) throws BeansException {
        super(parent);
        ResourceInputStream[] patches;
        ResourceInputStream[] sources;
        try {
            File temp;
            int j;
            sources = new ResourceInputStream[sourceLocations.length];
            for (j = 0; j < sourceLocations.length; ++j) {
                temp = new File(sourceLocations[j]);
                sources[j] = new ResourceInputStream(new BufferedInputStream(new FileInputStream(temp)), sourceLocations[j]);
            }
            patches = new ResourceInputStream[patchLocations.length];
            for (j = 0; j < patches.length; ++j) {
                temp = new File(patchLocations[j]);
                sources[j] = new ResourceInputStream(new BufferedInputStream(new FileInputStream(temp)), patchLocations[j]);
            }
        }
        catch (FileNotFoundException e) {
            throw new FatalBeanException("Unable to merge context files", (Throwable)e);
        }
        this.configResources = new MergeApplicationContextXmlConfigResource().getConfigResources(sources, patches);
        this.refresh();
    }
}

