/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.extensibility.context.merge;

import java.util.List;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.extensibility.context.merge.handlers.MergeHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MergePoint {
    private static final Log LOG = LogFactory.getLog(MergePoint.class);
    private MergeHandler handler;
    private Document doc1;
    private Document doc2;
    private XPath xPath;

    public MergePoint(MergeHandler handler, Document doc1, Document doc2) {
        this.handler = handler;
        this.doc1 = doc1;
        this.doc2 = doc2;
        XPathFactory factory = XPathFactory.newInstance();
        this.xPath = factory.newXPath();
    }

    public Node[] merge(List<Node> exhaustedNodes) throws XPathExpressionException, TransformerException {
        return this.merge(this.handler, exhaustedNodes);
    }

    private Node[] merge(MergeHandler handler, List<Node> exhaustedNodes) throws XPathExpressionException, TransformerException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing handler: " + handler.getXPath()));
        }
        if (handler.getChildren() != null) {
            MergeHandler[] children = handler.getChildren();
            for (int j = 0; j < children.length; ++j) {
                Node[] temp = this.merge(children[j], exhaustedNodes);
                if (temp == null) continue;
                for (Node node : temp) {
                    exhaustedNodes.add(node);
                }
            }
        }
        NodeList nodeList1 = (NodeList)this.xPath.evaluate(handler.getXPath(), this.doc1, XPathConstants.NODESET);
        NodeList nodeList2 = (NodeList)this.xPath.evaluate(handler.getXPath(), this.doc2, XPathConstants.NODESET);
        if (nodeList1 != null && nodeList2 != null) {
            return handler.merge(nodeList1, nodeList2, exhaustedNodes);
        }
        return null;
    }
}

