/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.extensibility.jpa;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.broadleafcommerce.instrument.BroadleafInstrumentationSavingAgent;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BroadleafLoadTimeWeaver
implements LoadTimeWeaver {
    private static final boolean AGENT_CLASS_PRESENT = ClassUtils.isPresent((String)"org.broadleafcommerce.instrument.BroadleafInstrumentationSavingAgent", (ClassLoader)BroadleafLoadTimeWeaver.class.getClassLoader());
    private final ClassLoader classLoader;
    private final Instrumentation instrumentation;
    private final List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>(4);

    public BroadleafLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public BroadleafLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null");
        this.classLoader = classLoader;
        this.instrumentation = BroadleafLoadTimeWeaver.getInstrumentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull((Object)transformer, (String)"Transformer must not be null");
        FilteringClassFileTransformer actualTransformer = new FilteringClassFileTransformer(transformer, this.classLoader);
        List<ClassFileTransformer> list = this.transformers;
        synchronized (list) {
            if (this.instrumentation == null) {
                throw new IllegalStateException("Must start with Java agent to use InstrumentationLoadTimeWeaver. See Spring documentation.");
            }
            this.instrumentation.addTransformer(actualTransformer, true);
            this.transformers.add(actualTransformer);
        }
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransformers() {
        List<ClassFileTransformer> list = this.transformers;
        synchronized (list) {
            if (!this.transformers.isEmpty()) {
                for (int i = this.transformers.size() - 1; i >= 0; --i) {
                    this.instrumentation.removeTransformer(this.transformers.get(i));
                }
                this.transformers.clear();
            }
        }
    }

    public static boolean isInstrumentationAvailable() {
        return BroadleafLoadTimeWeaver.getInstrumentation() != null;
    }

    protected static Instrumentation getInstrumentation() {
        if (AGENT_CLASS_PRESENT) {
            return InstrumentationAccessor.getInstrumentation();
        }
        return null;
    }

    private static class FilteringClassFileTransformer
    implements ClassFileTransformer {
        private final ClassFileTransformer targetTransformer;
        private final ClassLoader targetClassLoader;

        public FilteringClassFileTransformer(ClassFileTransformer targetTransformer, ClassLoader targetClassLoader) {
            this.targetTransformer = targetTransformer;
            this.targetClassLoader = targetClassLoader;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (!this.targetClassLoader.equals(loader)) {
                return null;
            }
            return this.targetTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }

        public String toString() {
            return "FilteringClassFileTransformer for: " + this.targetTransformer.toString();
        }
    }

    private static class InstrumentationAccessor {
        private InstrumentationAccessor() {
        }

        public static Instrumentation getInstrumentation() {
            return BroadleafInstrumentationSavingAgent.getInstrumentation();
        }
    }
}

