/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.extensibility.jpa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.extensibility.context.ResourceInputStream;
import org.broadleafcommerce.profile.extensibility.context.merge.MergeXmlConfigResource;
import org.broadleafcommerce.profile.extensibility.context.merge.exceptions.MergeException;
import org.broadleafcommerce.profile.extensibility.context.merge.exceptions.MergeManagerSetupException;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class MergeJPAPersistenceResource
extends MergeXmlConfigResource {
    private static final Log LOG = LogFactory.getLog(MergeJPAPersistenceResource.class);
    private ErrorHandler handler = new SimpleSaxErrorHandler(LOG);

    @Override
    public Resource getMergedConfigResource(ResourceInputStream[] sources) throws BeansException {
        ByteArrayResource configResource = null;
        ResourceInputStream merged = null;
        try {
            ArrayList<String> mappingFiles = new ArrayList<String>(20);
            ResourceInputStream[] inMemoryStreams = new ResourceInputStream[sources.length];
            for (int j = 0; j < sources.length; ++j) {
                byte[] sourceArray = this.buildArrayFromStream(sources[j]);
                this.compileMappingFiles(mappingFiles, sourceArray);
                inMemoryStreams[j] = new ResourceInputStream(new ByteArrayInputStream(sourceArray), sources[j].getName());
            }
            merged = this.merge(inMemoryStreams);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean eof = false;
            while (!eof) {
                int temp = merged.read();
                if (temp == -1) {
                    eof = true;
                    continue;
                }
                baos.write(temp);
            }
            configResource = new ByteArrayResource(baos.toByteArray());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Merged config: \n" + this.serialize((Resource)configResource)));
            }
        }
        catch (MergeException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (MergeManagerSetupException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (SAXException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        finally {
            if (merged != null) {
                try {
                    merged.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Unable to merge source and patch locations", e);
                }
            }
        }
        return configResource;
    }

    private void compileMappingFiles(List<String> mappingFiles, byte[] sourceArray) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setErrorHandler(this.handler);
        Document dom = parser.parse(new ByteArrayInputStream(sourceArray));
        NodeList nodes = dom.getElementsByTagName("/persistence/persistence-unit/mapping-file");
        if (nodes != null && nodes.getLength() > 0) {
            int length = nodes.getLength();
            for (int j = 0; j < length; ++j) {
                Node node = nodes.item(j);
                mappingFiles.add(node.getNodeValue());
            }
        }
    }
}

