/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.payment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadleafcommerce.profile.payment.UnmaskRange;

public class AccountNumberMask {
    private List<UnmaskRange> ranges;
    private char maskCharacter;

    public AccountNumberMask(List<UnmaskRange> ranges, char maskCharacter) {
        this.ranges = ranges;
        this.maskCharacter = maskCharacter;
    }

    public String mask(String accountNumber) {
        if (accountNumber == null) {
            throw new RuntimeException("account number is null");
        }
        char[] characters = accountNumber.toCharArray();
        char[] newCharacters = new char[characters.length];
        Arrays.fill(newCharacters, 0, newCharacters.length, this.maskCharacter);
        for (UnmaskRange range : this.ranges) {
            if (range.getPositionType() == 0) {
                System.arraycopy(characters, 0, newCharacters, 0, range.getLength());
                continue;
            }
            System.arraycopy(characters, characters.length - range.getLength(), newCharacters, newCharacters.length - range.getLength(), range.getLength());
        }
        return new String(newCharacters);
    }

    public static void main(String[] args) {
        ArrayList<UnmaskRange> ranges = new ArrayList<UnmaskRange>();
        ranges.add(new UnmaskRange(0, 4));
        ranges.add(new UnmaskRange(1, 4));
        AccountNumberMask mask = new AccountNumberMask(ranges, 'X');
        System.out.println("Card: " + mask.mask("1111111111111111"));
        System.out.println("Card: " + mask.mask("111111111111111"));
    }
}

