/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.payment;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.presentation.BroadleafEnumerationType;

public class CreditCardType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, CreditCardType> TYPES = new HashMap<String, CreditCardType>();
    public static final CreditCardType MASTERCARD = new CreditCardType("MASTERCARD", "Master Card");
    public static final CreditCardType VISA = new CreditCardType("VISA", "Visa");
    public static final CreditCardType AMEX = new CreditCardType("AMEX", "American Express");
    public static final CreditCardType DINERSCLUB_CARTEBLANCHE = new CreditCardType("DINERSCLUB_CARTEBLANCHE", "Diner's Club / Carte Blanche");
    public static final CreditCardType DISCOVER = new CreditCardType("DISCOVER", "Discover");
    public static final CreditCardType ENROUTE = new CreditCardType("ENROUTE", "En Route");
    public static final CreditCardType JCB = new CreditCardType("JCB", "JCB");
    private String type;
    private String friendlyType;

    public static CreditCardType getInstance(String type) {
        return TYPES.get(type);
    }

    public CreditCardType() {
    }

    public CreditCardType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreditCardType other = (CreditCardType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

