/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.util;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public class DependencyLicenseCopy
extends Copy {
    protected File licenseDir = null;
    protected Vector<ResourceCollection> rcs = new Vector();

    public void execute() throws BuildException {
        super.execute();
        try {
            for (int i = 0; i < this.rcs.size(); ++i) {
                ResourceCollection rc = this.rcs.elementAt(i);
                for (Resource r : rc) {
                    if (!r.isExists() || !(r instanceof FileResource)) continue;
                    FileResource fr = (FileResource)r;
                    String baseDir = fr.getBaseDir().getAbsolutePath();
                    String file = fr.getFile().getAbsolutePath();
                    String[] parts = (file = file.substring(baseDir.length(), file.length())).split("/");
                    if (parts.length <= 1) {
                        parts = file.split("\\\\");
                    }
                    if (parts.length <= 1) {
                        throw new BuildException("Unable to recognize the path separator for src file: " + file);
                    }
                    Object[] specificParts = new String[parts.length - 1];
                    System.arraycopy(parts, 0, specificParts, 0, specificParts.length);
                    String specificFilePart = StringUtils.join((Object[])specificParts, (char)'/') + "/license.txt";
                    File specificFile = new File(this.licenseDir, specificFilePart);
                    File specificDestinationFile = new File(this.destDir, specificFilePart);
                    if (specificFile.exists()) {
                        this.fileUtils.copyFile(specificFile, specificDestinationFile);
                        continue;
                    }
                    Object[] generalParts = new String[3];
                    System.arraycopy(parts, 0, generalParts, 0, 3);
                    String generalFilePart = StringUtils.join((Object[])generalParts, (char)'/') + "/license.txt";
                    File generalFile = new File(this.licenseDir, generalFilePart);
                    if (generalFile.exists()) {
                        this.fileUtils.copyFile(generalFile, specificDestinationFile);
                        continue;
                    }
                    Object[] moreGeneralParts = new String[2];
                    System.arraycopy(parts, 0, moreGeneralParts, 0, 2);
                    String moreGeneralFilePart = StringUtils.join((Object[])moreGeneralParts, (char)'/') + "/license.txt";
                    File moreGeneralFile = new File(this.licenseDir, moreGeneralFilePart);
                    if (!moreGeneralFile.exists()) continue;
                    this.fileUtils.copyFile(moreGeneralFile, specificDestinationFile);
                }
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void add(ResourceCollection res) {
        super.add(res);
        this.rcs.add(res);
    }

    public File getLicenseDir() {
        return this.licenseDir;
    }

    public void setLicenseDir(File licenseDir) {
        this.licenseDir = licenseDir;
    }
}

