/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.vendor.service.monitor;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.broadleafcommerce.profile.vendor.service.monitor.ServiceStatusDetectable;
import org.broadleafcommerce.profile.vendor.service.monitor.StatusHandler;
import org.broadleafcommerce.profile.vendor.service.monitor.handler.LogStatusHandler;
import org.broadleafcommerce.profile.vendor.service.type.ServiceStatusType;

public class ServiceMonitor {
    private static final Log LOG = LogFactory.getLog(ServiceMonitor.class);
    protected Map<ServiceStatusDetectable, StatusHandler> serviceHandlers = new HashMap<ServiceStatusDetectable, StatusHandler>();
    protected StatusHandler defaultHandler = new LogStatusHandler();
    protected Map<ServiceStatusDetectable, ServiceStatusType> statusMap = new HashMap<ServiceStatusDetectable, ServiceStatusType>();

    public synchronized void init() {
        for (ServiceStatusDetectable statusDetectable : this.serviceHandlers.keySet()) {
            this.checkService(statusDetectable);
        }
    }

    public Object checkServiceAOP(ProceedingJoinPoint call) throws Throwable {
        try {
            this.checkService((ServiceStatusDetectable)call.getThis());
        }
        catch (Throwable e) {
            LOG.error((Object)"Could not check service status", e);
        }
        return call.proceed();
    }

    public void checkService(ServiceStatusDetectable statusDetectable) {
        ServiceStatusType type = statusDetectable.getServiceStatus();
        if (!this.statusMap.containsKey(statusDetectable)) {
            this.statusMap.put(statusDetectable, type);
            if (type.equals(ServiceStatusType.DOWN)) {
                this.handleStatusChange(statusDetectable, type);
            }
        }
        if (!this.statusMap.get(statusDetectable).equals(type)) {
            this.handleStatusChange(statusDetectable, type);
            this.statusMap.put(statusDetectable, type);
        }
    }

    protected void handleStatusChange(ServiceStatusDetectable serviceStatus, ServiceStatusType serviceStatusType) {
        if (this.serviceHandlers.containsKey(serviceStatus)) {
            this.serviceHandlers.get(serviceStatus).handleStatus(serviceStatus.getServiceName(), serviceStatusType);
        } else {
            this.defaultHandler.handleStatus(serviceStatus.getServiceName(), serviceStatusType);
        }
    }

    public Map<ServiceStatusDetectable, StatusHandler> getServiceHandlers() {
        return this.serviceHandlers;
    }

    public void setServiceHandlers(Map<ServiceStatusDetectable, StatusHandler> serviceHandlers) {
        this.serviceHandlers = serviceHandlers;
    }

    public StatusHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(StatusHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }
}

